/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.client.model;

import codechicken.lib.render.CCModel;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.buffer.TransformingVertexConsumer;
import codechicken.lib.render.buffer.VBORenderType;
import codechicken.lib.render.model.OBJParser;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Matrix4;
import codechicken.lib.vec.Rotation;
import codechicken.lib.vec.Transformation;
import codechicken.lib.vec.Vector3;
import com.brandon3055.brandonscore.BrandonsCore;
import com.brandon3055.brandonscore.api.TechLevel;
import com.brandon3055.brandonscore.api.TimeKeeper;
import com.brandon3055.brandonscore.client.render.EquippedItemModel;
import com.brandon3055.brandonscore.client.render.RenderUtils;
import com.brandon3055.brandonscore.client.shader.BCShader;
import com.brandon3055.brandonscore.client.shader.BCShaders;
import com.brandon3055.brandonscore.client.shader.ContribShader;
import com.brandon3055.brandonscore.handlers.contributor.Animations;
import com.brandon3055.brandonscore.handlers.contributor.ContributorConfig;
import com.brandon3055.brandonscore.handlers.contributor.ContributorProperties;
import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import java.util.Map;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.registries.ForgeRegistries;

public class ContributorModel<T extends LivingEntity>
extends HumanoidModel<T>
implements EquippedItemModel {
    public ContributorProperties props = new ContributorProperties();
    private static final RenderType BONE_TYPE = ContributorModel.createBoneType("bone", BCShaders.CONTRIB_BASE_SHADER);
    private static final RenderType BONE_CHAOS_TYPE = ContributorModel.createChaosType("bone_chaos", BCShaders.CHAOS_ENTITY_SHADER);
    private static final RenderType BONE_SHADER_TYPE = ContributorModel.createBoneType("bone_shader", BCShaders.WINGS_BONE_SHADER);
    private static final RenderType WEB_TYPE = ContributorModel.createWebType("web", BCShaders.CONTRIB_BASE_SHADER);
    private static final RenderType WEB_SHADER_TYPE = ContributorModel.createWebType("web_shader", BCShaders.WINGS_WEB_SHADER);
    private static final RenderType LOLNET_TYPE = ContributorModel.createBasicBadgeType(new ResourceLocation("brandonscore", "textures/contributor/badges/lolnet.png"), false);
    private static final RenderType CR_TYPE = ContributorModel.createBasicBadgeType(new ResourceLocation("brandonscore", "textures/contributor/badges/cr.png"), false);
    private static final RenderType OG_TYPE = ContributorModel.createBasicBadgeType(new ResourceLocation("brandonscore", "textures/contributor/badges/og_patreon.png"), false);
    private static final RenderType PATREON_LOGO_TYPE = ContributorModel.createBadgeType("badge", BCShaders.BADGE_FOIL_SHADER, new ResourceLocation("brandonscore", "textures/contributor/badges/patreon_base.png"), true);
    private static final RenderType PATREON_LOGO_OUTLINE_TYPE = ContributorModel.createBadgeType("badge", BCShaders.BADGE_OUTLINE_SHADER, new ResourceLocation("brandonscore", "textures/contributor/badges/patreon_base.png"), true);
    private static final RenderType PATREON_CORE_TYPE = ContributorModel.createBadgeType("badge", BCShaders.BADGE_CORE_SHADER, new ResourceLocation("brandonscore", "textures/contributor/badges/patreon_core.png"), true);
    private static final RenderType BADGE_VET_TYPE = ContributorModel.createBadgeType("vet", BCShaders.VET_BADGE_SHADER, new ResourceLocation("brandonscore", "textures/contributor/badges/veteran.png"), false);
    private static final RenderType BADGE_VET_CORE_TYPE = ContributorModel.createBadgeType("vet_over", BCShaders.VET_BADGE_SHADER, new ResourceLocation("brandonscore", "textures/contributor/badges/veteran_overlay.png"), false);
    private final WingBoneRenderer humBone;
    private final WingBoneRenderer radBone;
    private final WingBoneRenderer f1Bone;
    private final WingBoneRenderer f2Bone;
    private final WingBoneRenderer f3Bone;
    private final Item chestpiece1;
    private final Item chestpiece2;
    private final Item chestpiece3;

    public ContributorModel() {
        super(ContributorModel.m_170681_((CubeDeformation)new CubeDeformation(1.0f), (float)0.0f).m_171576_().m_171583_(64, 64));
        Map model = new OBJParser(new ResourceLocation("brandonscore", "models/entity/contributor_wings.obj")).ignoreMtl().parse();
        CCModel hum = ((CCModel)model.get("hum_bone")).backfacedCopy();
        CCModel humShell = ((CCModel)model.get("hum_bone_shell")).backfacedCopy();
        CCModel rad = ((CCModel)model.get("rad_bone")).backfacedCopy();
        CCModel radShell = ((CCModel)model.get("rad_bone_shell")).backfacedCopy();
        CCModel f1 = ((CCModel)model.get("f1_bone")).backfacedCopy();
        CCModel f1Shell = ((CCModel)model.get("f1_bone_shell")).backfacedCopy();
        CCModel f2 = ((CCModel)model.get("f2_bone")).backfacedCopy();
        CCModel f2Shell = ((CCModel)model.get("f2_bone_shell")).backfacedCopy();
        CCModel f3 = ((CCModel)model.get("f3_bone")).backfacedCopy();
        CCModel f3Shell = ((CCModel)model.get("f3_bone_shell")).backfacedCopy();
        this.humBone = new WingBoneRenderer(hum, new Vector3(-1.5, 22.5, 2.0), true);
        this.humBone.shell = new WingBoneRenderer(humShell, Vector3.ZERO, false);
        this.radBone = new WingBoneRenderer(rad, new Vector3(-1.5, 15.0, 2.8), true);
        this.radBone.shell = new WingBoneRenderer(radShell, Vector3.ZERO, false);
        this.f1Bone = new WingBoneRenderer(f1, new Vector3(-1.5, 31.0, 2.8), true);
        this.f1Bone.shell = new WingBoneRenderer(f1Shell, Vector3.ZERO, false);
        this.f2Bone = new WingBoneRenderer(f2, new Vector3(-1.5, 31.0, 2.8), true);
        this.f2Bone.shell = new WingBoneRenderer(f2Shell, Vector3.ZERO, false);
        this.f3Bone = new WingBoneRenderer(f3, new Vector3(-1.5, 31.0, 2.8), true);
        this.f3Bone.shell = new WingBoneRenderer(f3Shell, Vector3.ZERO, false);
        this.chestpiece1 = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("draconicevolution:wyvern_chestpiece"));
        this.chestpiece2 = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("draconicevolution:draconic_chestpiece"));
        this.chestpiece3 = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("draconicevolution:chaotic_chestpiece"));
    }

    @Override
    public void render(LivingEntity entity, PoseStack poseStack, MultiBufferSource buffers, ItemStack stack, int packedLight, int packedOverlay, float partialTicks) {
        if (!this.props.isContributor()) {
            return;
        }
        BCShaders.CONTRIB_BASE_SHADER.getUv1OverrideUniform().glUniform2i(packedOverlay & 0xFFFF, packedOverlay >> 16 & 0xFFFF);
        BCShaders.CONTRIB_BASE_SHADER.getUv2OverrideUniform().glUniform2i(packedLight & 0xFFFF, packedLight >> 16 & 0xFFFF);
        ContributorConfig config = this.props.getConfig();
        if (this.f_102610_) {
            poseStack.m_85836_();
            float f1 = 1.0f / this.f_102011_;
            poseStack.m_85841_(f1, f1, f1);
            poseStack.m_85837_(0.0, (double)(this.f_102012_ / 16.0f), 0.0);
            this.renderBadges(config, entity, poseStack, buffers, packedLight, packedOverlay, partialTicks);
            this.renderWings(config, entity, poseStack, buffers, packedLight, packedOverlay, partialTicks);
            poseStack.m_85849_();
        } else {
            this.renderBadges(config, entity, poseStack, buffers, packedLight, packedOverlay, partialTicks);
            this.renderWings(config, entity, poseStack, buffers, packedLight, packedOverlay, partialTicks);
        }
    }

    private void renderBadges(ContributorConfig config, LivingEntity entity, PoseStack poseStack, MultiBufferSource buffers, int packedLight, int packedOverlay, float partialTicks) {
        boolean hasChestpiece;
        BCShaders.CONTRIB_BASE_SHADER.getDecayUniform().glUniform1f(0.0f);
        CCRenderState ccrs = CCRenderState.instance();
        ccrs.reset();
        poseStack.m_85836_();
        this.f_102810_.m_104299_(poseStack);
        Matrix4 mat = new Matrix4(poseStack);
        poseStack.m_85849_();
        ItemStack armorStack = entity.m_6844_(EquipmentSlot.CHEST);
        boolean armor = armorStack.m_41720_() instanceof ArmorItem;
        boolean bl = hasChestpiece = !armorStack.m_41619_() && this.isChestpiece(armorStack.m_41720_());
        if (hasChestpiece) {
            armor = false;
        }
        if (!hasChestpiece && BrandonsCore.equipmentManager != null) {
            ItemStack stack = BrandonsCore.equipmentManager.findMatchingItem(e -> this.isChestpiece(e.m_41720_()), entity);
            hasChestpiece = !stack.m_41619_();
        }
        this.drawBadge(ccrs, mat.copy(), buffers, config.getChestBadge(), config, false, armor, hasChestpiece, partialTicks);
        this.drawBadge(ccrs, mat.copy(), buffers, config.getBackBadge(), config, true, armor, hasChestpiece, partialTicks);
    }

    private void drawBadge(CCRenderState ccrs, Matrix4 mat, MultiBufferSource buffers, ContributorConfig.Badge badge, ContributorConfig config, boolean onBack, boolean onArmor, boolean hasChestpiece, float partialTicks) {
        switch (badge) {
            case DISABLED: {
                break;
            }
            case PATREON_OG: {
                this.drawBadgeBasic(ccrs, mat.copy(), buffers, OG_TYPE, onBack, onArmor, hasChestpiece, 0.0, true, 0.0f);
                break;
            }
            case PATREON_DRACONIUM: {
                this.drawDEBadge(ccrs, mat, buffers, TechLevel.DRACONIUM, config, onBack, onArmor, hasChestpiece);
                break;
            }
            case PATREON_WYVERN: {
                this.drawDEBadge(ccrs, mat, buffers, TechLevel.WYVERN, config, onBack, onArmor, hasChestpiece);
                break;
            }
            case PATREON_DRACONIC: {
                this.drawDEBadge(ccrs, mat, buffers, TechLevel.DRACONIC, config, onBack, onArmor, hasChestpiece);
                break;
            }
            case PATREON_CHAOTIC: {
                this.drawDEBadge(ccrs, mat, buffers, TechLevel.CHAOTIC, config, onBack, onArmor, hasChestpiece);
                break;
            }
            case OG_VETERAN: {
                float[] colour = ContributorConfig.unpack(config.getBaseColourI(TechLevel.DRACONIC));
                BCShaders.VET_BADGE_SHADER.getBaseColorUniform().glUniform4f(colour[0], colour[1], colour[2], 1.0f);
                BCShaders.VET_BADGE_SHADER.getDecayUniform().glUniform1f(0.01f);
                this.drawBadge(ccrs, mat.copy(), buffers, BCShaders.VET_BADGE_SHADER, BADGE_VET_TYPE, onBack, onArmor, hasChestpiece, 0.0, false, ((float)TimeKeeper.getClientTick() + partialTicks) / 2.0f % 360.0f);
                BCShaders.VET_BADGE_SHADER.getDecayUniform().glUniform1f(0.1f);
                BCShaders.VET_BADGE_SHADER.getBaseColorUniform().glUniform4f(0.75f, 0.75f, 0.75f, 0.0f);
                this.drawBadge(ccrs, mat.copy(), buffers, BCShaders.VET_BADGE_SHADER, BADGE_VET_CORE_TYPE, onBack, onArmor, hasChestpiece, 0.001, false, 0.0f);
                break;
            }
            case LOLNET: {
                this.drawBadgeBasic(ccrs, mat.copy(), buffers, LOLNET_TYPE, onBack, onArmor, hasChestpiece, 0.0, true, 0.0f);
                break;
            }
            case CR: {
                this.drawBadgeBasic(ccrs, mat.copy(), buffers, CR_TYPE, onBack, onArmor, hasChestpiece, 0.0, true, 0.0f);
            }
        }
    }

    private void drawBadge(CCRenderState ccrs, Matrix4 mat, MultiBufferSource buffers, BCShader<?> shader, RenderType type, boolean onBack, boolean onArmor, boolean hasChestpiece, double zOffset, boolean glint, float rotation) {
        float scale;
        float p = 0.0625f;
        float f = scale = onBack ? p * 6.0f : p * 3.0f;
        if (onBack) {
            mat.rotate(3.1415926535897403, Vector3.Y_NEG);
        }
        mat.translate(onBack ? 0.0 : (double)(p * 2.0f), onBack ? (double)(p * 4.0f) : (double)(p * 2.0f), (double)p * (onArmor ? -3.1 : -2.275) - zOffset);
        if (hasChestpiece) {
            if (onBack && !onArmor) {
                scale = p * 2.5f;
            } else if (!onBack) {
                scale = p * 2.0f;
                mat.translate((double)(p * -2.0f), (double)(p * 2.0f), (double)p * (onArmor ? -1.1 : -1.4));
            }
        }
        mat.scale((double)scale, (double)scale, (double)scale);
        if (rotation != 0.0f) {
            mat.rotate((double)rotation * 0.017453292519943, Vector3.Z_NEG);
        }
        mat.translate(-0.5, -0.5, 0.0);
        shader.getModelMatUniform().glUniformMatrix4f(mat);
        VertexConsumer consumer = buffers.m_6299_(type);
        ccrs.bind(consumer, DefaultVertexFormat.f_85812_);
        ccrs.startDrawing(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85812_);
        this.addVertex(consumer, 0.0, 0.0, 0.0, 0.0f, 0.0f);
        this.addVertex(consumer, 0.0, 1.0, 0.0, 0.0f, 1.0f);
        this.addVertex(consumer, 1.0, 1.0, 0.0, 1.0f, 1.0f);
        this.addVertex(consumer, 1.0, 0.0, 0.0, 1.0f, 0.0f);
        ccrs.draw();
        RenderUtils.endBatch(buffers);
    }

    private void drawBadgeBasic(CCRenderState ccrs, Matrix4 mat, MultiBufferSource buffers, RenderType type, boolean onBack, boolean onArmor, boolean hasChestpiece, double zOffset, boolean glint, float rotation) {
        float scale;
        float p = 0.0625f;
        float f = scale = onBack ? p * 6.0f : p * 3.0f;
        if (onBack) {
            mat.rotate(3.1415926535897403, Vector3.Y_NEG);
        }
        mat.translate(onBack ? 0.0 : (double)(p * 2.0f), onBack ? (double)(p * 4.0f) : (double)(p * 2.0f), (double)p * (onArmor ? -3.1 : -2.275) - zOffset);
        if (hasChestpiece) {
            if (onBack && !onArmor) {
                scale = p * 2.5f;
            } else if (!onBack) {
                scale = p * 2.0f;
                mat.translate((double)(p * -2.0f), (double)(p * 2.0f), (double)p * (onArmor ? -2.225 : -1.4));
            }
        }
        mat.scale((double)scale, (double)scale, (double)scale);
        if (rotation != 0.0f) {
            mat.rotate((double)rotation * 0.017453292519943, Vector3.Z_NEG);
        }
        mat.translate(-0.5, -0.5, 0.0);
        TransformingVertexConsumer consumer = new TransformingVertexConsumer(buffers.m_6299_(type), (Transformation)mat);
        ccrs.bind((VertexConsumer)consumer, DefaultVertexFormat.f_85820_);
        ccrs.startDrawing(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85820_);
        this.addBasicVertex((VertexConsumer)consumer, 0.0, 0.0, 0.0, 0.0f, 0.0f);
        this.addBasicVertex((VertexConsumer)consumer, 0.0, 1.0, 0.0, 0.0f, 1.0f);
        this.addBasicVertex((VertexConsumer)consumer, 1.0, 1.0, 0.0, 1.0f, 1.0f);
        this.addBasicVertex((VertexConsumer)consumer, 1.0, 0.0, 0.0, 1.0f, 0.0f);
        ccrs.draw();
        if (glint) {
            consumer = new TransformingVertexConsumer(buffers.m_6299_(RenderType.m_110481_()), (Transformation)mat);
            ccrs.bind((VertexConsumer)consumer, DefaultVertexFormat.f_85812_);
            ccrs.startDrawing(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85812_);
            this.addVertex((VertexConsumer)consumer, 0.0, 0.0, 0.0, 0.0f, 0.0f);
            this.addVertex((VertexConsumer)consumer, 0.0, 1.0, 0.0, 0.0f, p / 4.0f);
            this.addVertex((VertexConsumer)consumer, 1.0, 1.0, 0.0, p / 4.0f, p / 4.0f);
            this.addVertex((VertexConsumer)consumer, 1.0, 0.0, 0.0, p / 4.0f, 0.0f);
            ccrs.draw();
        }
        RenderUtils.endBatch(buffers);
    }

    private void drawDEBadge(CCRenderState ccrs, Matrix4 mat, MultiBufferSource buffers, TechLevel tier, ContributorConfig config, boolean onBack, boolean onArmor, boolean hasChestpiece) {
        float[] colour = ContributorConfig.unpack(config.getBaseColourI(tier));
        BCShaders.BADGE_FOIL_SHADER.getBaseColorUniform().glUniform4f(1.0f, 0.259f, 0.302f, 1.0f);
        this.drawBadge(ccrs, mat.copy(), buffers, BCShaders.BADGE_FOIL_SHADER, PATREON_LOGO_TYPE, onBack, onArmor, hasChestpiece, 0.0, false, 0.0f);
        this.drawBadge(ccrs, mat.copy(), buffers, BCShaders.BADGE_OUTLINE_SHADER, PATREON_LOGO_OUTLINE_TYPE, onBack, onArmor, hasChestpiece, 0.0, false, 0.0f);
        BCShaders.BADGE_CORE_SHADER.getBaseColorUniform().glUniform4f(colour[0], colour[1], colour[2], colour[3]);
        this.drawBadge(ccrs, mat.copy(), buffers, BCShaders.BADGE_CORE_SHADER, PATREON_CORE_TYPE, onBack, onArmor, hasChestpiece, 0.0, false, 0.0f);
    }

    private void renderWings(ContributorConfig config, LivingEntity entity, PoseStack poseStack, MultiBufferSource buffers, int packedLight, int packedOverlay, float partialTicks) {
        if (!this.props.hasWings() || !(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        Animations anim = this.props.getAnim();
        anim.setPlayer(player);
        if (anim.hideDecay() == 1.0f) {
            return;
        }
        float[] boneColour = config.getWingBoneColour(partialTicks);
        float[] webColour = config.getWingWebColour(partialTicks);
        boolean chaos = config.getWingRenderTier() == TechLevel.CHAOTIC && !config.overrideWingBoneColour();
        float rm = chaos && anim.hideDecay() != 0.0f ? 0.35f : 1.0f;
        chaos = chaos && anim.hideDecay() == 0.0f;
        BCShaders.WINGS_BONE_SHADER.getBaseColorUniform().glUniform4f(boneColour[0] * rm, boneColour[1], boneColour[2], boneColour[3]);
        BCShaders.WINGS_WEB_SHADER.getBaseColorUniform().glUniform4f(webColour[0], webColour[1], webColour[2], webColour[3]);
        BCShaders.CONTRIB_BASE_SHADER.getDecayUniform().glUniform1f(anim.hideDecay());
        BCShaders.WINGS_BONE_SHADER.getDecayUniform().glUniform1f(anim.hideDecay());
        BCShaders.WINGS_WEB_SHADER.getDecayUniform().glUniform1f(anim.hideDecay());
        boolean fancyBones = config.getWingsBoneShader();
        boolean fancyWebs = config.getWingsWebShader();
        ContribShader webShader = fancyWebs ? BCShaders.WINGS_WEB_SHADER : BCShaders.CONTRIB_BASE_SHADER;
        RenderType webType = fancyWebs ? WEB_SHADER_TYPE : WEB_TYPE;
        double yComp = config.getWingsWebShader() ? 0.1 : 0.0;
        double extension = anim.getWingExt(partialTicks);
        double fold = anim.getWingFold(partialTicks);
        double flap = anim.getWingFlap(partialTicks);
        double flap2 = anim.getWingFlap2(partialTicks);
        double pitch = anim.getWingPitch(partialTicks);
        float livingAnim = (float)entity.f_19797_ + partialTicks;
        extension += (double)(Mth.m_14089_((float)(livingAnim * 0.029f)) * 0.05f + 0.05f);
        fold += (double)(Mth.m_14031_((float)(livingAnim * 0.067f)) * 0.05f);
        Vector3 webOrigin = new Vector3(-1.5, 31.0, 2.8).multiply(0.0625);
        poseStack.m_85836_();
        this.f_102810_.m_104299_(poseStack);
        poseStack.m_252781_(Axis.f_252403_.m_252977_(180.0f));
        poseStack.m_85837_(0.0, -1.5, 0.0);
        Matrix4 mat = new Matrix4(poseStack);
        poseStack.m_85849_();
        Matrix4 lMat = mat.copy();
        this.humBone.xRot = Mth.m_14139_((double)pitch, (double)0.0, (double)15.0);
        this.humBone.yRot = Mth.m_14139_((double)fold, (double)45.0, (double)10.0) + Mth.m_14139_((double)flap, (double)0.0, (double)35.0);
        this.humBone.zRot = Mth.m_14139_((double)extension, (double)-15.0, (double)-80.0);
        this.humBone.render(lMat, buffers, fancyBones, chaos);
        this.radBone.zRot = Mth.m_14139_((double)extension, (double)30.0, (double)130.0);
        this.radBone.render(lMat, buffers, fancyBones, chaos);
        this.f1Bone.zRot = Mth.m_14139_((double)extension, (double)157.5, (double)40.0);
        this.f1Bone.xRot = Mth.m_14139_((double)flap2, (double)0.0, (double)-25.0);
        this.f1Bone.render(lMat.copy(), buffers, fancyBones, chaos);
        this.f2Bone.zRot = Mth.m_14139_((double)extension, (double)165.0, (double)80.0);
        this.f2Bone.xRot = this.f2Bone.yRot = Mth.m_14139_((double)flap2, (double)0.0, (double)-10.0);
        this.f2Bone.render(lMat.copy(), buffers, fancyBones, chaos);
        this.f3Bone.zRot = Mth.m_14139_((double)extension, (double)172.5, (double)140.0);
        this.f3Bone.xRot = Mth.m_14139_((double)flap2, (double)0.0, (double)5.0);
        this.f3Bone.yRot = this.f3Bone.xRot * -0.5;
        this.f3Bone.render(lMat.copy(), buffers, fancyBones, chaos);
        this.renderWingWeb(webShader, webType, webOrigin, lMat.copy(), buffers, 24.0 + yComp, this.f1Bone.getRotation(), 17.0 + yComp, this.f2Bone.getRotation());
        this.renderWingWeb(webShader, webType, webOrigin, lMat.copy(), buffers, 17.0 + yComp, this.f2Bone.getRotation(), 14.0 + yComp, this.f3Bone.getRotation());
        this.renderWingWeb(webShader, webType, webOrigin, lMat.copy(), buffers, 14.0 + yComp, this.f3Bone.getRotation(), 17.0 + yComp, new Vector3(0.0, 0.0, 3.1415926535897403));
        Matrix4 rMat = mat.copy();
        rMat.translate(0.1875, 0.0, 0.0);
        this.humBone.yRot *= -1.0;
        this.humBone.zRot *= -1.0;
        this.humBone.render(rMat, buffers, fancyBones, chaos);
        this.radBone.zRot *= -1.0;
        this.radBone.render(rMat, buffers, fancyBones, chaos);
        this.f1Bone.zRot *= -1.0;
        this.f1Bone.render(rMat.copy(), buffers, fancyBones, chaos);
        this.f2Bone.zRot *= -1.0;
        this.f2Bone.yRot *= -1.0;
        this.f2Bone.render(rMat.copy(), buffers, fancyBones, chaos);
        this.f3Bone.zRot *= -1.0;
        this.f3Bone.yRot *= -1.0;
        this.f3Bone.render(rMat.copy(), buffers, fancyBones, chaos);
        this.renderWingWeb(webShader, webType, webOrigin, rMat.copy(), buffers, 24.0 + yComp, this.f1Bone.getRotation(), 17.0 + yComp, this.f2Bone.getRotation());
        this.renderWingWeb(webShader, webType, webOrigin, rMat.copy(), buffers, 17.0 + yComp, this.f2Bone.getRotation(), 14.0 + yComp, this.f3Bone.getRotation());
        this.renderWingWeb(webShader, webType, webOrigin, rMat.copy(), buffers, 14.0 + yComp, this.f3Bone.getRotation(), 17.0 + yComp, new Vector3(0.0, 0.0, 3.1415926535897403));
    }

    public void renderWingWeb(BCShader<?> shader, RenderType renderType, Vector3 origin, Matrix4 mat, MultiBufferSource buffers, double len1, Vector3 rot1, double len2, Vector3 rot2) {
        mat.translate(origin);
        shader.getModelMatUniform().glUniformMatrix4f(mat);
        Vector3 v0 = Vector3.ZERO;
        Vector3 v1 = new Vector3(0.0, len1 *= 0.0625, 0.0).apply((Transformation)new Rotation(rot1.z, Vector3.Z_POS)).apply((Transformation)new Rotation(rot1.y, Vector3.Y_POS)).apply((Transformation)new Rotation(rot1.x, Vector3.X_POS));
        Vector3 v2 = new Vector3(0.0, len2 *= 0.0625, 0.0).apply((Transformation)new Rotation(rot2.z, Vector3.Z_POS)).apply((Transformation)new Rotation(rot2.y, Vector3.Y_POS)).apply((Transformation)new Rotation(rot2.x, Vector3.X_POS));
        CCRenderState ccrs = CCRenderState.instance();
        ccrs.reset();
        VertexConsumer consumer = buffers.m_6299_(renderType);
        ccrs.bind(consumer, DefaultVertexFormat.f_85812_);
        ccrs.startDrawing(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85812_);
        this.addVertex(consumer, v1, 0.0f, 1.0f);
        this.addVertex(consumer, v0, 0.5f, 0.0f);
        this.addVertex(consumer, v2, 1.0f, 1.0f);
        this.addVertex(consumer, v2, 1.0f, 1.0f);
        ccrs.draw();
        RenderUtils.endBatch(buffers);
    }

    private void addVertex(VertexConsumer consumer, Vector3 vert, float u, float v) {
        consumer.m_5483_(vert.x, vert.y, vert.z).m_193479_(-1).m_7421_(u, v).m_86008_(OverlayTexture.f_118083_).m_85969_(240).m_5601_(0.5f, 0.5f, 0.5f).m_5752_();
    }

    private void addVertex(VertexConsumer consumer, double x, double y, double z, float u, float v) {
        consumer.m_5483_(x, y, z).m_193479_(-1).m_7421_(u, v).m_86008_(OverlayTexture.f_118083_).m_85969_(240).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
    }

    private void addBasicVertex(VertexConsumer consumer, double x, double y, double z, float u, float v) {
        consumer.m_5483_(x, y, z).m_193479_(-1).m_7421_(u, v).m_86008_(OverlayTexture.f_118083_).m_85969_(240).m_5752_();
    }

    private boolean isChestpiece(Item item) {
        return this.chestpiece1 != null && (item == this.chestpiece1 || item == this.chestpiece2 || item == this.chestpiece3);
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer consumer, int packedLight, int packedOverlay, float r, float g, float b, float a) {
    }

    protected Iterable<ModelPart> m_5607_() {
        return ImmutableList.of();
    }

    protected Iterable<ModelPart> m_5608_() {
        return ImmutableList.of();
    }

    private static RenderType createBoneType(String name, ContribShader shader) {
        return RenderType.m_173215_((String)("brandonscore:" + name), (VertexFormat)DefaultVertexFormat.f_85812_, (VertexFormat.Mode)VertexFormat.Mode.TRIANGLES, (int)256, (boolean)false, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173292_(new RenderStateShard.ShaderStateShard(shader::getShaderInstance)).m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(new ResourceLocation("brandonscore", "textures/contributor/contributor_wings_bones.png"), false, false)).m_110671_(RenderStateShard.f_110152_).m_110677_(RenderStateShard.f_110154_).m_110691_(false));
    }

    private static RenderType createChaosType(String name, BCShader<?> shader) {
        return RenderType.m_173209_((String)("brandonscore:" + name), (VertexFormat)DefaultVertexFormat.f_85812_, (VertexFormat.Mode)VertexFormat.Mode.TRIANGLES, (int)256, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173292_(new RenderStateShard.ShaderStateShard(shader::getShaderInstance)).m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(new ResourceLocation("brandonscore", "textures/chaos_shader.png"), true, false)).m_110671_(RenderStateShard.f_110152_).m_110677_(RenderStateShard.f_110154_).m_110691_(false));
    }

    private static RenderType createWebType(String name, ContribShader shader) {
        return RenderType.m_173215_((String)("brandonscore:" + name), (VertexFormat)DefaultVertexFormat.f_85812_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)false, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173292_(new RenderStateShard.ShaderStateShard(shader::getShaderInstance)).m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(new ResourceLocation("brandonscore", "textures/contributor/contributor_wings_web.png"), false, false)).m_110671_(RenderStateShard.f_110152_).m_110677_(RenderStateShard.f_110154_).m_110661_(RenderStateShard.f_110110_).m_110691_(false));
    }

    private static RenderType createBadgeType(String name, BCShader<?> shader, ResourceLocation texture, boolean blur) {
        return RenderType.m_173215_((String)("brandonscore:badge" + name), (VertexFormat)DefaultVertexFormat.f_85812_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)false, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173292_(new RenderStateShard.ShaderStateShard(shader::getShaderInstance)).m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(texture, blur, false)).m_110685_(RenderType.f_110139_).m_110671_(RenderStateShard.f_110152_).m_110677_(RenderStateShard.f_110154_).m_110691_(false));
    }

    private static RenderType createBasicBadgeType(ResourceLocation texture, boolean blur) {
        return RenderType.m_173215_((String)"brandonscore:basic_badge", (VertexFormat)DefaultVertexFormat.f_85820_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)true, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173292_(new RenderStateShard.ShaderStateShard(GameRenderer::m_172835_)).m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(texture, blur, false)).m_110685_(RenderType.f_110139_).m_110661_(RenderType.f_110110_).m_110671_(RenderType.f_110152_).m_110677_(RenderType.f_110154_).m_110669_(RenderType.f_110119_).m_110691_(true));
    }

    public static class WingBoneRenderer {
        private WingBoneRenderer shell = null;
        private final VBORenderType baseType;
        private VBORenderType fancyType;
        private VBORenderType chaosType;
        private final Vector3 pivot;
        public double xRot = 0.0;
        public double yRot = 0.0;
        public double zRot = 0.0;

        public WingBoneRenderer(CCModel model, Vector3 pivot, boolean core) {
            this.pivot = pivot.multiply(0.0625);
            this.baseType = new VBORenderType(BONE_TYPE, (format, builder) -> {
                CCRenderState ccrs = CCRenderState.instance();
                ccrs.reset();
                ccrs.bind((VertexConsumer)builder, format);
                model.render(ccrs, new IVertexOperation[0]);
            });
            if (core) {
                this.fancyType = new VBORenderType(BONE_SHADER_TYPE, (format, builder) -> {
                    CCRenderState ccrs = CCRenderState.instance();
                    ccrs.reset();
                    ccrs.bind((VertexConsumer)builder, format);
                    model.render(ccrs, new IVertexOperation[0]);
                });
                this.chaosType = new VBORenderType(BONE_CHAOS_TYPE, (format, builder) -> {
                    CCRenderState ccrs = CCRenderState.instance();
                    ccrs.reset();
                    ccrs.bind((VertexConsumer)builder, format);
                    model.render(ccrs, new IVertexOperation[0]);
                });
            }
        }

        public void render(Matrix4 mat, MultiBufferSource buffers) {
            this.render(mat, buffers, false, false);
        }

        public void render(Matrix4 mat, MultiBufferSource buffers, boolean fancy, boolean chaos) {
            VBORenderType type;
            if (this.xRot != 0.0) {
                mat.apply(new Rotation(this.xRot * 0.017453292519943, Vector3.X_POS).at(this.pivot));
            }
            if (this.yRot != 0.0) {
                mat.apply(new Rotation(this.yRot * 0.017453292519943, Vector3.Y_POS).at(this.pivot));
            }
            if (this.zRot != 0.0) {
                mat.apply(new Rotation(this.zRot * 0.017453292519943, Vector3.Z_POS).at(this.pivot));
            }
            VBORenderType vBORenderType = fancy ? (chaos ? this.chaosType : this.fancyType) : (type = this.baseType);
            ContribShader shader = fancy ? (chaos ? BCShaders.CHAOS_ENTITY_SHADER : BCShaders.WINGS_BONE_SHADER) : BCShaders.CONTRIB_BASE_SHADER;
            buffers.m_6299_((RenderType)type.withCallback(() -> shader.getModelMatUniform().glUniformMatrix4f(mat)));
            RenderUtils.endBatch(buffers);
            if (this.shell != null && fancy) {
                this.shell.render(mat, buffers);
            }
        }

        public Vector3 getRotation() {
            return new Vector3(this.xRot, this.yRot, this.zRot).multiply(0.017453292519943);
        }
    }
}

