/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.capability;

import com.brandon3055.brandonscore.capability.CapabilityOP;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;

public class MultiCapabilityProvider
implements ICapabilitySerializable<CompoundTag> {
    private Map<Capability<?>, Object> capabilityMap = new HashMap();
    private Map<String, INBTSerializable<CompoundTag>> nameMap = new HashMap<String, INBTSerializable<CompoundTag>>();

    public MultiCapabilityProvider() {
    }

    public MultiCapabilityProvider(INBTSerializable<CompoundTag> capInstance, String name, Capability<?> ... capabilities) {
        this.addCapability(capInstance, name, capabilities);
    }

    public void addCapability(INBTSerializable<CompoundTag> capInstance, String name, Capability<?> ... capabilities) {
        if (CapabilityOP.OP == null) {
            return;
        }
        this.nameMap.put(name, capInstance);
        for (Capability<?> cap : capabilities) {
            Objects.requireNonNull(cap);
            this.capabilityMap.put(cap, capInstance);
        }
    }

    public <T> void addUnsavedCap(Capability<T> capability, T capInstance) {
        if (CapabilityOP.OP == null) {
            return;
        }
        this.capabilityMap.put(capability, capInstance);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (this.capabilityMap.containsKey(cap)) {
            return LazyOptional.of(() -> this.capabilityMap.get(cap)).cast();
        }
        return LazyOptional.empty();
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        this.nameMap.forEach((s, t) -> tag.m_128365_(s, t.serializeNBT()));
        return tag;
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.nameMap.forEach((s, t) -> t.deserializeNBT((Tag)nbt.m_128469_(s)));
    }
}

