/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.api;

import java.util.Locale;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.Tier;

public enum TechLevel {
    DRACONIUM(0, ChatFormatting.WHITE, Rarity.COMMON, 3),
    WYVERN(1, ChatFormatting.BLUE, Rarity.UNCOMMON, 32),
    DRACONIC(2, ChatFormatting.GOLD, Rarity.RARE, 128),
    CHAOTIC(3, ChatFormatting.DARK_PURPLE, Rarity.EPIC, 512);

    public final int index;
    private final ChatFormatting textColour;
    private Rarity rarity;
    private final int harvestLevel;
    private Tier itemTier;
    public static final TechLevel[] VALUES;
    public static final TechLevel[] TOOL_LEVELS;

    private TechLevel(int index, ChatFormatting colour, Rarity rarity, int harvestLevel) {
        this.index = index;
        this.textColour = colour;
        this.rarity = rarity;
        this.harvestLevel = harvestLevel;
    }

    public ChatFormatting getTextColour() {
        return this.textColour;
    }

    public Component getDisplayName() {
        return Component.m_237115_((String)("tech_level.draconicevolution." + this.name().toLowerCase(Locale.ENGLISH)));
    }

    public Rarity getRarity() {
        return this.rarity;
    }

    public int getHarvestLevel() {
        return this.harvestLevel;
    }

    public static TechLevel byIndex(int index) {
        return index >= 0 && index < VALUES.length ? VALUES[index] : DRACONIUM;
    }

    static {
        VALUES = new TechLevel[4];
        TOOL_LEVELS = new TechLevel[3];
        TechLevel[] techLevelArray = TechLevel.values();
        int n = techLevelArray.length;
        for (int i = 0; i < n; ++i) {
            TechLevel tier;
            TechLevel.VALUES[tier.index] = tier = techLevelArray[i];
            if (tier == DRACONIUM) continue;
            TechLevel.TOOL_LEVELS[tier.index - 1] = tier;
        }
    }
}

