/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.machines.utils.handler;

import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;
import tv.soaryn.xycraft.machines.config.MachinesConfig;

public class InfiniteFluidHandler
implements IFluidHandler {
    public LazyOptional<IFluidHandler> Handle = LazyOptional.of(() -> this);
    private FluidStack _selected = FluidStack.EMPTY;

    public FluidStack getSelected() {
        if (this._selected.isEmpty()) {
            return FluidStack.EMPTY;
        }
        FluidStack stack = this._selected.copy();
        stack.setAmount(((Integer)MachinesConfig.SelectorFluidAmount.get()).intValue());
        return stack;
    }

    public boolean setSelected(FluidStack stack) {
        if (!this._selected.isFluidEqual(stack)) {
            this._selected = stack.copy();
            return true;
        }
        return false;
    }

    public int getTanks() {
        return 1;
    }

    @NotNull
    public FluidStack getFluidInTank(int tank) {
        if (this._selected.isEmpty()) {
            return FluidStack.EMPTY;
        }
        FluidStack stack = this._selected.copy();
        stack.setAmount(1000000000);
        return stack;
    }

    public int getTankCapacity(int tank) {
        return 1000000000;
    }

    public boolean isFluidValid(int tank, @NotNull FluidStack stack) {
        return false;
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        return 0;
    }

    @NotNull
    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        if (this._selected.isEmpty()) {
            return FluidStack.EMPTY;
        }
        FluidStack stack = this._selected.copy();
        if (resource.isFluidEqual(stack)) {
            return resource.copy();
        }
        return FluidStack.EMPTY;
    }

    @NotNull
    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        if (this._selected.isEmpty()) {
            return FluidStack.EMPTY;
        }
        FluidStack stack = this._selected.copy();
        stack.setAmount(maxDrain);
        return stack;
    }
}

