/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.machines.gui;

import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.TransientCraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import tv.soaryn.xycraft.core.ui.BaseMenu;
import tv.soaryn.xycraft.core.utils.container.EmptyMenu;
import tv.soaryn.xycraft.core.utils.container.GhostSlot;
import tv.soaryn.xycraft.core.utils.container.ItemContainer;
import tv.soaryn.xycraft.core.utils.container.SimpleItemContainer;
import tv.soaryn.xycraft.machines.content.MachinesContent;
import tv.soaryn.xycraft.machines.content.MachinesMenuContent;
import tv.soaryn.xycraft.machines.content.blocks.FabricatorBlockEntity;

public class FabricatorMenu
extends BaseMenu {
    public final FabricatorBlockEntity BlockEntity;
    public final ContainerData menuData;
    private final Level _level;

    public FabricatorMenu(int id, Inventory inventory, FriendlyByteBuf data) {
        this(id, inventory, inventory.f_35978_.m_9236_().m_7702_(data.m_130135_()), (ItemContainer)new SimpleItemContainer(9), (ItemContainer)new SimpleItemContainer(10), (ContainerData)new SimpleContainerData(3));
    }

    public FabricatorMenu(int id, Inventory inventory, BlockEntity entity, ItemContainer inventoryContainer, ItemContainer ghostContainer, ContainerData dataContainer) {
        super(MachinesMenuContent.Fabricator, id, inventory, null, 192, 200);
        this.menuData = dataContainer;
        FabricatorMenu.m_38886_((ContainerData)this.menuData, (int)3);
        this.m_38884_(this.menuData);
        this.BlockEntity = (FabricatorBlockEntity)entity;
        this._level = inventory.f_35978_.m_9236_();
        BaseMenu.Region playerRegion = this.createRegion();
        BaseMenu.Region inventoryRegion = this.createRegion();
        BaseMenu.Region ghostRegion = this.createRegion();
        BaseMenu.Region outputGhostRegion = this.createRegion();
        playerRegion.addShiftTargets(new BaseMenu.RegionHandle[]{inventoryRegion});
        inventoryRegion.addShiftTargets(new BaseMenu.RegionHandle[]{playerRegion.reversed()});
        playerRegion.addPlayerSlots(20, 108, inventory);
        Iterable grid = ghostRegion.addGhostSlots(13, 16, 3, 3, ghostContainer, 0, 1);
        MinecraftServer server = inventory.f_35978_.m_20194_();
        for (GhostSlot ghostSlot : grid) {
            ghostSlot.setStrictContainer(this.menuData, 0);
        }
        outputGhostRegion.addGhostSlot(85, 34, ghostContainer, 9, 64).lock();
        inventoryRegion.addSlots(131, 16, 3, 3, inventoryContainer, 0);
        if (server == null) {
            return;
        }
        CraftingContainer craftingContainer = FabricatorMenu.createCraftingContainer(ghostContainer, 0);
        RecipeManager recipeManager = server.m_129894_();
        ghostRegion.onChanged(slot -> {
            BlockPos pos = this.BlockEntity.m_58899_();
            BlockState state = this.BlockEntity.m_58900_();
            craftingContainer.m_6836_(slot.getIndex(), slot.m_7993_());
            CraftingRecipe recipe = recipeManager.m_44015_(RecipeType.f_44107_, (Container)craftingContainer, this._level).orElse(null);
            ghostContainer.set(9, null != recipe ? recipe.m_5874_((Container)craftingContainer, this._level.m_9598_()) : ItemStack.f_41583_);
            this.BlockEntity.m_6596_();
            this._level.markAndNotifyBlock(pos, this._level.m_46745_(pos), state, state, 3, 512);
            this._level.m_7260_(pos, state, state, 11);
            this.m_38946_();
        });
    }

    public static CraftingContainer createCraftingContainer(ItemContainer inventory, int offset) {
        TransientCraftingContainer craftingContainer = new TransientCraftingContainer((AbstractContainerMenu)new EmptyMenu(), 3, 3);
        for (int i = 0; i < 9; ++i) {
            craftingContainer.m_6836_(i, inventory.get(i + offset));
        }
        return craftingContainer;
    }

    public boolean m_6875_(@NotNull Player player) {
        return FabricatorMenu.m_38889_((ContainerLevelAccess)ContainerLevelAccess.m_39289_((Level)this._level, (BlockPos)this.BlockEntity.m_58899_()), (Player)player, (Block)MachinesContent.Fabricator.block());
    }

    public void onMessage(int component, FriendlyByteBuf buf) {
        this.menuData.m_8050_(1, (int)buf.readByte());
        this.BlockEntity.m_6596_();
        BlockState state = this.BlockEntity.m_58900_();
        BlockPos pos = this.BlockEntity.m_58899_();
        this._level.m_46597_(pos, state);
        this._level.markAndNotifyBlock(pos, this._level.m_46745_(pos), state, state, 3, 512);
    }
}

