/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.machines.data;

import net.minecraft.data.PackOutput;
import net.minecraftforge.common.crafting.conditions.IConditionBuilder;
import net.minecraftforge.common.data.LanguageProvider;
import net.minecraftforge.fluids.FluidType;
import tv.soaryn.xycraft.core.content.BlockContent;
import tv.soaryn.xycraft.core.content.FluidContent;
import tv.soaryn.xycraft.core.content.IContent;
import tv.soaryn.xycraft.core.content.ItemContent;
import tv.soaryn.xycraft.machines.content.MachinesContent;

public class MachineLanguageDataGen
extends LanguageProvider
implements IConditionBuilder {
    private final String locale;

    public MachineLanguageDataGen(PackOutput output, String modId, String locale) {
        super(output, modId, locale);
        this.locale = locale;
    }

    protected void addTranslations() {
        char r = '\u00a7';
        MachinesContent.Map.MappedContent.forEach(this::handleLang);
        this.handleLang((IContent<?>)MachinesContent.VoidContainer, "%s7Black hole contained within! Can be used to void items.".formatted(Character.valueOf(r)));
        this.handleLang((IContent<?>)MachinesContent.Extractor, "%s7Extracts Items & Fluids out of the environment.".formatted(Character.valueOf(r)));
        this.handleLang((IContent<?>)MachinesContent.Fabricator, "%s7Crafts items automatically.".formatted(Character.valueOf(r)));
        this.handleLang((IContent<?>)MachinesContent.WaterBlock, "%s7Sh\u00c3\u00b6dinger's water block!".formatted(Character.valueOf(r)));
        this.handleLang((IContent<?>)MachinesContent.FluidVoid, "%s7Stops fluids from flowing into adjacent blocks.".formatted(Character.valueOf(r)));
        this.handleLang((IContent<?>)MachinesContent.LightField, "%s7Prevents spawns in a cubed volume.".formatted(Character.valueOf(r)));
        this.handleLang((IContent<?>)MachinesContent.ItemSelector, "%s6Creative item: %s7Creates an unlimited amount of items!".formatted(Character.valueOf(r), Character.valueOf(r)));
        this.handleLang((IContent<?>)MachinesContent.FluidSelector, "%s6Creative item: %s7Creates an unlimited amount of a fluid!".formatted(Character.valueOf(r), Character.valueOf(r)));
        this.handleLang((IContent<?>)MachinesContent.EnergySelector, "%s6Creative item: %s7Creates an unlimited amount of energy!".formatted(Character.valueOf(r), Character.valueOf(r)));
        this.handleLang((IContent<?>)MachinesContent.HydroPump, "%s7Automatically pumps water into connected tank.\n%s7Can be extracted from at a higher rate.".formatted(Character.valueOf(r), Character.valueOf(r)));
        this.handleLang((IContent<?>)MachinesContent.Stake, "%s7How... did you inflate a wool balloon?".formatted(Character.valueOf(r)));
        this.handleLang((IContent<?>)MachinesContent.SoarynBox, "%s7It's not random if you put it there!".formatted(Character.valueOf(r)));
        this.handleLang((IContent<?>)MachinesContent.NitrogenExtractor, "%s770%% seems excessive! Let's bring it down a bit.".formatted(Character.valueOf(r)));
        this.handleLang((IContent<?>)MachinesContent.IgnitionPlate, "%s7Fire on demand!".formatted(Character.valueOf(r)));
        this.handleLang((IContent<?>)MachinesContent.Valve, "%s7Fire on demand!".formatted(Character.valueOf(r)));
        this.handleLang((IContent<?>)MachinesContent.ItemIo, "%s7The fluid mode can be toggled with a wrench".formatted(Character.valueOf(r)));
        this.handleLang((IContent<?>)MachinesContent.ModuleLooting, "Provides Looting I to a modular weapon");
        this.handleLang((IContent<?>)MachinesContent.ModuleFortune, "Provides Fortune I to a modular tool");
        this.handleLang((IContent<?>)MachinesContent.ModuleArea, "Unlocks a toggleable 3x3 mining ability");
        this.handleLang((IContent<?>)MachinesContent.ModuleMiningMk1, "Improves mining speed");
        this.handleLang((IContent<?>)MachinesContent.ModuleMiningMk2, "Considerably improves mining speed");
        this.handleLang((IContent<?>)MachinesContent.ModuleMiningMk3, "Drastically improves mining speed");
        this.handleLang((IContent<?>)MachinesContent.ModuleProspector, "Specializes a modular tool with Fortune VII");
        this.handleLang((IContent<?>)MachinesContent.ModuleHunter, "Specializes a modular weapon for  Looting VII");
        this.handleLang((IContent<?>)MachinesContent.ModuleSnipe, "Utilizes the full extent of the modular tool to snipe its target");
        this.add("commands.xycraft.buildtank.toobig", "Too many blocks in the specified area (maximum %s, specified %s)");
        this.add("commands.xycraft.buildtank.failed", "No blocks placed");
        this.add("gui.xycraft_machines.tank", "Tank");
        this.add("gui.xycraft_machines.fabricator.always_on", "Always On");
        this.add("gui.xycraft_machines.fabricator.high_signal", "High Signal");
        this.add("gui.xycraft_machines.fabricator.pulse", "Pulse");
        this.add("gui.xycraft_machines.tank.empty", "Empty");
        this.add("gui.xycraft_machines.tank.capacity", "Capacity");
        this.add("itemGroup.xycraft_machines", "XyCraft Machines");
        this.add("jei.recipe.extractor", "Extractor Recipes");
        this.add("jei.recipe.general.time", "Time");
        this.add("jei.recipe.general.seconds", "seconds");
        this.add("jei.recipe.extractor.directions", "Orientations");
        this.add("attribute.xycraft.hover_flight", "Hover Flight");
        this.add("sound.xycraft_machines.subtitle.soaryn_box_deposit", "Woop!");
        this.add("sound.xycraft_machines.subtitle.balloon_pop", "Balloon Popped!");
        this.add("sound.xycraft_machines.subtitle.balloon_inflate", "Inflating Balloon");
    }

    private void handleLang(IContent<?> content, String toolTip) {
        String[] tips = toolTip.split("\n");
        for (int i = 0; i < tips.length; ++i) {
            this.add("item.xycraft_machines." + content.id().m_135815_() + ".tooltip_" + i, tips[i]);
        }
    }

    private void handleLang(IContent<?> content) {
        if (content instanceof BlockContent) {
            BlockContent wrapper = (BlockContent)content;
            this.add(wrapper.block(), wrapper.getLocalizedName(this.locale));
        } else if (content instanceof ItemContent) {
            ItemContent wrapper = (ItemContent)content;
            this.add(wrapper.item(), wrapper.getLocalizedName(this.locale));
        } else if (content instanceof FluidContent) {
            FluidContent wrapper = (FluidContent)content;
            this.add(((FluidType)wrapper.Type.get()).getDescriptionId(), wrapper.getLocalizedName(this.locale));
        }
    }
}

