/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.machines.content.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.RequirementsStrategy;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.core.Direction;
import net.minecraft.core.RegistryAccess;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tv.soaryn.xycraft.core.utils.CodecUtils;
import tv.soaryn.xycraft.core.utils.rules.BlockRule;
import tv.soaryn.xycraft.core.utils.rules.BlockTagRule;
import tv.soaryn.xycraft.core.utils.rules.IRule;
import tv.soaryn.xycraft.machines.content.MachineRecipes;
import tv.soaryn.xycraft.machines.content.recipe.CatalystExtractorRecipe;

public class ExtractorRecipe
implements Recipe<Container> {
    private final ResourceLocation id;
    private final ItemStack resultItem;
    private final FluidStack resultFluid;
    private final EnumSet<Direction> validDirections;
    private final IRule target;
    @Nullable
    private final IRule catalyst;
    @Nullable
    private final FluidType waterloggedFluid;
    private boolean _hidden;
    private final List<IRule> adjacentRules;
    private final int ticks;

    public ArrayList<IRule> getAllRules() {
        ArrayList<IRule> list = new ArrayList<IRule>();
        list.add(this.getTarget());
        IRule catalyst = this.getCatalyst();
        if (catalyst != null) {
            list.add(catalyst);
        }
        list.addAll(this.getAdjacentRules());
        return list;
    }

    public EnumSet<Direction> getValidDirections() {
        return this.validDirections;
    }

    @Nullable
    public IRule getCatalyst() {
        return this.catalyst;
    }

    @Nullable
    public FluidType getWaterloggedFluid() {
        return this.waterloggedFluid;
    }

    public List<IRule> getAdjacentRules() {
        return this.adjacentRules;
    }

    public ExtractorRecipe(ResourceLocation id, ItemStack resultItem, FluidStack fluidStack, EnumSet<Direction> validDirections, IRule target, @Nullable IRule catalyst, @Nullable FluidType waterloggedFluid, List<IRule> adjacentRules, int ticks) {
        this.id = id;
        this.resultItem = resultItem;
        this.resultFluid = fluidStack;
        this.validDirections = validDirections;
        this.target = target;
        this.catalyst = catalyst;
        this.waterloggedFluid = waterloggedFluid;
        this.adjacentRules = adjacentRules;
        this.ticks = ticks;
    }

    public boolean isHidden() {
        return this._hidden;
    }

    public ExtractorRecipe hide() {
        this._hidden = true;
        return this;
    }

    public int getAdjCount() {
        return this.adjacentRules.size();
    }

    public IRule getTarget() {
        return this.target;
    }

    @NotNull
    public RecipeType<?> m_6671_() {
        return (RecipeType)MachineRecipes.ExtractorType.get();
    }

    public boolean isFluidRecipe() {
        return !this.resultFluid.isEmpty();
    }

    @NotNull
    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)MachineRecipes.ExtractorSerializer.get();
    }

    @NotNull
    public ResourceLocation m_6423_() {
        return this.id;
    }

    public int getTicks() {
        return this.ticks;
    }

    public boolean m_8004_(int width, int height) {
        return true;
    }

    public boolean matches(Container container, @NotNull Level level) {
        if (!this.validDirections.contains(container.getDirection()) || !this.target.matches(container.getTarget()) || this.catalyst != null && !this.catalyst.matches(container.getCatalyst()) || this.waterloggedFluid != null && container.getFluidState().getFluidType() != this.waterloggedFluid) {
            return false;
        }
        if (this.adjacentRules.isEmpty()) {
            return true;
        }
        ArrayList<IRule> ruleTests = new ArrayList<IRule>(this.adjacentRules);
        List<BlockState> states = container.computeAdjacent();
        ruleTests.removeIf(ruleTest -> {
            for (BlockState state : states) {
                if (!ruleTest.matches(state)) continue;
                states.remove(state);
                return true;
            }
            return false;
        });
        return ruleTests.isEmpty();
    }

    @NotNull
    public FluidStack assembleFluid(@NotNull Container container, RegistryAccess registryAccess) {
        return this.getResultFluid(registryAccess).copy();
    }

    @NotNull
    public ItemStack assemble(@NotNull Container container, @NotNull RegistryAccess registryAccess) {
        return this.m_8043_(registryAccess).m_41777_();
    }

    @NotNull
    public ItemStack getResultItemView() {
        return this.resultItem;
    }

    @NotNull
    public FluidStack getResultFluidView() {
        return this.resultFluid;
    }

    @NotNull
    public ItemStack m_8043_(@NotNull RegistryAccess registryAccess) {
        return this.resultItem;
    }

    @NotNull
    public FluidStack getResultFluid(RegistryAccess registryAccess) {
        return this.resultFluid;
    }

    public static interface Container
    extends net.minecraft.world.Container {
        public Direction getDirection();

        public FluidState getFluidState();

        public BlockState getTarget();

        public BlockState getCatalyst();

        public List<BlockState> computeAdjacent();
    }

    public static class Builder
    implements RecipeBuilder {
        private ItemStack _resultItem = ItemStack.f_41583_;
        private FluidStack _resultFluid = FluidStack.EMPTY;
        private EnumSet<Direction> _validDirections = EnumSet.allOf(Direction.class);
        private IRule _target;
        private IRule _catalyst;
        private FluidType _waterloggedFluid;
        private List<IRule> _adjacentRules = List.of();
        private int _ticks = 10;
        private String _group = "";
        private final Advancement.Builder advancement = Advancement.Builder.m_138353_();

        public static Builder fluid(FluidStack fluidStack) {
            return new Builder(fluidStack);
        }

        public static Builder item(ItemStack itemStack) {
            return new Builder(itemStack);
        }

        public static Builder item(ItemLike item) {
            return new Builder(item);
        }

        public Builder(FluidStack fluidStack) {
            this._resultFluid = fluidStack;
        }

        public Builder(ItemStack itemStack) {
            this._resultItem = itemStack;
        }

        public Builder(ItemLike item) {
            this._resultItem = new ItemStack(item);
        }

        public Builder ticksRequired(int ticks) {
            this._ticks = ticks;
            return this;
        }

        public Builder validDirections(EnumSet<Direction> directions) {
            this._validDirections = directions;
            return this;
        }

        public Builder target(IRule test) {
            this._target = test;
            return this;
        }

        public Builder target(Block block) {
            this._target = new BlockRule(block);
            return this;
        }

        public Builder target(TagKey<Block> tag) {
            this._target = new BlockTagRule(tag);
            return this;
        }

        public Builder catalyst(IRule test) {
            this._catalyst = test;
            return this;
        }

        public Builder catalyst(Block block) {
            this._catalyst = new BlockRule(block);
            return this;
        }

        public Builder catalyst(TagKey<Block> tag) {
            this._catalyst = new BlockTagRule(tag);
            return this;
        }

        public Builder adjacents(IRule ... tests) {
            this._adjacentRules = List.of(tests);
            return this;
        }

        public Builder fluidLoggable(FluidType type) {
            this._waterloggedFluid = type;
            return this;
        }

        public Builder waterLogged() {
            this._waterloggedFluid = (FluidType)ForgeMod.WATER_TYPE.get();
            return this;
        }

        @NotNull
        public RecipeBuilder m_126132_(@NotNull String name, @NotNull CriterionTriggerInstance criterion) {
            this.advancement.m_138386_(name, criterion);
            return this;
        }

        @NotNull
        public RecipeBuilder m_126145_(@Nullable String group) {
            this._group = group;
            return this;
        }

        @NotNull
        public Item m_142372_() {
            return this._resultItem.m_41720_();
        }

        public void m_126140_(@NotNull Consumer<FinishedRecipe> finishedRecipe, @NotNull ResourceLocation id) {
            this.ensureValid(id);
            this.advancement.m_138396_(f_236353_).m_138386_("has_the_recipe", (CriterionTriggerInstance)RecipeUnlockedTrigger.m_63728_((ResourceLocation)id)).m_138354_(AdvancementRewards.Builder.m_10009_((ResourceLocation)id)).m_138360_(RequirementsStrategy.f_15979_);
            finishedRecipe.accept(new Result(id, this._resultItem, this._resultFluid, this._validDirections, this._target, this._catalyst, this._waterloggedFluid, this._adjacentRules, this._ticks, this._group, this.advancement, new ResourceLocation(id.m_135827_(), "recipes/extractor/" + id.m_135815_())));
        }

        public void m_176500_(@NotNull Consumer<FinishedRecipe> finishedRecipe, @NotNull String id) {
            this.m_126140_(finishedRecipe, new ResourceLocation("xycraft_machines", "extractor/" + id));
        }

        private void ensureValid(ResourceLocation id) {
            if (this._target == null) {
                throw new RuntimeException("Target is null in Extractor recipe - " + id);
            }
            if (this._resultFluid.isEmpty() && this._resultItem.m_41619_()) {
                throw new RuntimeException("No result in Extractor recipe - " + id);
            }
            if (this._validDirections.size() == 0) {
                throw new RuntimeException("No valid direction in Extractor Recipe - " + id);
            }
        }

        public static class Result
        implements FinishedRecipe {
            private final ResourceLocation _id;
            private final ItemStack resultItem;
            private final FluidStack resultFluid;
            private final EnumSet<Direction> validDirections;
            private final IRule target;
            private final IRule catalyst;
            private final FluidType waterloggedFluid;
            private final List<IRule> adjacentRules;
            private final int ticks;
            private final String group;
            private final Advancement.Builder advancement;
            private final ResourceLocation advancementId;

            public Result(ResourceLocation id, ItemStack resultItem, FluidStack resultFluid, @NotNull EnumSet<Direction> validDirections, IRule target, @Nullable IRule catalyst, @Nullable FluidType waterloggedFluid, List<IRule> adjacentRules, int ticks, String group, Advancement.Builder advancement, ResourceLocation advancementId) {
                this._id = id;
                this.resultItem = resultItem;
                this.resultFluid = resultFluid;
                this.validDirections = validDirections;
                this.target = target;
                this.catalyst = catalyst;
                this.waterloggedFluid = waterloggedFluid;
                this.adjacentRules = adjacentRules;
                this.ticks = ticks;
                this.group = group;
                this.advancement = advancement;
                this.advancementId = advancementId;
            }

            public void m_7917_(@NotNull JsonObject jsonObject) {
                if (!this.group.isEmpty()) {
                    jsonObject.addProperty("group", this.group);
                }
                if (!this.resultFluid.isEmpty()) {
                    DataResult fluidResult = FluidStack.CODEC.encode((Object)this.resultFluid, (DynamicOps)JsonOps.INSTANCE, (Object)new JsonObject());
                    fluidResult.error().ifPresent(err -> {
                        throw new RuntimeException("Can't generate result fluid for " + this._id);
                    });
                    jsonObject.add("fluid_result", (JsonElement)fluidResult.result().orElseThrow());
                } else {
                    DataResult itemResult = ItemStack.f_41582_.encode((Object)this.resultItem, (DynamicOps)JsonOps.INSTANCE, (Object)new JsonObject());
                    itemResult.error().ifPresent(err -> {
                        throw new RuntimeException("Can't generate result stack for " + this._id);
                    });
                    jsonObject.add("item_result", (JsonElement)itemResult.result().orElseThrow());
                }
                jsonObject.addProperty("ticks", (Number)this.ticks);
                JsonArray validDirectionsJson = new JsonArray(this.validDirections.size());
                for (Direction direction : this.validDirections) {
                    validDirectionsJson.add(direction.m_7912_());
                }
                jsonObject.add("valid_directions", (JsonElement)validDirectionsJson);
                jsonObject.add("target", CodecUtils.encodeRuleTest((IRule)this.target));
                if (this.catalyst != null) {
                    jsonObject.add("catalyst", CodecUtils.encodeRuleTest((IRule)this.catalyst));
                }
                JsonArray adj = new JsonArray(this.adjacentRules.size());
                for (IRule adjacentRule : this.adjacentRules) {
                    adj.add(CodecUtils.encodeRuleTest((IRule)adjacentRule));
                }
                jsonObject.add("adjacent", (JsonElement)adj);
                if (this.waterloggedFluid != null) {
                    DataResult dataResult = ((Codec)CodecUtils.FluidTypeCodec.get()).encode((Object)this.waterloggedFluid, (DynamicOps)JsonOps.INSTANCE, (Object)JsonNull.INSTANCE);
                    dataResult.error().ifPresent(err -> {
                        throw new RuntimeException("Can't generate result waterlogged Fluid for " + this._id);
                    });
                    jsonObject.add("waterlogged_fluid", (JsonElement)dataResult.result().orElseThrow());
                }
            }

            @NotNull
            public ResourceLocation m_6445_() {
                return this._id;
            }

            @NotNull
            public RecipeSerializer<?> m_6637_() {
                return (RecipeSerializer)MachineRecipes.ExtractorSerializer.get();
            }

            @Nullable
            public JsonObject m_5860_() {
                return this.advancement.m_138400_();
            }

            @Nullable
            public ResourceLocation m_6448_() {
                return this.advancementId;
            }
        }
    }

    public static class Serializer
    implements RecipeSerializer<ExtractorRecipe> {
        @NotNull
        public ExtractorRecipe fromJson(@NotNull ResourceLocation id, @NotNull JsonObject json) {
            EnumSet<Direction> validDirections = EnumSet.noneOf(Direction.class);
            if (json.has("valid_directions")) {
                for (JsonElement element : json.getAsJsonArray("valid_directions")) {
                    validDirections.add(Direction.m_122402_((String)element.getAsString()));
                }
            }
            JsonObject targetJson = GsonHelper.m_13930_((JsonObject)json, (String)"target");
            DataResult decodedTarget = IRule.Codec.decode((DynamicOps)JsonOps.INSTANCE, (Object)targetJson);
            decodedTarget.error().ifPresent(err -> {
                throw new JsonParseException("Failed to parse target.");
            });
            IRule target = (IRule)((Pair)decodedTarget.result().orElseThrow()).getFirst();
            IRule catalyst = null;
            if (json.has("catalyst")) {
                catalyst = CodecUtils.decodeRuleTest((JsonElement)json.getAsJsonObject("catalyst"));
            }
            FluidType waterloggedFluid = null;
            if (json.has("waterlogged_fluid")) {
                JsonPrimitive fluidJson = json.getAsJsonPrimitive("waterlogged_fluid");
                DataResult decodedFluid = ((Codec)CodecUtils.FluidTypeCodec.get()).decode((DynamicOps)JsonOps.INSTANCE, (Object)fluidJson);
                decodedFluid.error().ifPresent(err -> {
                    throw new JsonParseException("Failed to parse waterlogged fluid.");
                });
                waterloggedFluid = (FluidType)((Pair)decodedFluid.result().orElseThrow()).getFirst();
            }
            ArrayList<IRule> adjacentRules = new ArrayList<IRule>();
            if (json.has("adjacent")) {
                JsonArray adjacentJson = json.getAsJsonArray("adjacent");
                if (adjacentJson.size() > 4) {
                    throw new JsonParseException("Too many adjacent rules in " + id);
                }
                for (JsonElement element : adjacentJson) {
                    DataResult decodedElement = IRule.Codec.decode((DynamicOps)JsonOps.INSTANCE, (Object)element.getAsJsonObject());
                    decodedElement.error().ifPresent(err -> {
                        throw new JsonParseException("Failed to parse adjacents in" + id);
                    });
                    adjacentRules.add((IRule)((Pair)decodedElement.result().orElseThrow()).getFirst());
                }
            }
            int ticks = GsonHelper.m_13824_((JsonObject)json, (String)"ticks", (int)10);
            if (json.has("item_result")) {
                DataResult result = ItemStack.f_41582_.decode((DynamicOps)JsonOps.INSTANCE, (Object)json.get("item_result"));
                result.error().ifPresent(err -> {
                    throw new JsonParseException("Failed to parse item result : " + err);
                });
                if (catalyst != null) {
                    return new CatalystExtractorRecipe(id, (ItemStack)((Pair)result.result().orElseThrow()).getFirst(), FluidStack.EMPTY, validDirections, target, catalyst, waterloggedFluid, adjacentRules, ticks);
                }
                return new ExtractorRecipe(id, (ItemStack)((Pair)result.result().orElseThrow()).getFirst(), FluidStack.EMPTY, validDirections, target, catalyst, waterloggedFluid, adjacentRules, ticks);
            }
            if (json.has("fluid_result")) {
                DataResult decodedFluidResult = FluidStack.CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)json.getAsJsonObject("fluid_result"));
                decodedFluidResult.error().ifPresent(err -> {
                    throw new JsonParseException("Failed to parse fluid result : " + err);
                });
                FluidStack result = (FluidStack)((Pair)decodedFluidResult.result().orElseThrow()).getFirst();
                if (catalyst != null) {
                    return new CatalystExtractorRecipe(id, ItemStack.f_41583_, result, validDirections, target, catalyst, waterloggedFluid, adjacentRules, ticks);
                }
                return new ExtractorRecipe(id, ItemStack.f_41583_, result, validDirections, target, catalyst, waterloggedFluid, adjacentRules, ticks);
            }
            throw new JsonParseException("Failed to find a result.");
        }

        public void toNetwork(FriendlyByteBuf buf, ExtractorRecipe recipe) {
            buf.writeInt(recipe.ticks);
            buf.m_130055_(recipe.resultItem);
            buf.writeFluidStack(recipe.resultFluid);
            buf.writeByte(recipe.validDirections.size());
            recipe.validDirections.forEach(arg_0 -> ((FriendlyByteBuf)buf).m_130068_(arg_0));
            buf.m_272073_(IRule.Codec, (Object)recipe.target);
            buf.writeBoolean(recipe.catalyst != null);
            if (recipe.catalyst != null) {
                buf.m_272073_(IRule.Codec, (Object)recipe.catalyst);
            }
            buf.writeBoolean(recipe.waterloggedFluid != null);
            if (recipe.waterloggedFluid != null) {
                buf.writeRegistryId((IForgeRegistry)ForgeRegistries.FLUID_TYPES.get(), (Object)recipe.waterloggedFluid);
            }
            buf.writeByte(recipe.adjacentRules.size());
            for (IRule ruleTest : recipe.adjacentRules) {
                buf.m_272073_(IRule.Codec, (Object)ruleTest);
            }
        }

        @Nullable
        public ExtractorRecipe fromNetwork(@NotNull ResourceLocation id, FriendlyByteBuf buf) {
            int ticks = buf.readInt();
            ItemStack result = buf.m_130267_();
            FluidStack resultFluid = buf.readFluidStack();
            EnumSet<Direction> validDirections = EnumSet.noneOf(Direction.class);
            int validDirectionCount = buf.readByte() & 0xFF;
            for (int i = 0; i < validDirectionCount; ++i) {
                validDirections.add((Direction)buf.m_130066_(Direction.class));
            }
            IRule targetRuleTest = (IRule)buf.m_271872_(IRule.Codec);
            IRule catalystRuleTest = buf.readBoolean() ? (IRule)buf.m_271872_(IRule.Codec) : null;
            FluidType waterloggedFluid = buf.readBoolean() ? (FluidType)buf.readRegistryId() : null;
            ArrayList<IRule> adjacentRuleTests = new ArrayList<IRule>();
            int adjacentRuleTestCount = buf.readByte() & 0xFF;
            for (int i = 0; i < adjacentRuleTestCount; ++i) {
                adjacentRuleTests.add((IRule)buf.m_271872_(IRule.Codec));
            }
            if (catalystRuleTest != null) {
                return new CatalystExtractorRecipe(id, result, resultFluid, validDirections, targetRuleTest, catalystRuleTest, waterloggedFluid, adjacentRuleTests, ticks);
            }
            return new ExtractorRecipe(id, result, resultFluid, validDirections, targetRuleTest, null, waterloggedFluid, adjacentRuleTests, ticks);
        }
    }
}

