/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.machines.content.multiblock;

import com.mojang.datafixers.util.Either;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import tv.soaryn.xycraft.core.content.blocks.IWrenchUse;
import tv.soaryn.xycraft.core.content.capabilities.player.ModifierKeyCapability;
import tv.soaryn.xycraft.core.network.Packet;
import tv.soaryn.xycraft.core.utils.FastVolumeLookup;
import tv.soaryn.xycraft.core.utils.container.ItemContainer;
import tv.soaryn.xycraft.core.utils.container.SimpleItemContainer;
import tv.soaryn.xycraft.machines.XyMachines;
import tv.soaryn.xycraft.machines.config.MachinesConfig;
import tv.soaryn.xycraft.machines.content.MachinesContent;
import tv.soaryn.xycraft.machines.content.MachinesTags;
import tv.soaryn.xycraft.machines.content.multiblock.CuboidMultiBlockDescriptor;
import tv.soaryn.xycraft.machines.content.multiblock.MultiTank;
import tv.soaryn.xycraft.machines.gui.TankMenu;
import tv.soaryn.xycraft.machines.network.CBTankFluidUpdatePacket;
import tv.soaryn.xycraft.machines.network.CBTankFormPacket;
import tv.soaryn.xycraft.machines.network.CBTankUnformPacket;

public class TankMultiBlock
implements MultiTank.FluidAmountContainer {
    public static final CuboidMultiBlockDescriptor.FormationRules FORMATION_RULES = new FormationRules();
    public static final int SLOT_COUNT = 4;
    private final MultiTank parent;
    private final int id;
    private final int seed;
    private final CuboidMultiBlockDescriptor descriptor;
    private final int height;
    private final Set<IMember> members;
    private final int capacity;
    private final int layerCapacity;
    private int fluidAmount;
    private final FluidHandler fluidHandler;
    private final ItemContainer.Serializable inventory;
    private final IItemHandler fillItemHandler;
    private final IItemHandler drainItemHandler;
    private final MultiTank.IOGroup ioGroup;
    private static final Set<TankMultiBlock> TO_VALIDATE = Collections.newSetFromMap(new IdentityHashMap());
    private static final Set<TankMultiBlock> TO_SYNC = Collections.newSetFromMap(new IdentityHashMap());
    private static boolean VALIDATING = false;

    public static boolean tryForm(ServerLevel level, BlockPos valvePos, Direction clickedSide, ServerPlayer serverPlayer) {
        BlockPos innerPos = valvePos.m_121945_(clickedSide.m_122424_());
        Either<CuboidMultiBlockDescriptor, String> descriptor = CuboidMultiBlockDescriptor.tryFormOutwards((BlockGetter)level, innerPos, FORMATION_RULES);
        return (Boolean)descriptor.map(desc -> {
            Set<IMember> members = TankMultiBlock.findMembers((Level)level, desc);
            Set otherTanks = members.stream().flatMap(m -> StreamSupport.stream(m.getMultiBlocks().spliterator(), false)).collect(Collectors.toSet());
            Set otherMultiTanks = otherTanks.stream().map(m -> m.parent).collect(Collectors.toSet());
            if (otherMultiTanks.stream().anyMatch(MultiTank::isValid)) {
                serverPlayer.m_5661_((Component)Component.m_237113_((String)"A valve is part of another tank. Balancing is not yet supported."), true);
                return false;
            }
            FluidStack fluidType = otherMultiTanks.stream().map(MultiTank::getFluidType).filter(Predicate.not(FluidStack::isEmpty)).reduce(FluidStack.EMPTY, (a, b) -> {
                if (a == null) {
                    return null;
                }
                return a.isEmpty() ? b : (b.isEmpty() || a.isFluidEqual(b) ? a : null);
            });
            if (fluidType == null) {
                serverPlayer.m_5661_((Component)Component.m_237113_((String)"Multiple fluids found. Nope."), true);
                return false;
            }
            MultiTank multiTank = MultiTank.create(level);
            TankMultiBlock multiBlock = multiTank.addMember((CuboidMultiBlockDescriptor)desc, members);
            if (!fluidType.isEmpty()) {
                int inserted;
                multiTank.setFluidType(fluidType.copy());
                int fluidInOtherTanks = otherTanks.stream().mapToInt(t -> t.fluidAmount).sum();
                multiBlock.fluidAmount = inserted = Math.min(fluidInOtherTanks, multiBlock.capacity);
                for (TankMultiBlock otherTank : otherTanks) {
                    int extracted = Math.min(inserted, otherTank.fluidAmount);
                    otherTank.fluidAmount -= extracted;
                    otherTank.parent.m_77762_();
                    if ((inserted -= extracted) != 0) continue;
                    break;
                }
            }
            multiBlock.members.forEach(member -> member.join(multiBlock));
            XyMachines.NETWORK_HANDLER.broadcast((Level)level, desc.min(), (Packet.ClientBound)new CBTankFormPacket(desc.min(), desc.max(), multiBlock.getFluidHandler().getFluidInTank(0)));
            serverPlayer.m_5661_((Component)Component.m_237113_((String)"Formed!"), true);
            return true;
        }, error -> {
            serverPlayer.m_5661_((Component)Component.m_237113_((String)error), true);
            return false;
        });
    }

    TankMultiBlock(MultiTank parent, int id, CuboidMultiBlockDescriptor descriptor, @Nullable Set<IMember> members) {
        this.parent = parent;
        this.id = id;
        this.seed = descriptor.min().hashCode();
        this.descriptor = descriptor;
        this.height = descriptor.max().m_123342_() - descriptor.min().m_123342_() - 1;
        this.members = members != null ? members : TankMultiBlock.findMembers((Level)parent.getLevel(), descriptor);
        this.capacity = TankMultiBlock.calculateCapacity(descriptor);
        this.layerCapacity = this.capacity / this.height;
        this.fluidHandler = new FluidHandler();
        this.inventory = new Container(() -> ((MultiTank)parent).m_77762_());
        this.fillItemHandler = this.inventory.slice(0, 2).asItemHandler((ItemContainer.ItemHandlerBehavior)ItemHandlerBehavior.INSTANCE);
        this.drainItemHandler = this.inventory.slice(2, 4).asItemHandler((ItemContainer.ItemHandlerBehavior)ItemHandlerBehavior.INSTANCE);
        this.ioGroup = new Section.Group(List.of(new Section()));
    }

    TankMultiBlock(MultiTank parent, int id, CompoundTag tag) {
        this(parent, id, new CuboidMultiBlockDescriptor(BlockPos.m_122022_((long)tag.m_128454_("min")), BlockPos.m_122022_((long)tag.m_128454_("max"))), null);
        this.fluidAmount = tag.m_128451_("fluid_amount");
        this.inventory.load(tag.m_128469_("inventory"));
    }

    private static Set<IMember> findMembers(Level level, CuboidMultiBlockDescriptor descriptor) {
        return BlockPos.m_121990_((BlockPos)descriptor.min(), (BlockPos)descriptor.max()).filter(pos -> {
            BlockState blockState = level.m_8055_(pos);
            return blockState.m_60713_(MachinesContent.Valve.block()) || blockState.m_60713_(MachinesContent.ItemIo.block());
        }).map(arg_0 -> ((Level)level).m_7702_(arg_0)).filter(IMember.class::isInstance).map(IMember.class::cast).collect(Collectors.toSet());
    }

    private static int calculateCapacity(CuboidMultiBlockDescriptor descriptor) {
        BlockPos innerVolume = descriptor.max().m_121996_((Vec3i)descriptor.min()).m_7918_(-1, -1, -1);
        int volume = innerVolume.m_123341_() * innerVolume.m_123342_() * innerVolume.m_123343_();
        return (Integer)MachinesConfig.TankStoragePerBlock.get() * volume;
    }

    CuboidMultiBlockDescriptor getDescriptor() {
        return this.descriptor;
    }

    @Override
    public int getCapacity() {
        return this.capacity;
    }

    @Override
    public int getFluidAmount() {
        return this.fluidAmount;
    }

    @Override
    public void setFluidAmount(int fluidAmount, MultiTank.TankOperation operation) {
        this.fluidAmount = fluidAmount;
        TO_SYNC.add(this);
    }

    public boolean isValid() {
        return this.parent.isValid();
    }

    public ItemContainer getInventory() {
        return this.inventory;
    }

    public IFluidHandler getFluidHandler() {
        return this.fluidHandler;
    }

    public IItemHandler getFillItemHandler() {
        return this.fillItemHandler;
    }

    public IItemHandler getDrainItemHandler() {
        return this.drainItemHandler;
    }

    private int getBottom() {
        return this.descriptor.min().m_123342_() + 1;
    }

    public int getHeight() {
        return this.height;
    }

    private int getLayerCapacity() {
        return this.layerCapacity;
    }

    public boolean canAccess(Player player) {
        if (!this.isValid()) {
            return false;
        }
        return new AABB(this.descriptor.min().m_7918_(-8, -8, -8), this.descriptor.max().m_7918_(9, 9, 9)).m_82381_(player.m_20191_());
    }

    private Iterable<MultiTank.IOGroup> getMultiTankFillOrder() {
        return List.of(this.ioGroup);
    }

    private Iterable<MultiTank.IOGroup> getMultiTankDrainOrder() {
        return List.of(this.ioGroup);
    }

    public void onClickedClient(ServerPlayer player, BlockPos clickedPos, InteractionHand hand) {
        if (!this.canAccess((Player)player)) {
            return;
        }
        Block block = this.parent.getLevel().m_8055_(clickedPos).m_60734_();
        if (block == MachinesContent.Valve.block() && FluidUtil.interactWithFluidHandler((Player)player, (InteractionHand)hand, (IFluidHandler)this.getFluidHandler())) {
            player.m_21011_(hand, true);
            return;
        }
        TankMenu.open(player, this);
        player.m_21011_(hand, true);
    }

    public Direction.Axis determineAxis(BlockPos pos) {
        BlockPos minTest = this.descriptor.min().m_121996_((Vec3i)pos);
        BlockPos maxTest = this.descriptor.max().m_121996_((Vec3i)pos);
        Vector3f minVector = new Vector3f((float)minTest.m_123341_(), (float)minTest.m_123342_(), (float)minTest.m_123343_());
        int minTestComponent = new Vector3f((float)minTest.m_123341_(), (float)minTest.m_123342_(), (float)minTest.m_123343_()).minComponent();
        float minComponentValue = minVector.get(minTestComponent);
        int maxTestComponent = new Vector3f((float)maxTest.m_123341_(), (float)maxTest.m_123342_(), (float)maxTest.m_123343_()).minComponent();
        return Direction.Axis.values()[minComponentValue == 0.0f ? minTestComponent : maxTestComponent];
    }

    @NotNull
    private BlockPos getCenter() {
        return new BlockPos((this.descriptor.min().m_123341_() + this.descriptor.max().m_123341_()) / 2, (this.descriptor.min().m_123342_() + this.descriptor.max().m_123342_()) / 2, (this.descriptor.min().m_123343_() + this.descriptor.max().m_123343_()) / 2);
    }

    public void tick() {
        int frequency = 10;
        long partial = ((long)this.seed + this.parent.getLevel().m_46467_()) % (long)frequency;
        if (partial == 0L) {
            this.drainItem();
        } else if (partial == (long)(frequency / 2)) {
            this.fillItem();
        }
    }

    private void drainItem() {
        ItemStack input = this.inventory.get(0);
        ItemStack output = this.inventory.get(1);
        if (input.m_41619_()) {
            return;
        }
        if (!(output.m_41619_() || output.m_41753_() && output.m_41741_() > output.m_41613_())) {
            return;
        }
        int availableCapacity = this.capacity - this.fluidAmount;
        ItemStack inputSingle = input.m_41613_() == 1 ? input : input.m_255036_(1);
        FluidActionResult result = FluidUtil.tryEmptyContainer((ItemStack)inputSingle, (IFluidHandler)this.getFluidHandler(), (int)availableCapacity, null, (boolean)false);
        if (result.isSuccess() && (output.m_41619_() || ItemHandlerHelper.canItemStacksStack((ItemStack)result.getResult(), (ItemStack)output)) && (result = FluidUtil.tryEmptyContainer((ItemStack)inputSingle, (IFluidHandler)this.getFluidHandler(), (int)availableCapacity, null, (boolean)true)).isSuccess()) {
            if (inputSingle != input) {
                input.m_41774_(1);
                this.inventory.set(0, input);
            } else {
                this.inventory.set(0, ItemStack.f_41583_);
            }
            if (output.m_41619_() || ItemHandlerHelper.canItemStacksStack((ItemStack)result.getResult(), (ItemStack)output)) {
                if (!output.m_41619_()) {
                    output.m_41769_(result.getResult().m_41613_());
                    this.inventory.set(1, output);
                } else {
                    this.inventory.set(1, result.getResult());
                }
            } else {
                XyMachines.Logger.error("[TANK] Fluid extraction: Execution did not match simulation.");
                Block.m_49840_((Level)this.parent.getLevel(), (BlockPos)this.getCenter(), (ItemStack)result.getResult());
            }
        }
    }

    private void fillItem() {
        ItemStack input = this.inventory.get(2);
        ItemStack output = this.inventory.get(3);
        if (input.m_41619_()) {
            return;
        }
        if (!(output.m_41619_() || output.m_41753_() && output.m_41741_() > output.m_41613_())) {
            return;
        }
        ItemStack inputSingle = input.m_41613_() == 1 ? input : input.m_255036_(1);
        IFluidHandler handler = this.getFluidHandler();
        FluidActionResult result = FluidUtil.tryFillContainer((ItemStack)inputSingle, (IFluidHandler)handler, (int)this.fluidAmount, null, (boolean)false);
        if (result.isSuccess() && (output.m_41619_() || ItemHandlerHelper.canItemStacksStack((ItemStack)result.getResult(), (ItemStack)output)) && (result = FluidUtil.tryFillContainer((ItemStack)inputSingle, (IFluidHandler)handler, (int)this.fluidAmount, null, (boolean)true)).isSuccess()) {
            if (inputSingle != input) {
                input.m_41774_(1);
                this.inventory.set(2, input);
            } else {
                this.inventory.set(2, ItemStack.f_41583_);
            }
            if (output.m_41619_() || ItemHandlerHelper.canItemStacksStack((ItemStack)result.getResult(), (ItemStack)output)) {
                if (!output.m_41619_()) {
                    output.m_41769_(result.getResult().m_41613_());
                    this.inventory.set(3, output);
                } else {
                    this.inventory.set(3, result.getResult());
                }
            } else {
                XyMachines.Logger.error("[TANK] Fluid insertion: Execution did not match simulation.");
                Block.m_49840_((Level)this.parent.getLevel(), (BlockPos)this.getCenter(), (ItemStack)result.getResult());
            }
        }
    }

    CompoundTag save() {
        CompoundTag tag = new CompoundTag();
        tag.m_128356_("min", this.descriptor.min().m_121878_());
        tag.m_128356_("max", this.descriptor.max().m_121878_());
        tag.m_128405_("fluid_amount", this.fluidAmount);
        tag.m_128365_("inventory", (Tag)this.inventory.save());
        return tag;
    }

    public CompoundTag describeForSave() {
        CompoundTag tag = new CompoundTag();
        tag.m_128362_("multi_tank", this.parent.getId());
        tag.m_128405_("id", this.id);
        return tag;
    }

    public CompoundTag describeForSync() {
        CompoundTag tag = new CompoundTag();
        tag.m_128356_("min", this.descriptor.min().m_121878_());
        tag.m_128356_("max", this.descriptor.max().m_121878_());
        tag.m_128365_("fluid", (Tag)this.getFluidHandler().getFluidInTank(0).writeToNBT(new CompoundTag()));
        return tag;
    }

    private void sync() {
        XyMachines.NETWORK_HANDLER.broadcast((Level)this.parent.getLevel(), this.descriptor.min(), (Packet.ClientBound)new CBTankFluidUpdatePacket(this.descriptor.min(), this.getFluidHandler().getFluidInTank(0)));
    }

    private void validate() {
        this.descriptor.checkForErrors((BlockGetter)this.parent.getLevel(), FORMATION_RULES).ifPresent(error -> {
            this.parent.removeMember(this.id);
            this.members.forEach(member -> member.leave(this));
            XyMachines.NETWORK_HANDLER.broadcast((Level)this.parent.getLevel(), (Packet.ClientBound)new CBTankUnformPacket(this.descriptor.min()));
            BlockPos center = this.getCenter();
            for (ItemStack stack : this.inventory) {
                if (stack.m_41619_()) continue;
                Block.m_49840_((Level)this.parent.getLevel(), (BlockPos)center, (ItemStack)stack);
            }
            this.parent.m_77762_();
        });
    }

    public static <T> Stream<T> findAll(Level level, BlockPos pos, Class<T> type) {
        return FastVolumeLookup.of((Level)level, type).find(pos);
    }

    public static <T> Optional<T> find(Level level, BlockPos pos, Class<T> type) {
        return TankMultiBlock.findAll(level, pos, type).findFirst();
    }

    public static Optional<TankMultiBlock> getAt(ServerLevel level, BlockPos origin) {
        return TankMultiBlock.findAll((Level)level, origin, TankMultiBlock.class).filter(tank -> tank.descriptor.min().equals((Object)origin)).findFirst();
    }

    @Nullable
    public static TankMultiBlock get(ServerLevel level, CompoundTag tag) {
        UUID multiTankId = tag.m_128342_("multi_tank");
        MultiTank multiTank = MultiTank.get(level, multiTankId);
        if (multiTank == null) {
            return null;
        }
        int id = tag.m_128451_("id");
        return multiTank.getMember(id);
    }

    public static void init() {
        MinecraftForge.EVENT_BUS.addListener(TankMultiBlock::onRightClick);
        MinecraftForge.EVENT_BUS.addListener(TankMultiBlock::onBlockUpdate);
        MinecraftForge.EVENT_BUS.addListener(TankMultiBlock::onServerTickEnd);
    }

    private static void onRightClick(PlayerInteractEvent.RightClickBlock event) {
        Level level = event.getLevel();
        if (level.m_5776_()) {
            return;
        }
        Player player = event.getEntity();
        if (player.m_36341_() || ModifierKeyCapability.of((Player)player)) {
            return;
        }
        BlockState state = level.m_8055_(event.getHitVec().m_82425_());
        Block block = state.m_60734_();
        if (IWrenchUse.hasWrenchLikeAction((Player)player, (ItemStack)player.m_21120_(event.getHand()), (boolean)false) && block != MachinesContent.Valve.block() && block == MachinesContent.ItemIo.block()) {
            return;
        }
        TankMultiBlock.find(event.getLevel(), event.getPos(), TankMultiBlock.class).ifPresent(tank -> {
            event.setCancellationResult(InteractionResult.m_19078_((boolean)event.getLevel().m_5776_()));
            event.setCanceled(true);
        });
    }

    private static void onBlockUpdate(BlockEvent.NeighborNotifyEvent event) {
        if (VALIDATING) {
            return;
        }
        LevelAccessor levelAccessor = event.getLevel();
        if (levelAccessor instanceof ServerLevel) {
            ServerLevel level = (ServerLevel)levelAccessor;
            FastVolumeLookup.of((Level)level, TankMultiBlock.class).find(event.getPos()).forEach(TO_VALIDATE::add);
        }
    }

    private static void onServerTickEnd(TickEvent.ServerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        try {
            VALIDATING = true;
            TO_VALIDATE.forEach(TankMultiBlock::validate);
        }
        finally {
            TO_VALIDATE.clear();
            VALIDATING = false;
        }
        for (ServerLevel level : event.getServer().m_129785_()) {
            FastVolumeLookup.of((Level)level, TankMultiBlock.class).getAll().forEach(TankMultiBlock::tick);
        }
        TO_SYNC.forEach(TankMultiBlock::sync);
        TO_SYNC.clear();
    }

    private class FluidHandler
    implements IFluidHandler {
        private FluidHandler() {
        }

        public int getTanks() {
            return 1;
        }

        @NotNull
        public FluidStack getFluidInTank(int tank) {
            FluidStack fluidType = TankMultiBlock.this.parent.getFluidType();
            if (TankMultiBlock.this.fluidAmount == 0 || fluidType.isEmpty()) {
                return FluidStack.EMPTY;
            }
            FluidStack copy = fluidType.copy();
            copy.setAmount(TankMultiBlock.this.fluidAmount);
            return copy;
        }

        public int getTankCapacity(int tank) {
            return TankMultiBlock.this.capacity;
        }

        public boolean isFluidValid(int tank, @NotNull FluidStack stack) {
            FluidStack fluidType = TankMultiBlock.this.parent.getFluidType();
            return fluidType.isEmpty() || fluidType.isFluidEqual(stack);
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            if (resource.isEmpty()) {
                return 0;
            }
            FluidStack fluidType = TankMultiBlock.this.parent.getFluidType();
            if (!fluidType.isEmpty() && !fluidType.isFluidEqual(resource)) {
                return 0;
            }
            return TankMultiBlock.this.parent.doFillLiquid(TankMultiBlock.this.getMultiTankFillOrder(), resource, resource.getAmount(), action);
        }

        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
            if (resource.isEmpty()) {
                return FluidStack.EMPTY;
            }
            FluidStack fluidType = TankMultiBlock.this.parent.getFluidType();
            if (fluidType.isEmpty() || !fluidType.isFluidEqual(resource)) {
                return FluidStack.EMPTY;
            }
            return TankMultiBlock.this.parent.doDrainLiquid(TankMultiBlock.this.getMultiTankDrainOrder(), resource.getAmount(), action);
        }

        public FluidStack drain(int amount, IFluidHandler.FluidAction action) {
            if (amount == 0) {
                return FluidStack.EMPTY;
            }
            FluidStack fluidType = TankMultiBlock.this.parent.getFluidType();
            if (fluidType.isEmpty()) {
                return FluidStack.EMPTY;
            }
            return TankMultiBlock.this.parent.doDrainLiquid(TankMultiBlock.this.getMultiTankDrainOrder(), amount, action);
        }
    }

    public static class Container
    extends SimpleItemContainer {
        public Container() {
            super(4);
        }

        private Container(Runnable updateCallback) {
            super(4, updateCallback);
        }

        public boolean isValid(int slot, @NotNull ItemStack stack) {
            if (!super.isValid(slot, stack) || slot % 2 != 0) {
                return false;
            }
            LazyOptional handler = stack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM);
            return handler.map(fluidHandler -> {
                FluidStack fluid = fluidHandler.getFluidInTank(0);
                return slot == 0 && !fluid.isEmpty() || slot == 2 && fluidHandler.getTankCapacity(0) - fluid.getAmount() > 0;
            }).orElse(false);
        }
    }

    private static class ItemHandlerBehavior
    implements ItemContainer.ItemHandlerBehavior {
        private static final ItemHandlerBehavior INSTANCE = new ItemHandlerBehavior();

        private ItemHandlerBehavior() {
        }

        public boolean canExtract(int slot) {
            return slot % 2 == 1;
        }
    }

    private class Section
    implements MultiTank.FluidAmountContainer {
        private final int capacity;
        private final int fluidUnderSection;

        private Section() {
            this.capacity = TankMultiBlock.this.getLayerCapacity() * this.getHeight();
            this.fluidUnderSection = (this.getBottom() - TankMultiBlock.this.getBottom()) * TankMultiBlock.this.getLayerCapacity();
        }

        public int getBottom() {
            return TankMultiBlock.this.getBottom();
        }

        public int getHeight() {
            return TankMultiBlock.this.getHeight();
        }

        @Override
        public int getCapacity() {
            return this.capacity;
        }

        @Override
        public int getFluidAmount() {
            return TankMultiBlock.this.getFluidAmount() - this.fluidUnderSection;
        }

        @Override
        public void setFluidAmount(int amount, MultiTank.TankOperation operation) {
            int fluidInTank = TankMultiBlock.this.getFluidAmount();
            int newFluidInTank = this.fluidUnderSection + amount;
            if (operation == MultiTank.TankOperation.FILL && fluidInTank >= newFluidInTank) {
                return;
            }
            if (operation == MultiTank.TankOperation.DRAIN && fluidInTank <= newFluidInTank) {
                return;
            }
            TankMultiBlock.this.setFluidAmount(newFluidInTank, operation);
        }

        public static class Group
        implements MultiTank.IOGroup {
            private final List<Section> sections;
            private final int gcd;
            private final long capacity;

            public Group(List<Section> sections) {
                this.sections = sections;
                this.gcd = MultiTank.FluidAmountContainer.getGCD(sections);
                this.capacity = MultiTank.FluidAmountContainer.getCapacity(sections);
            }

            @Override
            public long getCapacity() {
                return this.capacity;
            }

            @Override
            public long getFluidAmount() {
                return MultiTank.FluidAmountContainer.getFluidAmount(this.sections);
            }

            @Override
            public void setFluidAmount(long amount, MultiTank.TankOperation operation) {
                MultiTank.FluidAmountContainer.distribute(this.sections, this.capacity, this.gcd, amount, operation);
            }
        }
    }

    public static interface IMember {
        public Iterable<TankMultiBlock> getMultiBlocks();

        public void join(TankMultiBlock var1);

        public void leave(TankMultiBlock var1);
    }

    private static class FormationRules
    implements CuboidMultiBlockDescriptor.FormationRules {
        private FormationRules() {
        }

        @Override
        public int getMaxSize(Direction.Axis axis) {
            return (Integer)MachinesConfig.TankSizeLimit.get();
        }

        @Override
        public boolean isValid(BlockGetter level, BlockPos pos, CuboidMultiBlockDescriptor.BlockUsage type) {
            BlockState state = level.m_8055_(pos);
            if (type == CuboidMultiBlockDescriptor.BlockUsage.WALL) {
                if (state.m_204336_(MachinesTags.Blocks.TankMultiBlockValidFace)) {
                    return true;
                }
                if (state.m_204336_(MachinesTags.Blocks.TankMultiBlockInvalidFace)) {
                    return false;
                }
            } else if (type == CuboidMultiBlockDescriptor.BlockUsage.EDGE) {
                if (state.m_204336_(MachinesTags.Blocks.TankMultiBlockValidFrame)) {
                    return true;
                }
                if (state.m_204336_(MachinesTags.Blocks.TankMultiBlockInvalidFrame)) {
                    return false;
                }
            } else if (type == CuboidMultiBlockDescriptor.BlockUsage.INNER) {
                if (state.m_204336_(MachinesTags.Blocks.TankMultiBlockValidEmpty)) {
                    return true;
                }
                if (state.m_204336_(MachinesTags.Blocks.TankMultiBlockInvalidEmpty)) {
                    return false;
                }
                if (CuboidMultiBlockDescriptor.FormationRules.isBlockGenerallyAccepted(level, pos, type)) {
                    return true;
                }
                return state.m_60795_();
            }
            return CuboidMultiBlockDescriptor.FormationRules.isBlockGenerallyAccepted(level, pos, type);
        }
    }
}

