/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.machines.content.multiblock;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Reference2LongMap;
import it.unimi.dsi.fastutil.objects.Reference2LongOpenHashMap;
import java.io.File;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.Nullable;
import tv.soaryn.xycraft.core.utils.FastVolumeLookup;
import tv.soaryn.xycraft.core.utils.MathUtils;
import tv.soaryn.xycraft.machines.content.multiblock.CuboidMultiBlockDescriptor;
import tv.soaryn.xycraft.machines.content.multiblock.TankMultiBlock;

public class MultiTank
extends SavedData {
    private final UUID id;
    private final ServerLevel level;
    private final Int2ObjectMap<TankMultiBlock> members = new Int2ObjectOpenHashMap();
    private int nextMemberId = 0;
    private FluidStack fluidType = FluidStack.EMPTY;
    private long capacity = 0L;
    private int gcd = 0;
    private boolean isValid;

    private MultiTank(ServerLevel level) {
        this(UUID.randomUUID(), level, true);
    }

    private MultiTank(UUID id, ServerLevel level, boolean isValid) {
        this.id = id;
        this.level = level;
        this.isValid = isValid;
    }

    public UUID getId() {
        return this.id;
    }

    public ServerLevel getLevel() {
        return this.level;
    }

    public boolean isValid() {
        return this.isValid;
    }

    public FluidStack getFluidType() {
        return this.fluidType;
    }

    public void setFluidType(FluidStack fluidType) {
        this.fluidType = fluidType;
    }

    private long getFluidAmount() {
        long amount = 0L;
        for (TankMultiBlock tank : this.members.values()) {
            amount += (long)tank.getFluidAmount();
        }
        return amount;
    }

    @Nullable
    public TankMultiBlock getMember(int id) {
        return (TankMultiBlock)this.members.get(id);
    }

    public TankMultiBlock addMember(CuboidMultiBlockDescriptor descriptor, @Nullable Set<TankMultiBlock.IMember> members) {
        int id = this.nextMemberId++;
        TankMultiBlock multiBlock = new TankMultiBlock(this, id, descriptor, members);
        this.members.put(id, (Object)multiBlock);
        this.m_77762_();
        FastVolumeLookup.of((Level)this.level, TankMultiBlock.class).add((Object)multiBlock, descriptor.min(), descriptor.max());
        int multiBlockCapacity = multiBlock.getCapacity();
        this.capacity += (long)multiBlockCapacity;
        this.gcd = MathUtils.gcd((int)this.gcd, (int)multiBlockCapacity);
        return multiBlock;
    }

    public void removeMember(int id) {
        if (this.members.size() == 1) {
            this.isValid = false;
            FastVolumeLookup.of((Level)this.level, TankMultiBlock.class).remove((Object)((TankMultiBlock)this.members.values().iterator().next()));
            return;
        }
        TankMultiBlock member = (TankMultiBlock)this.members.remove(id);
        if (member != null) {
            FastVolumeLookup.of((Level)this.level, TankMultiBlock.class).remove((Object)member);
            this.capacity -= (long)member.getCapacity();
            this.gcd = FluidAmountContainer.getGCD((Iterable<? extends FluidAmountContainer>)this.members.values());
        }
    }

    public int doFillLiquid(Iterable<IOGroup> fillOrder, FluidStack fluidType, int amount, IFluidHandler.FluidAction action) {
        FluidCache cache = new FluidCache(TankOperation.FILL);
        int remainder = amount;
        for (IOGroup group : fillOrder) {
            long storedFluid = cache.get(group);
            long capacity = group.getCapacity();
            long newStoredFluid = Math.min(storedFluid + (long)remainder, capacity);
            cache.set(group, newStoredFluid);
            if ((remainder -= (int)(newStoredFluid - storedFluid)) > 0) continue;
            break;
        }
        if (action == IFluidHandler.FluidAction.EXECUTE) {
            if (this.getFluidType().isEmpty()) {
                this.setFluidType(fluidType.copy());
            }
            cache.commit();
        }
        return amount - remainder;
    }

    public FluidStack doDrainLiquid(Iterable<IOGroup> drainOrder, int amount, IFluidHandler.FluidAction action) {
        FluidCache cache = new FluidCache(TankOperation.DRAIN);
        int remainder = amount;
        for (IOGroup group : drainOrder) {
            long storedFluid = cache.get(group);
            int extracted = (int)Math.min(storedFluid, (long)remainder);
            long newStoredFluid = storedFluid - (long)extracted;
            cache.set(group, newStoredFluid);
            if ((remainder -= extracted) > 0) continue;
            break;
        }
        FluidStack drainedStack = this.getFluidType().copy();
        drainedStack.setAmount(amount - remainder);
        if (action == IFluidHandler.FluidAction.EXECUTE) {
            cache.commit();
            if (this.getFluidAmount() == 0L) {
                this.setFluidType(FluidStack.EMPTY);
            }
        }
        return drainedStack;
    }

    public int doFillGas(FluidStack fluidType, int amount, IFluidHandler.FluidAction action) {
        long fluidAmount = this.getFluidAmount();
        long newAmount = Math.min(fluidAmount + (long)amount, this.capacity);
        if (action == IFluidHandler.FluidAction.EXECUTE && newAmount != fluidAmount) {
            if (this.getFluidType().isEmpty()) {
                this.setFluidType(fluidType.copy());
            }
            FluidAmountContainer.distribute((Iterable<? extends FluidAmountContainer>)this.members.values(), this.capacity, this.gcd, amount, TankOperation.FILL);
        }
        return (int)(newAmount - fluidAmount);
    }

    public FluidStack doDrainGas(int amount, IFluidHandler.FluidAction action) {
        long fluidAmount = this.getFluidAmount();
        if (fluidAmount == 0L) {
            return FluidStack.EMPTY;
        }
        long newAmount = Math.max(0L, fluidAmount - (long)amount);
        FluidStack drained = this.getFluidType().copy();
        drained.setAmount((int)(fluidAmount - newAmount));
        if (action == IFluidHandler.FluidAction.EXECUTE && newAmount != fluidAmount) {
            FluidAmountContainer.distribute((Iterable<? extends FluidAmountContainer>)this.members.values(), this.capacity, this.gcd, amount, TankOperation.DRAIN);
            if (amount == 0) {
                this.setFluidType(FluidStack.EMPTY);
            }
        }
        return drained;
    }

    public CompoundTag m_7176_(CompoundTag tag) {
        tag.m_128379_("valid", this.isValid);
        tag.m_128405_("next_member_id", this.nextMemberId);
        ListTag memberList = this.members.int2ObjectEntrySet().stream().map(entry -> {
            CompoundTag t = ((TankMultiBlock)entry.getValue()).save();
            t.m_128405_("__id", entry.getIntKey());
            return t;
        }).collect(Collectors.toCollection(ListTag::new));
        tag.m_128365_("members", (Tag)memberList);
        tag.m_128365_("fluid_type", (Tag)this.fluidType.writeToNBT(new CompoundTag()));
        return tag;
    }

    public void m_77757_(File file) {
        file.getParentFile().mkdirs();
        super.m_77757_(file);
    }

    private static String getStoragePath(UUID id) {
        return "xycraft_machines/multi_tank/" + id.toString().replace("-", "");
    }

    @Nullable
    static MultiTank get(ServerLevel level, UUID id) {
        return (MultiTank)level.m_7654_().m_129783_().m_8895_().m_164858_(tag -> {
            MultiTank multiTank = new MultiTank(id, level, tag.m_128471_("valid"));
            multiTank.nextMemberId = tag.m_128451_("next_member_id");
            multiTank.fluidType = FluidStack.loadFluidStackFromNBT((CompoundTag)tag.m_128469_("fluid_type"));
            for (Tag t : tag.m_128437_("members", 10)) {
                CompoundTag tc = (CompoundTag)t;
                int memberId = tc.m_128451_("__id");
                TankMultiBlock member = new TankMultiBlock(multiTank, memberId, tc);
                multiTank.members.put(memberId, (Object)member);
                if (!multiTank.isValid) continue;
                CuboidMultiBlockDescriptor descriptor = member.getDescriptor();
                FastVolumeLookup.of((Level)level, TankMultiBlock.class).add((Object)member, descriptor.min(), descriptor.max());
            }
            return multiTank;
        }, MultiTank.getStoragePath(id));
    }

    static MultiTank create(ServerLevel level) {
        MultiTank multiTank = new MultiTank(level);
        multiTank.m_77762_();
        level.m_7654_().m_129783_().m_8895_().m_164855_(MultiTank.getStoragePath(multiTank.id), (SavedData)multiTank);
        return multiTank;
    }

    public static interface FluidAmountContainer {
        public int getCapacity();

        public int getFluidAmount();

        public void setFluidAmount(int var1, TankOperation var2);

        public static int getGCD(Iterable<? extends FluidAmountContainer> containers) {
            int gcd = 0;
            for (FluidAmountContainer fluidAmountContainer : containers) {
                int capacity = fluidAmountContainer.getCapacity();
                gcd = gcd != 0 ? MathUtils.gcd((int)gcd, (int)capacity) : capacity;
            }
            return gcd;
        }

        public static long getCapacity(Iterable<? extends FluidAmountContainer> containers) {
            long capacity = 0L;
            for (FluidAmountContainer fluidAmountContainer : containers) {
                capacity += (long)fluidAmountContainer.getCapacity();
            }
            return capacity;
        }

        public static long getFluidAmount(Iterable<? extends FluidAmountContainer> containers) {
            long amount = 0L;
            for (FluidAmountContainer fluidAmountContainer : containers) {
                amount += (long)fluidAmountContainer.getFluidAmount();
            }
            return amount;
        }

        public static void distribute(Iterable<? extends FluidAmountContainer> containers, long capacity, long gcd, long amount, TankOperation operation) {
            if (amount == 0L) {
                for (FluidAmountContainer fluidAmountContainer : containers) {
                    fluidAmountContainer.setFluidAmount(0, operation);
                }
                return;
            }
            if (amount == capacity) {
                for (FluidAmountContainer fluidAmountContainer : containers) {
                    fluidAmountContainer.setFluidAmount(fluidAmountContainer.getCapacity(), operation);
                }
                return;
            }
            long minFluidPerLayer = capacity / gcd;
            long layers = amount / minFluidPerLayer;
            long leftoverMilliBuckets = amount % minFluidPerLayer;
            for (FluidAmountContainer fluidAmountContainer : containers) {
                long fluidPerLayer = (long)fluidAmountContainer.getCapacity() / gcd;
                long leftoverMilliBucketsInSection = Math.min(leftoverMilliBuckets, fluidPerLayer);
                fluidAmountContainer.setFluidAmount((int)(fluidPerLayer * layers + (leftoverMilliBuckets -= leftoverMilliBucketsInSection)), operation);
            }
        }
    }

    public static class FluidCache {
        private final Reference2LongMap<IOGroup> cache = new Reference2LongOpenHashMap();
        private final TankOperation operation;

        public FluidCache(TankOperation operation) {
            this.operation = operation;
        }

        public long get(IOGroup group) {
            return this.cache.computeIfAbsent((Object)group, IOGroup::getFluidAmount);
        }

        public void set(IOGroup group, long amount) {
            this.cache.put((Object)group, amount);
        }

        public void commit() {
            this.cache.forEach((group, amount) -> group.setFluidAmount((long)amount, this.operation));
        }
    }

    public static enum TankOperation {
        FILL,
        DRAIN;

    }

    public static interface IOGroup {
        public long getCapacity();

        public long getFluidAmount();

        public void setFluidAmount(long var1, TankOperation var3);
    }
}

