/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.machines.content.blocks.selectors;

import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tv.soaryn.xycraft.core.content.blocks.CoreStateProperties;
import tv.soaryn.xycraft.core.content.blocks.entities.CoreBlockEntity;
import tv.soaryn.xycraft.core.content.blocks.entities.ITickable;
import tv.soaryn.xycraft.machines.config.MachinesConfig;
import tv.soaryn.xycraft.machines.content.MachinesContent;
import tv.soaryn.xycraft.machines.content.blocks.selectors.SelectorAbstractBlock;
import tv.soaryn.xycraft.machines.utils.handler.InfiniteEnergyHandler;

public class EnergySelectorBlock
extends SelectorAbstractBlock {
    @Override
    @Nullable
    public BlockEntity m_142194_(@NotNull BlockPos pos, @NotNull BlockState state) {
        return new Entity(pos, state);
    }

    @Override
    @NotNull
    public InteractionResult onCenterHit(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand interactionHand, @NotNull BlockHitResult hitResult) {
        return InteractionResult.PASS;
    }

    public static class Entity
    extends CoreBlockEntity
    implements ITickable.Server {
        public final InfiniteEnergyHandler EnergyBuffer = new InfiniteEnergyHandler();
        private int _seed;

        public Entity(BlockPos pos, BlockState state) {
            super(MachinesContent.EnergySelector.entity(), pos, state);
        }

        public void onLoad() {
            super.onLoad();
            this._seed = this.m_58899_().hashCode();
        }

        public void invalidateCaps() {
            super.invalidateCaps();
            this.EnergyBuffer.Handle.invalidate();
        }

        public static BlockEntityType<?> supplier(Block block) {
            return new BlockEntityType(Entity::new, Set.of(block), CoreBlockEntity.DefaultFixer);
        }

        public void tickServer(@NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState state) {
            if (ITickable.shouldTick((Level)level, (int)this._seed, (int)((Integer)MachinesConfig.SelectorProcessFrequency.get()))) {
                Direction direction = (Direction)state.m_61143_((Property)CoreStateProperties.StateDirection);
                BlockPos posOfOther = pos.m_121945_(direction);
                BlockEntity otherBlockEntity = level.m_7702_(posOfOther);
                if (otherBlockEntity == null) {
                    return;
                }
                otherBlockEntity.getCapability(ForgeCapabilities.ENERGY, direction.m_122424_()).ifPresent(handler -> handler.receiveEnergy(((Integer)MachinesConfig.SelectorPowerAmount.get()).intValue(), false));
            }
        }

        @NotNull
        public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
            if (this.m_58900_().m_61143_((Property)CoreStateProperties.StateDirection) == side && cap == ForgeCapabilities.ENERGY) {
                return this.EnergyBuffer.Handle.cast();
            }
            return super.getCapability(cap, side);
        }
    }
}

