/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.machines.content.blocks.multiblock;

import java.util.List;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tv.soaryn.xycraft.core.content.blocks.CoreStateProperties;
import tv.soaryn.xycraft.core.content.blocks.entities.CoreBlockEntity;
import tv.soaryn.xycraft.core.content.blocks.entities.IDataSync;
import tv.soaryn.xycraft.core.content.blocks.entities.IPacketDataSync;
import tv.soaryn.xycraft.machines.client.content.multiblock.ClientTankCache;
import tv.soaryn.xycraft.machines.content.blocks.properties.MachineStateProperties;
import tv.soaryn.xycraft.machines.content.multiblock.TankMultiBlock;

public abstract class TankMemberBlockEntity
extends CoreBlockEntity
implements TankMultiBlock.IMember {
    @Nullable
    private final TankMultiBlock[] multiBlocks = new TankMultiBlock[2];

    public TankMemberBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.Data = new MemberData();
    }

    public boolean canPreserveFluid() {
        return false;
    }

    public boolean isFormed() {
        return this.multiBlocks[0] != null && this.multiBlocks[0].isValid() || this.multiBlocks[1] != null && this.multiBlocks[1].isValid();
    }

    @Override
    public Iterable<TankMultiBlock> getMultiBlocks() {
        if (this.multiBlocks[0] != null) {
            if (this.multiBlocks[1] == null) {
                return List.of(this.multiBlocks[0]);
            }
        } else if (this.multiBlocks[1] != null && this.multiBlocks[1].isValid()) {
            return List.of(this.multiBlocks[1]);
        }
        return List.of();
    }

    @Override
    public void join(TankMultiBlock multiBlock) {
        this.m_6596_();
        if (this.multiBlocks[0] == null || !this.multiBlocks[0].isValid()) {
            this.multiBlocks[0] = multiBlock;
        } else if (this.multiBlocks[1] == null || !this.multiBlocks[1].isValid()) {
            this.multiBlocks[1] = multiBlock;
        } else {
            throw new IllegalStateException();
        }
        this.updateStateAndCaps();
    }

    @Override
    public void leave(TankMultiBlock multiBlock) {
        this.m_6596_();
        if (multiBlock == this.multiBlocks[0]) {
            if (!this.canPreserveFluid()) {
                this.multiBlocks[0] = null;
            } else if (this.multiBlocks[1] != null) {
                if (this.multiBlocks[1].isValid()) {
                    this.multiBlocks[0] = null;
                } else {
                    this.multiBlocks[1] = null;
                }
            }
        } else if (multiBlock == this.multiBlocks[1]) {
            if (!this.canPreserveFluid()) {
                this.multiBlocks[1] = null;
            } else if (this.multiBlocks[0] != null) {
                if (this.multiBlocks[0].isValid()) {
                    this.multiBlocks[1] = null;
                } else {
                    this.multiBlocks[0] = null;
                }
            }
        } else {
            return;
        }
        this.updateStateAndCaps();
    }

    private void updateStateAndCaps() {
        Level level;
        if (this.m_58901_()) {
            return;
        }
        Direction.Axis axis = Direction.Axis.Y;
        this.invalidateTankCaps();
        if (this.multiBlocks[0] != null && this.multiBlocks[0].isValid()) {
            if (this.multiBlocks[1] == null) {
                this.setupTankCaps(this.multiBlocks[0]);
                axis = this.multiBlocks[0].determineAxis(this.m_58899_());
            }
        } else if (this.multiBlocks[1] != null && this.multiBlocks[1].isValid()) {
            this.setupTankCaps(this.multiBlocks[1]);
            axis = this.multiBlocks[1].determineAxis(this.m_58899_());
        }
        if ((level = this.m_58904_()) != null) {
            level.m_46597_(this.m_58899_(), (BlockState)((BlockState)this.m_58900_().m_61124_((Property)CoreStateProperties.Axis, (Comparable)axis)).m_61124_((Property)MachineStateProperties.Initialized, (Comparable)Boolean.valueOf(this.isFormed())));
        }
        this.m_6596_();
    }

    protected abstract void invalidateTankCaps();

    protected abstract void setupTankCaps(TankMultiBlock var1);

    private class MemberData
    implements IDataSync,
    IPacketDataSync {
        @Nullable
        private final CompoundTag[] serializedMultiBlocks;
        boolean hasLoaded;

        private MemberData() {
            this.serializedMultiBlocks = new CompoundTag[TankMemberBlockEntity.this.multiBlocks.length];
            this.hasLoaded = false;
        }

        public void save(CoreBlockEntity coreBlockEntity, @NotNull CompoundTag tag) {
            for (int i = 0; i < TankMemberBlockEntity.this.multiBlocks.length; ++i) {
                if (TankMemberBlockEntity.this.multiBlocks[i] == null) continue;
                tag.m_128365_("tank" + i, (Tag)TankMemberBlockEntity.this.multiBlocks[i].describeForSave());
            }
        }

        public void load(CoreBlockEntity coreBlockEntity, @NotNull CompoundTag tag) {
            for (int i = 0; i < TankMemberBlockEntity.this.multiBlocks.length; ++i) {
                this.serializedMultiBlocks[i] = tag.m_128441_("tank" + i) ? tag.m_128469_("tank" + i) : null;
            }
        }

        public void onLoad(CoreBlockEntity coreBlockEntity) {
            Level level = TankMemberBlockEntity.this.m_58904_();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                this.hasLoaded = true;
                TankMemberBlockEntity.this.invalidateTankCaps();
                TankMultiBlock capsMultiBlock = null;
                int loaded = 0;
                for (int i = 0; i < TankMemberBlockEntity.this.multiBlocks.length; ++i) {
                    CompoundTag serializedMultiBlock = this.serializedMultiBlocks[i];
                    if (serializedMultiBlock != null) {
                        TankMultiBlock multiBlock = TankMemberBlockEntity.this.multiBlocks[i] = TankMultiBlock.get(serverLevel, serializedMultiBlock);
                        this.serializedMultiBlocks[i] = null;
                        if (multiBlock == null || !multiBlock.isValid()) continue;
                        capsMultiBlock = multiBlock;
                        ++loaded;
                        continue;
                    }
                    TankMemberBlockEntity.this.multiBlocks[i] = null;
                }
                if (loaded == 1) {
                    TankMemberBlockEntity.this.setupTankCaps(capsMultiBlock);
                    serverLevel.m_7260_(TankMemberBlockEntity.this.m_58899_(), TankMemberBlockEntity.this.m_58900_(), TankMemberBlockEntity.this.m_58900_(), 3);
                }
            }
        }

        public void invalidate(CoreBlockEntity coreBlockEntity) {
            TankMemberBlockEntity.this.invalidateTankCaps();
        }

        @NotNull
        public CompoundTag getClientPacketData(CoreBlockEntity coreBlockEntity) {
            Level level;
            CompoundTag tag = new CompoundTag();
            if (!this.hasLoaded && (level = coreBlockEntity.m_58904_()) instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                for (int i = 0; i < TankMemberBlockEntity.this.multiBlocks.length; ++i) {
                    TankMultiBlock multiBlock;
                    CompoundTag serializedMultiBlock = this.serializedMultiBlocks[i];
                    TankMultiBlock tankMultiBlock = multiBlock = serializedMultiBlock != null ? TankMultiBlock.get(serverLevel, serializedMultiBlock) : null;
                    if (multiBlock == null || !multiBlock.isValid()) continue;
                    tag.m_128365_("tank" + i, (Tag)multiBlock.describeForSync());
                }
            } else {
                for (int i = 0; i < TankMemberBlockEntity.this.multiBlocks.length; ++i) {
                    TankMultiBlock multiBlock = TankMemberBlockEntity.this.multiBlocks[i];
                    if (multiBlock == null || !multiBlock.isValid()) continue;
                    tag.m_128365_("tank" + i, (Tag)multiBlock.describeForSync());
                }
            }
            return tag;
        }

        public void handleClientPacketData(CoreBlockEntity coreBlockEntity, CompoundTag tag) {
            Level level = Objects.requireNonNull(TankMemberBlockEntity.this.m_58904_());
            for (int i = 0; i < TankMemberBlockEntity.this.multiBlocks.length; ++i) {
                if (!tag.m_128441_("tank" + i)) continue;
                ClientTankCache.of(level).load(tag.m_128469_("tank" + i));
            }
        }
    }
}

