/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.machines.content.blocks.basic;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.fluids.FluidInteractionRegistry;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;
import tv.soaryn.xycraft.core.content.CustomColors;
import tv.soaryn.xycraft.core.content.blocks.ColoredBlock;
import tv.soaryn.xycraft.core.content.capabilities.volumes.HydrationVolumeCache;
import tv.soaryn.xycraft.core.utils.ColorSource;
import tv.soaryn.xycraft.core.utils.container.InfiniteFluidSourceCache;
import tv.soaryn.xycraft.machines.config.MachinesConfig;
import tv.soaryn.xycraft.world.content.WorldContent;

public class WaterBlock
extends ColoredBlock {
    private final IFluidHandler source = new InfiniteFluidSourceCache((Fluid)Fluids.f_76193_);

    public WaterBlock() {
        super((ColorSource)CustomColors.Blue, WorldContent.KiviProperties());
    }

    @NotNull
    public InteractionResult m_6227_(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand interactionHand, @NotNull BlockHitResult hit) {
        if (((Boolean)MachinesConfig.WaterBlockFillsContainer.get()).booleanValue() && !player.m_7500_()) {
            if (FluidUtil.interactWithFluidHandler((Player)player, (InteractionHand)interactionHand, (IFluidHandler)this.source)) {
                return InteractionResult.m_19078_((boolean)level.m_5776_());
            }
            ItemStack stack = player.m_21120_(interactionHand);
            if (stack.m_150930_(Items.f_42590_)) {
                if (!level.m_5776_()) {
                    Item item = stack.m_41720_();
                    player.m_21008_(interactionHand, ItemUtils.m_41813_((ItemStack)stack, (Player)player, (ItemStack)PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42589_), (Potion)Potions.f_43599_)));
                    player.m_36246_(Stats.f_12982_.m_12902_((Object)item));
                    level.m_5594_(null, pos, SoundEvents.f_11770_, SoundSource.BLOCKS, 1.0f, 1.0f);
                    level.m_142346_(null, GameEvent.f_157816_, pos);
                }
                return InteractionResult.m_19078_((boolean)level.m_5776_());
            }
        }
        return super.m_6227_(state, level, pos, player, interactionHand, hit);
    }

    public void m_6807_(@NotNull BlockState blockState, @NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState newState, boolean p_54758_) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            HydrationVolumeCache.of((Level)serverLevel).add((Level)serverLevel, pos);
        }
        WaterBlock.hardcodeTempFix(level, pos, pos.m_121945_(Direction.UP));
    }

    public void m_6810_(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState oldState, boolean moving) {
        super.m_6810_(state, level, pos, oldState, moving);
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            HydrationVolumeCache.of((Level)serverLevel).remove((Level)serverLevel, pos);
        }
    }

    public static void init() {
        MinecraftForge.EVENT_BUS.addGenericListener(Level.class, HydrationVolumeCache::register);
        MinecraftForge.EVENT_BUS.addListener(WaterBlock::onLoad);
    }

    public static void onLoad(LevelEvent.Load event) {
        LevelAccessor levelAccessor = event.getLevel();
        if (levelAccessor instanceof ServerLevel) {
            ServerLevel level = (ServerLevel)levelAccessor;
            HydrationVolumeCache.of((Level)level).load((Level)level);
        }
    }

    public void m_6861_(@NotNull BlockState blockState, @NotNull Level level, @NotNull BlockPos pos, @NotNull Block block, @NotNull BlockPos neighborPos, boolean p_54714_) {
        WaterBlock.hardcodeTempFix(level, pos, neighborPos);
    }

    private static void hardcodeTempFix(@NotNull Level level, @NotNull BlockPos pos, @NotNull BlockPos neighborPos) {
        BlockState fluidBlock;
        FluidState fluidState;
        if (!FluidInteractionRegistry.canInteract((Level)level, (BlockPos)pos) && (fluidState = (fluidBlock = level.m_8055_(neighborPos)).m_60819_()).m_205070_(FluidTags.f_13132_)) {
            Block b = fluidState.m_76170_() ? Blocks.f_50080_ : Blocks.f_50069_;
            level.m_46597_(neighborPos, b.m_49966_());
            level.m_46796_(1501, neighborPos, 0);
        }
    }
}

