/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.machines.content.blocks.basic;

import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.common.IPlantable;
import org.jetbrains.annotations.NotNull;
import tv.soaryn.xycraft.core.content.CustomColors;
import tv.soaryn.xycraft.core.content.blocks.ColoredBlock;
import tv.soaryn.xycraft.core.content.blocks.CoreStateProperties;
import tv.soaryn.xycraft.core.content.blocks.IWrenchUse;
import tv.soaryn.xycraft.core.content.blocks.prototype.GrowableImplementations;
import tv.soaryn.xycraft.core.content.blocks.prototype.GrowthType;
import tv.soaryn.xycraft.core.content.blocks.prototype.IGrowableBlock;
import tv.soaryn.xycraft.core.content.capabilities.player.ModifierKeyCapability;
import tv.soaryn.xycraft.core.utils.ColorSource;
import tv.soaryn.xycraft.machines.config.MachinesConfig;
import tv.soaryn.xycraft.machines.content.MachinesContent;
import tv.soaryn.xycraft.world.content.WorldContent;

public class PlanterBlock
extends ColoredBlock {
    public PlanterBlock() {
        super((ColorSource)CustomColors.Green, WorldContent.KiviProperties().m_60977_());
        this.m_49966_().m_61124_((Property)CoreStateProperties.StateDirection, (Comparable)Direction.UP);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{CoreStateProperties.StateDirection});
    }

    @NotNull
    public BlockState m_5573_(BlockPlaceContext ctx) {
        Direction direction = ModifierKeyCapability.of((Player)ctx.m_43723_()) ? ctx.m_43719_().m_122424_() : ctx.m_43719_();
        return (BlockState)this.m_49966_().m_61124_((Property)CoreStateProperties.StateDirection, (Comparable)direction);
    }

    @NotNull
    public InteractionResult m_6227_(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand interactionHand, @NotNull BlockHitResult hitResult) {
        InteractionResult wrenchResult;
        if (IWrenchUse.hasWrenchLikeAction((Player)player, (ItemStack)player.m_21120_(interactionHand), (boolean)true) && (wrenchResult = IWrenchUse.rotate((BlockState)state, (Level)level, (BlockPos)pos, (BlockHitResult)hitResult)) != null) {
            return wrenchResult;
        }
        return super.m_6227_(state, level, pos, player, interactionHand, hitResult);
    }

    public boolean isFertile(BlockState state, BlockGetter level, BlockPos pos) {
        return true;
    }

    public boolean canSustainPlant(@NotNull BlockState state, @NotNull BlockGetter world, @NotNull BlockPos pos, @NotNull Direction facing, @NotNull IPlantable plantable) {
        return facing == state.m_61143_((Property)CoreStateProperties.StateDirection);
    }

    public void m_213897_(BlockState p_222543_, @NotNull ServerLevel level, @NotNull BlockPos pos, @NotNull RandomSource randSource) {
        if (!p_222543_.m_60710_((LevelReader)level, pos)) {
            level.m_46961_(pos, true);
        }
    }

    public void m_213898_(@NotNull BlockState blockState, ServerLevel level, BlockPos pos, @NotNull RandomSource randSource) {
        IPlantable plantable;
        int planterCount;
        Direction dir = (Direction)blockState.m_61143_((Property)CoreStateProperties.StateDirection);
        Direction supportingPlanterDirection = dir.m_122424_();
        BlockPos plantLocation = pos.m_121945_(dir);
        BlockState focusedBlockState = level.m_8055_(plantLocation);
        Block plantBlock = focusedBlockState.m_60734_();
        if (plantBlock == MachinesContent.Planter.block() || focusedBlockState.m_60795_()) {
            return;
        }
        for (planterCount = 1; level.m_8055_(pos.m_5484_(supportingPlanterDirection, planterCount)) == blockState && planterCount <= (Integer)MachinesConfig.PlanterLimit.get(); ++planterCount) {
        }
        HashMap<Block, IGrowableBlock> growableMap = new HashMap<Block, IGrowableBlock>();
        growableMap.put(Blocks.f_50128_, GrowableImplementations.ThreeTall);
        growableMap.put(Blocks.f_50130_, GrowableImplementations.ThreeTall);
        growableMap.put(Blocks.f_276665_, GrowableImplementations.Crop);
        growableMap.put(Blocks.f_271410_, GrowableImplementations.Crop);
        growableMap.put(Blocks.f_50092_, GrowableImplementations.Crop);
        growableMap.put(Blocks.f_50250_, GrowableImplementations.Crop);
        growableMap.put(Blocks.f_50444_, GrowableImplementations.Crop);
        growableMap.put(Blocks.f_50200_, GrowableImplementations.NetherWart);
        growableMap.put(Blocks.f_50491_, GrowableImplementations.ChorusFruit);
        growableMap.put(Blocks.f_50490_, GrowableImplementations.ChorusFruit);
        growableMap.put(Blocks.f_50262_, GrowableImplementations.CocoaBean);
        growableMap.put(Blocks.f_50571_, GrowableImplementations.Bamboo);
        IGrowableBlock growable = (IGrowableBlock)growableMap.get(plantBlock);
        ArrayList listOfPositions = new ArrayList();
        if (growable != null) {
            while (planterCount-- > 0) {
                ArrayList positionsUpdated = growable.grow(level.m_8055_(plantLocation), level, plantLocation, randSource, GrowthType.Random);
                listOfPositions.addAll(positionsUpdated);
            }
            if (!level.m_5776_() && !listOfPositions.isEmpty()) {
                for (BlockPos blockPos : listOfPositions.stream().distinct().toList()) {
                    level.m_46796_(1505, blockPos, 0);
                }
            }
            return;
        }
        if (!focusedBlockState.m_60713_((Block)this) && (plantBlock instanceof BonemealableBlock || plantBlock instanceof IPlantable && blockState.canSustainPlant((BlockGetter)level, pos, dir, plantable = (IPlantable)plantBlock))) {
            int topPlant = 1;
            BlockState plantCheck = level.m_8055_(pos.m_5484_(dir, topPlant + 1));
            while (plantCheck.m_60713_(plantBlock)) {
                plantCheck = level.m_8055_(pos.m_5484_(dir, ++topPlant + 1));
            }
            if (!level.m_8055_(pos.m_5484_(dir, topPlant)).m_60823_()) {
                return;
            }
            if (!level.f_46443_) {
                level.m_46796_(1505, pos.m_5484_(dir, topPlant), 0);
            }
            while (planterCount-- > 0) {
                BlockState activePlant = level.m_8055_(pos.m_5484_(dir, topPlant));
                activePlant.m_222972_(level, pos.m_5484_(dir, topPlant), randSource);
            }
        }
    }
}

