/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.machines.content.blocks;

import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tv.soaryn.xycraft.core.content.blocks.CoreStateProperties;
import tv.soaryn.xycraft.core.content.blocks.entities.CoreBlockEntity;
import tv.soaryn.xycraft.core.content.blocks.entities.IColorData;
import tv.soaryn.xycraft.core.content.blocks.entities.IDataSync;
import tv.soaryn.xycraft.core.content.blocks.entities.IPacketDataSync;
import tv.soaryn.xycraft.core.utils.ColorSource;
import tv.soaryn.xycraft.core.utils.container.ItemContainer;
import tv.soaryn.xycraft.core.utils.container.SimpleItemContainer;
import tv.soaryn.xycraft.machines.content.MachinesContent;
import tv.soaryn.xycraft.machines.gui.SoarynBoxMenu;

public class SoarynBoxBlockEntity
extends CoreBlockEntity
implements MenuProvider {
    public SoarynBoxBlockEntity(BlockPos pos, BlockState state) {
        super(MachinesContent.SoarynBox.entity(), pos, state);
        this.Data = new SoarynBoxData();
    }

    public SoarynBoxData getData() {
        return (SoarynBoxData)this.Data;
    }

    public static BlockEntityType<?> supplier(Block block) {
        return new BlockEntityType(SoarynBoxBlockEntity::new, Set.of(block), CoreBlockEntity.DefaultFixer);
    }

    @NotNull
    public Component m_5446_() {
        return Component.m_237115_((String)"block.xycraft_machines.soaryn_box");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int windowId, @NotNull Inventory playerInventory, @NotNull Player playerEntity) {
        return new SoarynBoxMenu(windowId, playerInventory, (BlockEntity)this, (ItemContainer)this.getData().Inventory, (ContainerData)this.getData().MenuData);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER && (side == null || ((Boolean)this.m_58900_().m_61143_((Property)CoreStateProperties.ActiveSideMap.get(side))).booleanValue())) {
            return this.getData().InventoryLazyHandle.cast();
        }
        return super.getCapability(cap, side);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        super.onDataPacket(net, pkt);
        Level level = this.m_58904_();
        if (level == null) {
            return;
        }
        level.markAndNotifyBlock(this.m_58899_(), level.m_46745_(this.m_58899_()), this.m_58900_(), this.m_58900_(), 3, 512);
    }

    public class SoarynBoxData
    implements IDataSync,
    IColorData,
    IPacketDataSync {
        public SimpleContainerData MenuData = new SimpleContainerData(1);
        public ItemContainer.Serializable Inventory = new SimpleItemContainer(27, () -> ((SoarynBoxBlockEntity)SoarynBoxBlockEntity.this).m_6596_());
        private final IItemHandler _itemHandler = this.Inventory.asItemHandler();
        private final LazyOptional<IItemHandler> InventoryLazyHandle = LazyOptional.of(() -> this._itemHandler);

        public void onLoad(CoreBlockEntity coreBlockEntity) {
        }

        public void save(CoreBlockEntity coreBlockEntity, @NotNull CompoundTag tag) {
            tag.m_128405_("color", this.MenuData.m_6413_(0));
            tag.m_128365_("inventory", (Tag)this.Inventory.serializeNBT());
        }

        public void load(CoreBlockEntity coreBlockEntity, @NotNull CompoundTag tag) {
            this.MenuData.m_8050_(0, tag.m_128451_("color"));
            if (tag.m_128441_("inventory")) {
                this.Inventory.deserializeNBT(tag.m_128469_("inventory"));
            }
        }

        @NotNull
        public CompoundTag getClientPacketData(CoreBlockEntity coreBlockEntity) {
            CompoundTag tag = new CompoundTag();
            tag.m_128405_("color", this.MenuData.m_6413_(0));
            return tag;
        }

        public void handleClientPacketData(CoreBlockEntity coreBlockEntity, CompoundTag tag) {
            this.MenuData.m_8050_(0, tag.m_128451_("color"));
        }

        public void invalidate(CoreBlockEntity coreBlockEntity) {
            this.InventoryLazyHandle.invalidate();
        }

        public ColorSource getColor() {
            return new ColorSource.Arbitrary(this.MenuData.m_6413_(0));
        }

        public void setColor(ColorSource color) {
            this.MenuData.m_8050_(0, color.getColor());
        }
    }
}

