/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.machines.content.blocks;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tv.soaryn.xycraft.core.content.BlockContent;
import tv.soaryn.xycraft.core.content.blocks.CoreStateProperties;
import tv.soaryn.xycraft.core.content.blocks.IColored;
import tv.soaryn.xycraft.core.content.blocks.IWrenchUse;
import tv.soaryn.xycraft.core.content.blocks.XyBlock;
import tv.soaryn.xycraft.core.content.capabilities.player.ColorCapability;
import tv.soaryn.xycraft.core.content.capabilities.player.ModifierKeyCapability;
import tv.soaryn.xycraft.core.utils.ColorSource;
import tv.soaryn.xycraft.core.utils.Utils;
import tv.soaryn.xycraft.core.utils.container.ItemContainer;
import tv.soaryn.xycraft.machines.content.MachinesContent;
import tv.soaryn.xycraft.machines.content.MachinesSounds;
import tv.soaryn.xycraft.machines.content.blocks.SoarynBoxBlockEntity;
import tv.soaryn.xycraft.world.content.WorldContent;

public class SoarynBoxBlock
extends XyBlock.WithEntity
implements IColored {
    private static final VoxelShape Shape = Shapes.m_83113_((VoxelShape)SoarynBoxBlock.m_49796_((double)1.0, (double)1.0, (double)1.0, (double)15.0, (double)15.0, (double)15.0), (VoxelShape)SoarynBoxBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (BooleanOp)BooleanOp.f_82687_);

    public SoarynBoxBlock() {
        super(WorldContent.KiviProperties().m_60955_(), () -> ((BlockContent)MachinesContent.SoarynBox).entity());
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)CoreStateProperties.ActiveSideDown, (Comparable)Boolean.valueOf(true))).m_61124_((Property)CoreStateProperties.ActiveSideUp, (Comparable)Boolean.valueOf(true))).m_61124_((Property)CoreStateProperties.ActiveSideNorth, (Comparable)Boolean.valueOf(true))).m_61124_((Property)CoreStateProperties.ActiveSideSouth, (Comparable)Boolean.valueOf(true))).m_61124_((Property)CoreStateProperties.ActiveSideWest, (Comparable)Boolean.valueOf(true))).m_61124_((Property)CoreStateProperties.ActiveSideEast, (Comparable)Boolean.valueOf(true)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{CoreStateProperties.ActiveSideDown});
        builder.m_61104_(new Property[]{CoreStateProperties.ActiveSideUp});
        builder.m_61104_(new Property[]{CoreStateProperties.ActiveSideNorth});
        builder.m_61104_(new Property[]{CoreStateProperties.ActiveSideSouth});
        builder.m_61104_(new Property[]{CoreStateProperties.ActiveSideWest});
        builder.m_61104_(new Property[]{CoreStateProperties.ActiveSideEast});
    }

    public boolean m_7923_(@NotNull BlockState state) {
        return true;
    }

    @NotNull
    public InteractionResult m_6227_(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand interactionHand, @NotNull BlockHitResult hitResult) {
        BlockEntity be = level.m_7702_(pos);
        ItemStack stack = player.m_21120_(interactionHand);
        DyeColor dyeColor = DyeColor.getColor((ItemStack)stack);
        if (interactionHand == InteractionHand.MAIN_HAND && dyeColor != null) {
            ColorSource.Dye color = new ColorSource.Dye(dyeColor);
            if (be instanceof SoarynBoxBlockEntity) {
                SoarynBoxBlockEntity entity = (SoarynBoxBlockEntity)be;
                if (color.getColor() != entity.getData().getColor().getColor()) {
                    entity.getData().setColor((ColorSource)color);
                    be.m_6596_();
                    level.m_7260_(pos, state, state, 3);
                    level.m_46597_(pos, state);
                    return InteractionResult.m_19078_((boolean)level.m_5776_());
                }
            }
        }
        if (IWrenchUse.hasWrenchLikeAction((Player)player, (ItemStack)stack, (boolean)true)) {
            level.m_46597_(pos, (BlockState)state.m_61122_((Property)CoreStateProperties.ActiveSideMap.get(hitResult.m_82434_())));
            if (be != null) {
                be.m_6596_();
            }
            return InteractionResult.m_19078_((boolean)level.m_5776_());
        }
        if (be instanceof SoarynBoxBlockEntity) {
            SoarynBoxBlockEntity entity = (SoarynBoxBlockEntity)be;
            level.m_5594_(null, pos, SoundEvents.f_12409_, SoundSource.BLOCKS, 0.05f, level.f_46441_.m_188501_() * 0.1f + 0.9f);
            if (!level.m_5776_() && !(player instanceof FakePlayer)) {
                NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)entity, (BlockPos)be.m_58899_());
            }
        }
        return InteractionResult.m_19078_((boolean)level.m_5776_());
    }

    public void m_6402_(@NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState state, @Nullable LivingEntity entity, @NotNull ItemStack stack) {
        super.m_6402_(level, pos, state, entity, stack);
        if (entity == null) {
            return;
        }
        if (entity instanceof Player) {
            Player player = (Player)entity;
            BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity instanceof SoarynBoxBlockEntity) {
                SoarynBoxBlockEntity box = (SoarynBoxBlockEntity)blockEntity;
                ColorSource.Arbitrary color = new ColorSource.Arbitrary(ColorCapability.colorOf((Player)player));
                DyeColor dye = DyeColor.getColor((ItemStack)player.m_21206_());
                if (dye != null) {
                    color = new ColorSource.Dye(dye);
                }
                box.getData().setColor((ColorSource)color);
                box.m_6596_();
                float r = Mth.m_14036_((float)(level.m_213780_().m_188501_() - 0.5f), (float)-0.01f, (float)0.1f);
                CompoundTag tag = stack.m_41783_();
                if (tag != null && tag.m_128441_("BlockEntityTag")) {
                    return;
                }
                if (!level.m_5776_() && ModifierKeyCapability.of((Player)player)) {
                    Inventory inventory = player.m_150109_();
                    ItemContainer.Serializable boxInv = box.getData().Inventory;
                    ArrayList<ItemStack> itemList = new ArrayList<ItemStack>();
                    for (int i = 9; i < inventory.f_35974_.size(); ++i) {
                        itemList.add(inventory.m_7407_(i, 64));
                    }
                    itemList.sort(Comparator.comparing(ItemStack::m_41778_));
                    if (itemList.stream().anyMatch(Predicate.not(ItemStack::m_41619_))) {
                        level.m_5594_(null, pos, (SoundEvent)MachinesSounds.SoarynBoxDeposit.get(), SoundSource.PLAYERS, 0.5f, 1.0f + r);
                    }
                    for (ItemStack itemStack : itemList) {
                        ItemHandlerHelper.insertItemStacked((IItemHandler)boxInv.asItemHandler(), (ItemStack)itemStack, (boolean)false);
                    }
                }
            }
        }
    }

    public void m_6810_(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, BlockState newState, boolean moving) {
        BlockEntity blockEntity;
        if (!state.m_60713_(newState.m_60734_()) && (blockEntity = level.m_7702_(pos)) instanceof SoarynBoxBlockEntity) {
            SoarynBoxBlockEntity entity = (SoarynBoxBlockEntity)blockEntity;
            Containers.m_19002_((Level)level, (BlockPos)pos, (Container)entity.getData().Inventory.asVanillaContainer());
        }
        super.m_6810_(state, level, pos, newState, moving);
    }

    @NotNull
    public VoxelShape m_5940_(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return Shape;
    }

    public int getColorOfBlock(BlockState state, BlockAndTintGetter level, BlockPos pos, int index) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof SoarynBoxBlockEntity) {
            SoarynBoxBlockEntity entity = (SoarynBoxBlockEntity)blockEntity;
            return entity.getData().getColor().getColor();
        }
        return super.getColorOfBlock(state, level, pos, index);
    }

    public int getColorOfItem(ItemStack stack, int index) {
        return ColorCapability.colorOf((Player)Utils.getClientPlayer());
    }
}

