/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.machines.content.blocks;

import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tv.soaryn.xycraft.core.content.blocks.CoreStateProperties;
import tv.soaryn.xycraft.core.content.blocks.entities.CoreBlockEntity;
import tv.soaryn.xycraft.core.content.blocks.entities.IDataSync;
import tv.soaryn.xycraft.core.content.blocks.entities.ITickable;
import tv.soaryn.xycraft.machines.config.MachinesConfig;
import tv.soaryn.xycraft.machines.content.MachinesContent;

public class NitrogenExtractorBlockEntity
extends CoreBlockEntity
implements ITickable.Server {
    public NitrogenExtractorBlockEntity(BlockPos pos, BlockState state) {
        super(MachinesContent.NitrogenExtractor.entity(), pos, state);
        this.Data = new NitrogenExtractorData();
    }

    public static BlockEntityType<?> supplier(Block block) {
        return new BlockEntityType(NitrogenExtractorBlockEntity::new, Set.of(block), CoreBlockEntity.DefaultFixer);
    }

    public NitrogenExtractorData getData() {
        return (NitrogenExtractorData)this.Data;
    }

    public void tickServer(@NotNull Level levelNew, @NotNull BlockPos posNew, @NotNull BlockState blockStateNew) {
        Level level = this.m_58904_();
        NitrogenExtractorData data = this.getData();
        if (level != null && (level.m_46467_() + (long)data.getSeed()) % (long)((Integer)MachinesConfig.SelectorProcessFrequency.get()).intValue() == 0L) {
            Direction direction = (Direction)this.m_58900_().m_61143_((Property)CoreStateProperties.StateDirection);
            Direction opposite = direction.m_122424_();
            BlockPos posOfOther = this.f_58858_.m_121945_(direction);
            BlockEntity otherBlockEntity = level.m_7702_(posOfOther);
            if (otherBlockEntity != null) {
                otherBlockEntity.getCapability(ForgeCapabilities.FLUID_HANDLER, opposite).ifPresent(handler -> handler.fill(data.Tank.getFluidInTank(0), IFluidHandler.FluidAction.EXECUTE));
            }
        }
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (this.m_58900_().m_61143_((Property)CoreStateProperties.StateDirection) == side) {
            return ForgeCapabilities.FLUID_HANDLER.orEmpty(cap, this.getData().OptionalTank);
        }
        return super.getCapability(cap, side);
    }

    public class NitrogenExtractorData
    implements IDataSync {
        private int _seed;
        public IFluidHandler Tank = new IFluidHandler(){

            public int getTanks() {
                return 1;
            }

            @NotNull
            public FluidStack getFluidInTank(int tank) {
                return new FluidStack((Fluid)MachinesContent.Nitrogen.Source.get(), 10);
            }

            public int getTankCapacity(int tank) {
                return 10;
            }

            public boolean isFluidValid(int tank, @NotNull FluidStack stack) {
                return false;
            }

            public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
                return 0;
            }

            @NotNull
            public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
                return FluidStack.EMPTY;
            }

            @NotNull
            public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
                return FluidStack.EMPTY;
            }
        };
        public LazyOptional<IFluidHandler> OptionalTank = LazyOptional.of(() -> this.Tank);

        public void onLoad(CoreBlockEntity coreBlockEntity) {
            this._seed = NitrogenExtractorBlockEntity.this.m_58899_().hashCode();
        }

        public void save(CoreBlockEntity coreBlockEntity, @NotNull CompoundTag tag) {
        }

        public void load(CoreBlockEntity coreBlockEntity, @NotNull CompoundTag tag) {
        }

        public void invalidate(CoreBlockEntity coreBlockEntity) {
            this.OptionalTank.invalidate();
        }

        public int getSeed() {
            return this._seed;
        }
    }
}

