/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.machines.content.blocks;

import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tv.soaryn.xycraft.core.content.blocks.CoreStateProperties;
import tv.soaryn.xycraft.core.content.blocks.entities.CoreBlockEntity;
import tv.soaryn.xycraft.core.content.blocks.entities.IDataSync;
import tv.soaryn.xycraft.core.content.blocks.entities.ITickable;
import tv.soaryn.xycraft.machines.config.MachinesConfig;
import tv.soaryn.xycraft.machines.content.MachinesContent;

public class HydroPumpBlockEntity
extends CoreBlockEntity
implements ITickable.Server {
    public HydroPumpBlockEntity(BlockPos pos, BlockState state) {
        super(MachinesContent.HydroPump.entity(), pos, state);
        this.Data = new HydroPumpData();
    }

    public static BlockEntityType<?> supplier(Block block) {
        return new BlockEntityType(HydroPumpBlockEntity::new, Set.of(block), CoreBlockEntity.DefaultFixer);
    }

    public HydroPumpData getData() {
        return (HydroPumpData)this.Data;
    }

    public void tickServer(@NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState state) {
        HydroPumpData data = this.getData();
        if (ITickable.shouldTick((Level)level, (int)data.getSeed(), (int)((Integer)MachinesConfig.HydroPumpProcessFrequency.get()))) {
            Direction direction = (Direction)state.m_61143_((Property)CoreStateProperties.StateDirection);
            Direction opposite = direction.m_122424_();
            BlockPos posOfOther = pos.m_121945_(direction);
            BlockEntity otherBlockEntity = level.m_7702_(posOfOther);
            if (otherBlockEntity != null) {
                otherBlockEntity.getCapability(ForgeCapabilities.FLUID_HANDLER, opposite).ifPresent(handler -> {
                    FluidStack fluid = data.FluidHandle.getFluidInTank(0);
                    fluid.setAmount(((Integer)MachinesConfig.HydroPumpFluidAmount.get()).intValue());
                    handler.fill(fluid, IFluidHandler.FluidAction.EXECUTE);
                });
            }
        }
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.FLUID_HANDLER && this.m_58900_().m_61143_((Property)CoreStateProperties.StateDirection) == side) {
            return this.getData().Capability.cast();
        }
        return super.getCapability(cap, side);
    }

    public static class HydroPumpData
    implements IDataSync {
        private int _seed;
        public IFluidHandler FluidHandle = new IFluidHandler(){

            public int getTanks() {
                return 1;
            }

            @NotNull
            public FluidStack getFluidInTank(int tank) {
                return new FluidStack((Fluid)Fluids.f_76193_, ((Integer)MachinesConfig.HydroPumpFluidExternalAmount.get()).intValue());
            }

            public int getTankCapacity(int tank) {
                return (Integer)MachinesConfig.HydroPumpFluidExternalAmount.get();
            }

            public boolean isFluidValid(int tank, @NotNull FluidStack stack) {
                return false;
            }

            public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
                return 0;
            }

            @NotNull
            public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
                Integer amount = (Integer)MachinesConfig.HydroPumpFluidExternalAmount.get();
                if (amount <= 0) {
                    return FluidStack.EMPTY;
                }
                FluidStack water = new FluidStack((Fluid)Fluids.f_76193_, Math.min(resource.getAmount(), amount));
                return resource.isFluidEqual(water) ? water : FluidStack.EMPTY;
            }

            @NotNull
            public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
                Integer amount = (Integer)MachinesConfig.HydroPumpFluidExternalAmount.get();
                if (amount <= 0) {
                    return FluidStack.EMPTY;
                }
                return new FluidStack((Fluid)Fluids.f_76193_, Math.min(maxDrain, amount));
            }
        };
        public LazyOptional<IFluidHandler> Capability = LazyOptional.of(() -> this.FluidHandle);

        public void onLoad(CoreBlockEntity coreBlockEntity) {
            this._seed = coreBlockEntity.m_58899_().hashCode();
        }

        public void save(CoreBlockEntity coreBlockEntity, @NotNull CompoundTag tag) {
        }

        public void load(CoreBlockEntity coreBlockEntity, @NotNull CompoundTag tag) {
        }

        public void invalidate(CoreBlockEntity coreBlockEntity) {
            this.Capability.invalidate();
        }

        public int getSeed() {
            return this._seed;
        }
    }
}

