/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.machines.compat.jei;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IModIngredientRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import mezz.jei.api.runtime.IJeiRuntime;
import net.minecraft.client.Minecraft;
import net.minecraft.core.IdMapper;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.GameData;
import org.jetbrains.annotations.NotNull;
import tv.soaryn.xycraft.core.ui.BaseMenuUI;
import tv.soaryn.xycraft.core.utils.StreamUtils;
import tv.soaryn.xycraft.core.utils.profiler.ProfileMarker;
import tv.soaryn.xycraft.core.utils.rules.FluidRuleGroup;
import tv.soaryn.xycraft.core.utils.rules.IRule;
import tv.soaryn.xycraft.machines.XyMachines;
import tv.soaryn.xycraft.machines.compat.jei.ExtractorCategory;
import tv.soaryn.xycraft.machines.compat.jei.FabricatorTransferHandler;
import tv.soaryn.xycraft.machines.compat.jei.GhostSlotHandler;
import tv.soaryn.xycraft.machines.content.MachineRecipes;
import tv.soaryn.xycraft.machines.content.MachinesContent;
import tv.soaryn.xycraft.machines.content.recipe.ExtractorRecipe;

@mezz.jei.api.JeiPlugin
public class JeiPlugin
implements IModPlugin {
    private static final ResourceLocation _id = new ResourceLocation("xycraft_machines", "jei");
    public static final ConcurrentHashMap<IRule, Set<BlockState>> RuleToBlockState = new ConcurrentHashMap();
    public static final ConcurrentHashMap<IRule, List<ItemStack>> RuleToItems = new ConcurrentHashMap();
    public static final ConcurrentHashMap<IRule, List<FluidStack>> RuleToFluids = new ConcurrentHashMap();
    private static final ProfileMarker MarkerRegister = new ProfileMarker("JEI Integration");
    private static final ProfileMarker MarkerRecipeManagerAccess = new ProfileMarker("RecipeManagerAccess");
    private static final ProfileMarker MarkerSortingRecipes = new ProfileMarker("SortRecipes");
    private static final ProfileMarker MarkerAccessBlockStateMap = new ProfileMarker("AccessBlockStates");
    private static final ProfileMarker MarkerMapRules = new ProfileMarker("MappingRules");
    private static final ProfileMarker MarkerRegisterRecipes = new ProfileMarker("RegisterJEIRecipe");

    public void onRuntimeAvailable(@NotNull IJeiRuntime jeiRuntime) {
        super.onRuntimeAvailable(jeiRuntime);
    }

    @NotNull
    public ResourceLocation getPluginUid() {
        return _id;
    }

    public void registerCategories(@NotNull IRecipeCategoryRegistration registration) {
        ExtractorCategory extractorCategory = new ExtractorCategory(registration.getJeiHelpers().getGuiHelper());
        registration.addRecipeCategories(new IRecipeCategory[]{extractorCategory});
    }

    public void registerIngredients(@NotNull IModIngredientRegistration registration) {
    }

    public void registerRecipeTransferHandlers(IRecipeTransferRegistration registration) {
        registration.addRecipeTransferHandler((IRecipeTransferHandler)new FabricatorTransferHandler(), RecipeTypes.CRAFTING);
    }

    public void registerRecipes(@NotNull IRecipeRegistration registration) {
        RuleToBlockState.clear();
        RuleToItems.clear();
        RuleToFluids.clear();
        super.registerRecipes(registration);
        assert (Minecraft.m_91087_().f_91073_ != null);
        MarkerRegister.begin();
        MarkerRecipeManagerAccess.begin();
        RecipeManager manager = Minecraft.m_91087_().f_91073_.m_7465_();
        ArrayList list = new ArrayList();
        list.addAll(manager.m_44013_((net.minecraft.world.item.crafting.RecipeType)MachineRecipes.ExtractorType.get()));
        list.addAll(manager.m_44013_((net.minecraft.world.item.crafting.RecipeType)MachineRecipes.ExtractorCatalystType.get()));
        MarkerRecipeManagerAccess.end();
        MarkerSortingRecipes.begin();
        List<ExtractorRecipe> itemList = list.stream().filter(r -> !r.getResultItemView().m_41619_() && !r.isHidden()).sorted(JeiPlugin::compareItemResults).toList();
        List<ExtractorRecipe> fluidList = list.stream().filter(r -> !r.getResultFluidView().isEmpty() && !r.isHidden()).sorted(JeiPlugin::compareFluidResults).toList();
        MarkerSortingRecipes.end();
        MarkerAccessBlockStateMap.begin();
        IdMapper idMap = GameData.getBlockStateIDMap();
        ArrayList blockStates = new ArrayList();
        idMap.forEach(blockStates::add);
        MarkerAccessBlockStateMap.end();
        MarkerMapRules.begin();
        StreamUtils.execute(() -> list.parallelStream().flatMap(recipe -> recipe.getAllRules().stream()).distinct().forEach(unique -> {
            Set matchedStates = blockStates.parallelStream().filter(arg_0 -> ((IRule)unique).matches(arg_0)).collect(Collectors.toSet());
            RuleToBlockState.put((IRule)unique, matchedStates);
            if (unique instanceof FluidRuleGroup) {
                RuleToFluids.put((IRule)unique, matchedStates.stream().map(state -> new FluidStack(state.m_60819_().m_76152_(), 1000)).distinct().toList());
            } else {
                RuleToItems.put((IRule)unique, matchedStates.stream().map(state -> new ItemStack((ItemLike)state.m_60734_())).toList());
            }
        }));
        MarkerMapRules.end();
        int ruleCount = RuleToBlockState.size();
        int blockStateCount = blockStates.size();
        MarkerRegisterRecipes.begin();
        registration.addRecipes(ExtractorCategory.Type, itemList);
        registration.addRecipes(ExtractorCategory.Type, fluidList);
        MarkerRegisterRecipes.end();
        blockStates.clear();
        MarkerRegister.end();
        XyMachines.Logger.debug("------------------------------------------------------------------------");
        XyMachines.Logger.debug("----- JEI Integration Breakdown:");
        XyMachines.Logger.debug("----- BlockState Count: " + blockStateCount);
        XyMachines.Logger.debug("----- Rule Count: " + ruleCount);
        XyMachines.Logger.debug("----- " + MarkerRegister);
        XyMachines.Logger.debug("----- " + MarkerRecipeManagerAccess);
        XyMachines.Logger.debug("----- " + MarkerAccessBlockStateMap);
        XyMachines.Logger.debug("----- " + MarkerSortingRecipes);
        XyMachines.Logger.debug("----- " + MarkerMapRules);
        XyMachines.Logger.debug("----- " + MarkerRegisterRecipes);
        XyMachines.Logger.debug("------------------------------------------------------------------------");
    }

    private static int compareItemResults(ExtractorRecipe o1, ExtractorRecipe o2) {
        ItemStack result1 = o1.getResultItemView();
        ItemStack result2 = o2.getResultItemView();
        if (result1.m_41619_() || result2.m_41619_() || result1.equals(result2, true)) {
            return 0;
        }
        return result1.m_41720_().toString().compareToIgnoreCase(result2.m_41720_().toString());
    }

    private static int compareFluidResults(ExtractorRecipe o1, ExtractorRecipe o2) {
        FluidStack result1 = o1.getResultFluidView();
        FluidStack result2 = o2.getResultFluidView();
        if (result1.isEmpty() || result2.isEmpty() || result1.isFluidEqual(result2)) {
            return 0;
        }
        return result1.getFluid().hashCode() > result2.getFluid().hashCode() ? 1 : -1;
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        registration.addGhostIngredientHandler(BaseMenuUI.class, new GhostSlotHandler());
    }

    public void registerRecipeCatalysts(@NotNull IRecipeCatalystRegistration registration) {
        super.registerRecipeCatalysts(registration);
        registration.addRecipeCatalyst(new ItemStack((ItemLike)MachinesContent.Extractor.block()), new RecipeType[]{ExtractorCategory.Type});
    }
}

