/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.machines.client.render.blocks;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.RenderTypeHelper;
import net.minecraftforge.client.model.data.ModelData;
import org.jetbrains.annotations.NotNull;
import org.joml.Math;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import tv.soaryn.xycraft.core.content.capabilities.level.AccurateTime;
import tv.soaryn.xycraft.core.content.capabilities.player.ColorCapability;
import tv.soaryn.xycraft.core.utils.ColorUtils;
import tv.soaryn.xycraft.machines.client.render.MachinesModelBakery;
import tv.soaryn.xycraft.machines.content.blocks.BalloonStakeBlock;
import tv.soaryn.xycraft.machines.content.blocks.properties.MachineStateProperties;

public class BalloonStakeRender
implements BlockEntityRenderer<BalloonStakeBlock.Entity> {
    private final BlockRenderDispatcher _renderDispatcherCache;

    public BalloonStakeRender(BlockEntityRendererProvider.Context context) {
        this._renderDispatcherCache = context.m_173584_();
    }

    public boolean shouldRenderOffScreen( @NotNull BalloonStakeBlock.Entity entity) {
        return true;
    }

    public void render(@NotNull BalloonStakeBlock.Entity entity, float partialTick, @NotNull PoseStack poseStack, @NotNull MultiBufferSource bufferSource, int light, int overlay) {
        BlockState state = entity.m_58900_();
        Vec3 stakePos = Vec3.m_82512_((Vec3i)entity.m_58899_());
        Boolean bound = (Boolean)entity.m_58900_().m_61143_((Property)MachineStateProperties.Connected);
        Level level = entity.m_58904_();
        if (!bound.booleanValue() || level == null) {
            return;
        }
        Player player = entity.getData().getPlayer(level);
        if (player == null) {
            return;
        }
        Vec3 playerPos = BalloonStakeRender.getPlayerBodyCenterPos(partialTick, player);
        Vec3 ropeOffset = new Vec3(0.0, 0.0, 0.5);
        double theta = (double)(Mth.m_14179_((float)partialTick, (float)player.f_20884_, (float)player.f_20883_) * ((float)java.lang.Math.PI / 180)) + 1.5707963267948966;
        double cos = Math.cos((double)theta);
        double sin = Math.sin((double)theta);
        double d1 = cos * ropeOffset.f_82481_ + sin * ropeOffset.f_82479_;
        double d2 = sin * ropeOffset.f_82481_ - cos * ropeOffset.f_82479_;
        this.renderLeash(player, partialTick, poseStack, bufferSource, stakePos, light);
        this.renderLeash(player, partialTick, poseStack, bufferSource, stakePos, light);
        poseStack.m_85836_();
        Vec3 dif = playerPos.m_82546_(stakePos).m_82492_(d1, -1.5, d2);
        poseStack.m_85837_(dif.m_7096_(), dif.m_7098_(), dif.m_7094_());
        poseStack.m_252880_(0.0f, Mth.m_14031_((float)(((float)AccurateTime.of((Level)level) + partialTick) * 0.05f)) * 0.05f, 0.0f);
        poseStack.m_85836_();
        VertexConsumer vertexconsumer = bufferSource.m_6299_(RenderType.m_110475_());
        Matrix4f matrix4f = poseStack.m_85850_().m_252922_();
        float z = 0.3f;
        float x = 0.0f;
        dif = new Vec3(cos * (double)z + sin * (double)x, -1.5, sin * (double)z - cos * (double)x);
        float iSquare = (float)(Math.invsqrt((double)(dif.m_7096_() * dif.m_7096_() + dif.m_7094_() * dif.m_7094_())) * (double)0.025f / 2.0);
        float inverseZ = (float)(dif.m_7094_() * (double)iSquare);
        float inverseX = (float)(dif.m_7096_() * (double)iSquare);
        poseStack.m_85837_(0.5, 0.5, 0.5);
        float ropeScale = 0.025f;
        for (int i1 = 0; i1 <= 24; ++i1) {
            BalloonStakeRender.addVertexPair(vertexconsumer, matrix4f, (float)dif.m_7096_(), (float)dif.m_7098_(), (float)dif.m_7094_(), 9, 9, 9, 9, ropeScale, ropeScale, inverseZ, inverseX, i1, false);
        }
        for (int j1 = 24; j1 >= 0; --j1) {
            BalloonStakeRender.addVertexPair(vertexconsumer, matrix4f, (float)dif.m_7096_(), (float)dif.m_7098_(), (float)dif.m_7094_(), 9, 9, 9, 9, ropeScale, 0.0f, inverseZ, inverseX, j1, true);
        }
        poseStack.m_85837_(-0.5, -0.5, -0.5);
        float scale = 0.8f;
        poseStack.m_85841_(scale, scale, scale);
        poseStack.m_252880_(1.0f - scale, 1.0f - scale, 1.0f - scale);
        for (RenderType rt : MachinesModelBakery.Balloon.getRenderTypes(state, RandomSource.m_216335_((long)42L), ModelData.EMPTY)) {
            VertexConsumer bufferSrc = bufferSource.m_6299_(RenderTypeHelper.getEntityRenderType((RenderType)rt, (boolean)false));
            Vector3f color = ColorUtils.convertRGBToComponents((int)ColorCapability.colorOf((Player)player));
            this._renderDispatcherCache.m_110937_().renderModel(poseStack.m_85850_(), bufferSrc, state, MachinesModelBakery.Balloon, color.x(), color.y(), color.z(), light, overlay, ModelData.EMPTY, rt);
        }
        poseStack.m_85849_();
        poseStack.m_85849_();
    }

    private <E extends Entity> void renderLeash(Player targetPlayer, float partialTick, PoseStack poseStack, MultiBufferSource source, Vec3 stakePosition, int light) {
        poseStack.m_85836_();
        poseStack.m_252880_(0.5f, 0.0f, 0.5f);
        Vec3 playerPos = BalloonStakeRender.getPlayerBodyCenterPos(partialTick, targetPlayer);
        double d0 = (double)(Mth.m_14179_((float)partialTick, (float)targetPlayer.f_20884_, (float)targetPlayer.f_20883_) * ((float)java.lang.Math.PI / 180)) + 1.5707963267948966;
        Vec3 ropeOffset = new Vec3(0.0, (double)targetPlayer.m_20192_() * (double)0.4f, (double)(targetPlayer.m_20205_() * -0.2f));
        double d1 = Math.cos((double)d0) * ropeOffset.f_82481_ + Math.sin((double)d0) * ropeOffset.f_82479_;
        double d2 = Math.sin((double)d0) * ropeOffset.f_82481_ - Math.cos((double)d0) * ropeOffset.f_82479_;
        double d3 = Mth.m_14139_((double)partialTick, (double)targetPlayer.f_19854_, (double)targetPlayer.m_20185_()) + d1;
        double d4 = Mth.m_14139_((double)partialTick, (double)targetPlayer.f_19855_, (double)targetPlayer.m_20186_()) + ropeOffset.f_82480_;
        double d5 = Mth.m_14139_((double)partialTick, (double)targetPlayer.f_19856_, (double)targetPlayer.m_20189_()) + d2;
        poseStack.m_85837_(d1, ropeOffset.f_82480_, d2);
        float f = (float)(stakePosition.f_82479_ - d3);
        float f1 = (float)(stakePosition.f_82480_ - d4);
        float f2 = (float)(stakePosition.f_82481_ - d5);
        Vec3 dif = new Vec3((double)f, (double)f1, (double)f2);
        dif = playerPos.m_82546_(stakePosition);
        float iSquare = (float)(Mth.m_14193_((double)(dif.m_7096_() * dif.m_7096_() + dif.m_7094_() * dif.m_7094_())) * (double)0.025f / 2.0);
        float inverseZ = (float)(dif.m_7094_() * (double)iSquare);
        float inverseX = (float)(dif.m_7096_() * (double)iSquare);
        float scale = 0.025f;
        VertexConsumer vertexconsumer = source.m_6299_(RenderType.m_110475_());
        Matrix4f matrix4f = poseStack.m_85850_().m_252922_();
        for (int i1 = 0; i1 <= 24; ++i1) {
            BalloonStakeRender.addVertexPair(vertexconsumer, matrix4f, (float)dif.m_7096_(), (float)dif.m_7098_(), (float)dif.m_7094_(), 9, 9, 9, 9, scale, scale, inverseZ, inverseX, i1, false);
        }
        for (int j1 = 24; j1 >= 0; --j1) {
            BalloonStakeRender.addVertexPair(vertexconsumer, matrix4f, (float)dif.m_7096_(), (float)dif.m_7098_(), (float)dif.m_7094_(), 9, 9, 9, 9, scale, 0.0f, inverseZ, inverseX, j1, true);
        }
        poseStack.m_85849_();
    }

    private static void addVertexPair(VertexConsumer vertexConsumer, Matrix4f matrix, float x, float y, float z, int lightA, int skyA, int blockA, int blockB, float p_174317_, float p_174318_, float p_174319_, float p_174320_, int p_174321_, boolean p_174322_) {
        float f = (float)p_174321_ / 24.0f;
        int i = (int)Mth.m_14179_((float)f, (float)lightA, (float)skyA);
        int j = (int)Mth.m_14179_((float)f, (float)blockA, (float)blockB);
        int k = LightTexture.m_109885_((int)i, (int)j);
        float f1 = p_174321_ % 2 == (p_174322_ ? 1 : 0) ? 0.7f : 1.0f;
        float f2 = 0.5f * f1;
        float f3 = 0.4f * f1;
        float f4 = 0.3f * f1;
        float f5 = x * f;
        float f6 = y > 0.0f ? y * f * f : y - y * (1.0f - f) * (1.0f - f);
        float f7 = z * f;
        vertexConsumer.m_252986_(matrix, f5 - p_174319_, f6 + p_174318_, f7 + p_174320_).m_85950_(f2, f3, f4, 1.0f).m_85969_(k).m_5752_();
        vertexConsumer.m_252986_(matrix, f5 + p_174319_, f6 + p_174317_ - p_174318_, f7 - p_174320_).m_85950_(f2, f3, f4, 1.0f).m_85969_(k).m_5752_();
    }

    @NotNull
    private static Vec3 getPlayerBodyCenterPos(float partialTick, Player player) {
        float rotX = Mth.m_14179_((float)(partialTick * 0.5f), (float)player.m_146909_(), (float)player.f_19860_) * ((float)java.lang.Math.PI / 180);
        float rotY = Mth.m_14179_((float)partialTick, (float)player.f_20884_, (float)player.f_20883_) * ((float)java.lang.Math.PI / 180);
        if (!player.m_21255_() && !player.m_21209_()) {
            if (player.m_6067_()) {
                return player.m_20318_(partialTick).m_82549_(new Vec3(0.0, 0.2, -0.15).m_82496_(-rotX).m_82524_(-rotY));
            }
            double d5 = player.m_20191_().m_82376_() - 0.75;
            double d6 = player.m_6047_() ? -0.2 : 0.07;
            return player.m_20318_(partialTick).m_82549_(new Vec3(0.0, d5, d6).m_82524_(-rotY));
        }
        Vec3 view = player.m_20252_(partialTick);
        Vec3 moveDelta = player.m_20184_();
        double deltaDistX = moveDelta.m_165925_();
        double viewDistX = view.m_165925_();
        double d3 = (moveDelta.f_82479_ * view.f_82479_ + moveDelta.f_82481_ * view.f_82481_) / Math.sqrt((double)(deltaDistX * viewDistX));
        double d4 = moveDelta.f_82479_ * view.f_82481_ - moveDelta.f_82481_ * view.f_82479_;
        float zRot = deltaDistX > 0.0 && viewDistX > 0.0 ? (float)(Math.signum((double)d4) * Math.acos((double)d3)) : 0.0f;
        return player.m_20318_(partialTick).m_82549_(new Vec3(0.0, -0.11, 0.85).m_82535_(-zRot).m_82496_(-rotX).m_82524_(-rotY));
    }
}

