/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.machines.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.client.event.RenderHighlightEvent;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.common.Tags;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector4f;
import tv.soaryn.xycraft.core.client.render.FluidRenderer;
import tv.soaryn.xycraft.core.content.capabilities.player.ModifierKeyCapability;
import tv.soaryn.xycraft.core.utils.ColorUtils;
import tv.soaryn.xycraft.machines.client.content.multiblock.ClientTankEventHandler;
import tv.soaryn.xycraft.machines.client.content.multiblock.ClientTankMultiBlock;

public class TankMultiBlockRenderer {
    public static void onRenderLevel(RenderLevelStageEvent event) {
        double viewDistance;
        if (event.getStage() != RenderLevelStageEvent.Stage.AFTER_BLOCK_ENTITIES) {
            return;
        }
        double chunkDist = event.getLevelRenderer().m_173017_();
        double bound = viewDistance = chunkDist * 16.0 + 36.0;
        bound *= bound;
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level == null) {
            return;
        }
        level.m_46473_().m_6180_("xycraft_machines:tank_fluid_render");
        MultiBufferSource.BufferSource renderBuffers = Minecraft.m_91087_().m_91269_().m_110104_();
        Vec3 cameraPos = event.getCamera().m_90583_();
        PoseStack poseStack = event.getPoseStack();
        for (ClientTankMultiBlock tank : ClientTankEventHandler.getAllTanks()) {
            TankMultiBlockRenderer.renderFluid(event, level, chunkDist, viewDistance, bound, renderBuffers, cameraPos, poseStack, tank);
        }
        renderBuffers.m_109911_();
        level.m_46473_().m_7238_();
    }

    private static void renderFluid(RenderLevelStageEvent event, @NotNull ClientLevel level, double chunkDist, double viewDistance, double bound, MultiBufferSource.BufferSource renderBuffers, Vec3 cameraPos, PoseStack poseStack, ClientTankMultiBlock tank) {
        double fluidAmount = tank.getFluidAmount(event.getPartialTick());
        if (fluidAmount == 0.0) {
            return;
        }
        BlockPos min = tank.getInnerMin();
        BlockPos size = tank.getInnerMax().m_121996_((Vec3i)min).m_7918_(1, 1, 1);
        Vec3i halfSize = new Vec3i(size.m_123341_() / 2, size.m_123342_() / 2, size.m_123343_() / 2);
        int light = LevelRenderer.m_109541_((BlockAndTintGetter)level, (BlockPos)min.m_121955_(halfSize));
        double dist = cameraPos.m_82557_(min.m_121955_(halfSize).m_252807_());
        if (dist > bound) {
            return;
        }
        poseStack.m_85836_();
        poseStack.m_85837_((double)min.m_123341_() - cameraPos.m_7096_(), (double)min.m_123342_() - cameraPos.m_7098_(), (double)min.m_123343_() - cameraPos.m_7094_());
        float floatOffset = (float)dist / 100000.0f;
        double alpha = Math.max(0.0, (viewDistance -= 12.0 + chunkDist) * viewDistance / 5.0 / dist);
        alpha = Math.min(alpha, 1.0);
        FluidStack fluid = tank.getFluidType();
        IClientFluidTypeExtensions clientFluid = IClientFluidTypeExtensions.of((Fluid)fluid.getFluid());
        Vector4f color = ColorUtils.convertRGBAToComponents((int)clientFluid.getTintColor(fluid.getFluid().m_76145_(), (BlockAndTintGetter)level, new BlockPos((Vec3i)min.m_121955_(halfSize))));
        if (fluid.getFluid().m_205067_(Tags.Fluids.GASEOUS)) {
            color.w = (float)fluidAmount;
            FluidRenderer.renderFluidBox((FluidStack)fluid, (float)floatOffset, (float)floatOffset, (float)floatOffset, (float)((float)size.m_123341_() - floatOffset), (float)((float)size.m_123342_() - floatOffset), (float)((float)size.m_123343_() - floatOffset), (MultiBufferSource)renderBuffers, (PoseStack)poseStack, (int)ColorUtils.convertComponentsToARGB((Vector4f)color), (int)light, (boolean)true);
        } else {
            color.w = (float)alpha;
            FluidRenderer.renderFluidBox((FluidStack)fluid, (float)floatOffset, (float)floatOffset, (float)floatOffset, (float)((float)size.m_123341_() - floatOffset), (float)((float)Math.max((double)size.m_123342_() * fluidAmount, (double)floatOffset)), (float)((float)size.m_123343_() - floatOffset), (MultiBufferSource)renderBuffers, (PoseStack)poseStack, (int)ColorUtils.convertComponentsToARGB((Vector4f)color), (int)light, (boolean)true);
        }
        poseStack.m_85849_();
    }

    public static void onDrawHighlight(RenderHighlightEvent.Block event) {
        Minecraft minecraft = Minecraft.m_91087_();
        if (minecraft.f_91074_ != null && minecraft.f_91074_.m_36341_() || KeyConflictContext.IN_GAME.isActive() && ModifierKeyCapability.of((Player)minecraft.f_91074_)) {
            return;
        }
        ClientTankMultiBlock multiBlock = ClientTankEventHandler.getLookedAt((Level)minecraft.f_91073_, event.getTarget().m_82425_());
        if (multiBlock == null) {
            return;
        }
        Vec3 cameraPos = event.getCamera().m_90583_();
        LevelRenderer.m_285900_((PoseStack)event.getPoseStack(), (VertexConsumer)event.getMultiBufferSource().m_6299_(RenderType.m_110504_()), (VoxelShape)multiBlock.getShape(), (double)(-cameraPos.m_7096_()), (double)(-cameraPos.m_7098_()), (double)(-cameraPos.m_7094_()), (float)1.0f, (float)1.0f, (float)1.0f, (float)0.6f, (boolean)true);
        event.setCanceled(true);
    }
}

