/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.machines.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraftforge.client.model.geometry.IGeometryBakingContext;
import net.minecraftforge.client.model.geometry.StandaloneGeometryBakingContext;
import net.minecraftforge.client.model.obj.ObjLoader;
import net.minecraftforge.client.model.obj.ObjModel;
import net.minecraftforge.client.model.renderable.CompositeRenderable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Vector4f;
import tv.soaryn.xycraft.core.utils.ColorUtils;

public class ModelHandle {
    private final CompositeRenderable renderable;

    public static ModelHandle of(String modelLocation) {
        return new ModelHandle(new ResourceLocation(modelLocation));
    }

    public static ModelHandle of(String modId, String location) {
        return new ModelHandle(new ResourceLocation(modId, location));
    }

    public static ModelHandle of(ResourceLocation location) {
        return new ModelHandle(location);
    }

    public static ModelHandle of(ResourceLocation location, boolean automaticCulling, boolean shadeQuads, boolean flipV, boolean emissiveAmbient, @Nullable String mtlOverride) {
        return new ModelHandle(new ObjModel.ModelSettings(location, automaticCulling, shadeQuads, flipV, emissiveAmbient, mtlOverride));
    }

    public ModelHandle(ObjModel.ModelSettings modelSettings) {
        ObjModel model = ObjLoader.INSTANCE.loadModel(modelSettings);
        this.renderable = model.bakeRenderable((IGeometryBakingContext)StandaloneGeometryBakingContext.create((ResourceLocation)modelSettings.modelLocation()));
    }

    public ModelHandle(ResourceLocation modelLocation) {
        ObjModel model = ObjLoader.INSTANCE.loadModel(new ObjModel.ModelSettings(modelLocation, false, true, true, true, null));
        this.renderable = model.bakeRenderable((IGeometryBakingContext)StandaloneGeometryBakingContext.create((ResourceLocation)modelLocation));
    }

    public void render(PoseStack poseStack, MultiBufferSource bufferIn, RenderType rt, int packedLightIn, int color) {
        Vector4f components = ColorUtils.convertRGBAToComponents((int)color);
        bufferIn = new ColoringBufferSource(components.x(), components.y(), components.z(), components.w(), bufferIn);
        this.renderable.render(poseStack, bufferIn, t -> rt, packedLightIn, OverlayTexture.f_118083_, 0.0f, CompositeRenderable.Transforms.EMPTY);
    }

    public static class ColoringBufferSource
    implements MultiBufferSource {
        public final float _r;
        public final float _g;
        public final float _b;
        public final float _a;
        private final MultiBufferSource inner;
        private final TextureAtlasSprite _sprite;

        public ColoringBufferSource(float r, float g, float b, float a, MultiBufferSource inner) {
            this._r = r;
            this._g = g;
            this._b = b;
            this._a = a;
            this.inner = inner;
            TextureAtlas atlas = (TextureAtlas)Minecraft.m_91087_().m_91097_().m_118506_(InventoryMenu.f_39692_);
            this._sprite = atlas.m_118316_(new ResourceLocation("xycraft_core", "block/cloudfx"));
        }

        @NotNull
        public VertexConsumer m_6299_(@NotNull RenderType rt) {
            return new ConsumerWrapper(this.inner.m_6299_(rt));
        }

        private class ConsumerWrapper
        implements VertexConsumer {
            private final VertexConsumer buffer;

            public ConsumerWrapper(VertexConsumer buffer) {
                this.buffer = buffer;
            }

            @NotNull
            public VertexConsumer m_252986_(@NotNull Matrix4f matrix, float x, float y, float z) {
                return this.buffer.m_252986_(matrix, x, y, z);
            }

            @NotNull
            public VertexConsumer m_5483_(double x, double y, double z) {
                return this.buffer.m_5483_(x, y, z);
            }

            @NotNull
            public VertexConsumer m_6122_(int r, int g, int b, int a) {
                return this.buffer.m_6122_((int)((float)r * ColoringBufferSource.this._r), (int)((float)g * ColoringBufferSource.this._g), (int)((float)b * ColoringBufferSource.this._b), (int)((float)a * ColoringBufferSource.this._a));
            }

            @NotNull
            public VertexConsumer m_85950_(float r, float g, float b, float a) {
                return this.buffer.m_85950_(r * ColoringBufferSource.this._r, g * ColoringBufferSource.this._g, b * ColoringBufferSource.this._b, a * ColoringBufferSource.this._a);
            }

            @NotNull
            public VertexConsumer m_7421_(float u, float v) {
                return this.buffer.m_7421_(u, v);
            }

            @NotNull
            public VertexConsumer m_7122_(int u, int v) {
                return this.buffer.m_7122_(u, v);
            }

            @NotNull
            public VertexConsumer m_7120_(int u, int v) {
                return this.buffer.m_7120_(u, v);
            }

            @NotNull
            public VertexConsumer m_5601_(float x, float y, float z) {
                return this.buffer.m_5601_(x, y, z);
            }

            @NotNull
            public VertexConsumer m_252939_(@NotNull Matrix3f matrix, float x, float y, float z) {
                return this.buffer.m_252939_(matrix, x, y, z);
            }

            public void m_5752_() {
                this.buffer.m_5752_();
            }

            public void m_7404_(int r, int g, int b, int a) {
                this.buffer.m_7404_(r, g, b, a);
            }

            public void m_141991_() {
                this.buffer.m_141991_();
            }
        }
    }
}

