/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.machines.client.items;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.SheetedDecalTextureGenerator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.ArrayList;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.MultiPlayerGameMode;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderHighlightEvent;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.joml.Math;
import org.joml.Vector4f;
import tv.soaryn.xycraft.core.utils.Utils;
import tv.soaryn.xycraft.machines.content.items.modular.GauntletItem;
import tv.soaryn.xycraft.machines.utils.EnergyUtils;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="xycraft_machines")
public class GauntletClient {
    @SubscribeEvent(priority=EventPriority.LOW)
    public static void renderBlockHighlights(RenderHighlightEvent.Block event) {
        if (event.isCanceled()) {
            return;
        }
        Player player = Utils.getClientPlayer();
        Level level = Utils.getClientLevel();
        if (player == null) {
            return;
        }
        ItemStack stack = player.m_21205_();
        Item item = stack.m_41720_();
        if (!(item instanceof GauntletItem)) {
            return;
        }
        GauntletItem gauntlet = (GauntletItem)item;
        Camera camera = event.getCamera();
        Vec3 cameraPos = camera.m_90583_();
        BlockPos origin = event.getTarget().m_82425_();
        Direction dir = GauntletItem.GauntletEvents.getTargetLookDirection(player);
        ArrayList<BlockPos> blockPositions = gauntlet.getAffectedBlocks(stack, (LevelReader)level, origin, dir);
        int radius = gauntlet.getRadius(stack);
        if (blockPositions.size() == 0) {
            return;
        }
        if (!EnergyUtils.playerHasEnergyToExtract(player, (blockPositions.size() + 1) * gauntlet.energyRequired(player, stack, true), true)) {
            return;
        }
        PoseStack poseStack = event.getPoseStack();
        VertexConsumer lines = event.getMultiBufferSource().m_6299_(RenderType.m_110504_());
        for (BlockPos blockPosition : blockPositions) {
            BlockState state = level.m_8055_(blockPosition);
            VoxelShape voxelShape = state.m_60808_((BlockGetter)level, blockPosition).m_83216_((double)blockPosition.m_123341_(), (double)blockPosition.m_123342_(), (double)blockPosition.m_123343_());
            Vector4f color = new Vector4f(0.0f, 0.0f, 0.0f, 0.2f);
            LevelRenderer.m_285900_((PoseStack)poseStack, (VertexConsumer)lines, (VoxelShape)voxelShape, (double)(-cameraPos.m_7096_()), (double)(-cameraPos.m_7098_()), (double)(-cameraPos.m_7094_()), (float)color.x(), (float)color.y(), (float)color.z(), (float)color.w(), (boolean)false);
        }
        MultiPlayerGameMode gameMode = Minecraft.m_91087_().f_91072_;
        if (gameMode == null || !gameMode.m_105296_()) {
            return;
        }
        int progress = gameMode.m_287167_() - 1;
        if (progress < 0 || progress > 10) {
            return;
        }
        progress = Math.min((int)(progress + 1), (int)9);
        MultiBufferSource.BufferSource renderBuffers = Minecraft.m_91087_().m_91269_().m_110104_();
        BlockRenderDispatcher dispatcher = Minecraft.m_91087_().m_91289_();
        VertexConsumer vertexBuilder = renderBuffers.m_6299_((RenderType)ModelBakery.f_119229_.get(progress));
        double cameraX = camera.m_90583_().m_7096_();
        double cameraY = camera.m_90583_().f_82480_;
        double cameraZ = camera.m_90583_().f_82481_;
        for (BlockPos blockPos : blockPositions) {
            poseStack.m_85836_();
            poseStack.m_85837_((double)blockPos.m_123341_() - cameraX, (double)blockPos.m_123342_() - cameraY, (double)blockPos.m_123343_() - cameraZ);
            PoseStack.Pose matrixEntry = poseStack.m_85850_();
            SheetedDecalTextureGenerator matrixBuilder = new SheetedDecalTextureGenerator(vertexBuilder, matrixEntry.m_252922_(), matrixEntry.m_252943_(), 1.0f);
            dispatcher.renderBreakingTexture(level.m_8055_(blockPos), blockPos, (BlockAndTintGetter)level, poseStack, (VertexConsumer)matrixBuilder, ModelData.EMPTY);
            poseStack.m_85849_();
        }
    }
}

