/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.machines.client.content.multiblock;

import java.util.Arrays;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.fluids.FluidStack;
import tv.soaryn.xycraft.machines.config.MachinesConfig;

public class ClientTankMultiBlock {
    private final BlockPos origin;
    private final BlockPos innerMin;
    private final BlockPos innerMax;
    private final int capacity;
    private final VoxelShape shape;
    private final int[] fluidAmountWindow = new int[30];
    private int lastWindowPointer;
    private int windowPointer;
    private FluidStack fluidType = FluidStack.EMPTY;

    public ClientTankMultiBlock(BlockPos min, BlockPos max, FluidStack fluid) {
        this.origin = min;
        this.innerMin = min.m_7918_(1, 1, 1);
        this.innerMax = max.m_7918_(-1, -1, -1);
        BlockPos innerVolume = this.innerMax.m_121996_((Vec3i)this.innerMin).m_7918_(1, 1, 1);
        this.capacity = innerVolume.m_123341_() * innerVolume.m_123342_() * innerVolume.m_123343_() * (Integer)MachinesConfig.TankStoragePerBlock.get();
        this.shape = Shapes.m_83064_((AABB)new AABB(min, max.m_7918_(1, 1, 1)));
        this.setFluid(fluid);
    }

    public void tick() {
        this.lastWindowPointer = this.windowPointer;
        this.windowPointer = (this.windowPointer + 1) % this.fluidAmountWindow.length;
        this.fluidAmountWindow[this.windowPointer] = this.fluidAmountWindow[this.lastWindowPointer];
    }

    public VoxelShape getShape() {
        return this.shape;
    }

    public BlockPos getOrigin() {
        return this.origin;
    }

    public BlockPos getInnerMin() {
        return this.innerMin;
    }

    public BlockPos getInnerMax() {
        return this.innerMax;
    }

    public FluidStack getFluidType() {
        return this.fluidType;
    }

    public double getFluidAmount(float partialTick) {
        double amount = 0.0;
        for (int i = 0; i < this.fluidAmountWindow.length - 2; ++i) {
            int idx = (this.windowPointer + i + 2) % this.fluidAmountWindow.length;
            amount += (double)this.fluidAmountWindow[idx];
        }
        amount += (double)((float)this.fluidAmountWindow[this.windowPointer] * partialTick);
        return (amount += (double)((float)this.fluidAmountWindow[(this.windowPointer + 1) % this.fluidAmountWindow.length] * (1.0f - partialTick))) / (double)(this.fluidAmountWindow.length - 1) / (double)this.getCapacity();
    }

    public void setFluid(FluidStack stack) {
        if (!stack.isEmpty() && !this.fluidType.isFluidEqual(stack)) {
            this.fluidType = stack;
            if (this.fluidAmountWindow[this.lastWindowPointer] != 0 && !this.fluidType.isEmpty()) {
                Arrays.fill(this.fluidAmountWindow, 0);
            }
        }
        this.fluidAmountWindow[this.windowPointer] = stack.getAmount();
    }

    public void setFluidAmount(int amount) {
        this.fluidAmountWindow[this.windowPointer] = amount;
    }

    public int getCapacity() {
        return this.capacity;
    }
}

