/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.machines.client.content.multiblock;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.AutoRegisterCapability;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tv.soaryn.xycraft.core.utils.FastVolumeLookup;
import tv.soaryn.xycraft.core.utils.Utils;
import tv.soaryn.xycraft.machines.client.content.multiblock.ClientTankMultiBlock;

@AutoRegisterCapability
public class ClientTankCache {
    private static final Capability<ClientTankCache> CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<ClientTankCache>(){});
    private final Long2ObjectMap<ClientTankMultiBlock> tanks = new Long2ObjectOpenHashMap();

    public static ClientTankCache of(Level level) {
        return (ClientTankCache)level.getCapability(CAPABILITY).orElseThrow(IllegalStateException::new);
    }

    public Iterable<ClientTankMultiBlock> list() {
        return this.tanks.values();
    }

    @Nullable
    public ClientTankMultiBlock get(BlockPos pos) {
        return (ClientTankMultiBlock)this.tanks.get(pos.m_121878_());
    }

    public void load(CompoundTag tag) {
        if (!tag.m_128441_("min")) {
            return;
        }
        this.add(BlockPos.m_122022_((long)tag.m_128454_("min")), BlockPos.m_122022_((long)tag.m_128454_("max")), tag.m_128441_("fluid") ? FluidStack.loadFluidStackFromNBT((CompoundTag)tag.m_128469_("fluid")) : FluidStack.EMPTY);
    }

    public void add(BlockPos min, BlockPos max, FluidStack fluid) {
        ClientTankMultiBlock tank = new ClientTankMultiBlock(min, max, fluid);
        if (this.tanks.containsKey(min.m_121878_())) {
            return;
        }
        this.tanks.put(min.m_121878_(), (Object)tank);
        FastVolumeLookup.of((Level)Utils.getClientLevel(), ClientTankMultiBlock.class).add((Object)tank, min, max);
    }

    public void remove(BlockPos pos) {
        ClientTankMultiBlock tank = (ClientTankMultiBlock)this.tanks.remove(pos.m_121878_());
        if (tank != null) {
            FastVolumeLookup.of((Level)Utils.getClientLevel(), ClientTankMultiBlock.class).remove((Object)tank);
        }
    }

    public static void init() {
        ResourceLocation resourceLocation = new ResourceLocation("xycraft_machines", "client_tank_cache");
        MinecraftForge.EVENT_BUS.addGenericListener(Level.class, event -> {
            final LazyOptional lazyOptional = LazyOptional.of(ClientTankCache::new);
            event.addCapability(resourceLocation, new ICapabilityProvider(){

                @NotNull
                public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
                    return CAPABILITY.orEmpty(cap, lazyOptional);
                }
            });
        });
    }
}

