/*
 * Decompiled with CFR 0.152.
 */
package net.permutated.exmachinis.util;

import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;

public class OverlayItemHandler
implements IItemHandler,
IItemHandlerModifiable {
    private final int slots;
    private final ItemStackHandler base;
    private final ItemStackHandler overlay;

    public OverlayItemHandler(ItemStackHandler base, ItemStackHandler overlay) {
        this.base = base;
        this.overlay = overlay;
        this.slots = base.getSlots() + overlay.getSlots();
    }

    public IItemHandler getBase() {
        return this.base;
    }

    public int getSlots() {
        return this.slots;
    }

    @NotNull
    public ItemStack getStackInSlot(int slot) {
        if (slot < this.overlay.getSlots()) {
            return this.overlay.getStackInSlot(slot);
        }
        return this.base.getStackInSlot(slot - this.overlay.getSlots());
    }

    @NotNull
    public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
        if (slot < this.overlay.getSlots()) {
            return this.overlay.insertItem(slot, stack, simulate);
        }
        return this.base.insertItem(slot - this.overlay.getSlots(), stack, simulate);
    }

    @NotNull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (slot < this.overlay.getSlots()) {
            return this.overlay.extractItem(slot, amount, simulate);
        }
        return this.base.extractItem(slot - this.overlay.getSlots(), amount, simulate);
    }

    public int getSlotLimit(int slot) {
        if (slot < this.overlay.getSlots()) {
            return this.overlay.getSlotLimit(slot);
        }
        return this.base.getSlotLimit(slot - this.overlay.getSlots());
    }

    public boolean isItemValid(int slot, @NotNull ItemStack stack) {
        if (slot < this.overlay.getSlots()) {
            return this.overlay.isItemValid(slot, stack);
        }
        return this.base.isItemValid(slot - this.overlay.getSlots(), stack);
    }

    public void setStackInSlot(int slot, @NotNull ItemStack stack) {
        if (slot < this.overlay.getSlots()) {
            this.overlay.setStackInSlot(slot, stack);
        } else {
            this.base.setStackInSlot(slot - this.overlay.getSlots(), stack);
        }
    }
}

