/*
 * Decompiled with CFR 0.152.
 */
package net.permutated.exmachinis.machines.hammer;

import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.network.IContainerFactory;
import net.permutated.exmachinis.ModRegistry;
import net.permutated.exmachinis.machines.base.AbstractMachineBlock;
import net.permutated.exmachinis.machines.base.AbstractMachineMenu;
import net.permutated.exmachinis.machines.base.AbstractMachineTile;
import net.permutated.exmachinis.machines.hammer.FluxHammerMenu;
import net.permutated.exmachinis.machines.hammer.FluxHammerTile;
import net.permutated.exmachinis.util.BlockUtil;
import net.permutated.exmachinis.util.TranslationKey;

public class FluxHammerBlock
extends AbstractMachineBlock {
    private static final VoxelShape SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)2.0, (double)16.0, (double)10.0, (double)15.0);
    private static final VoxelShape SHAPE_HOPPER = Stream.of(Block.m_49796_((double)0.0, (double)0.0, (double)2.0, (double)16.0, (double)10.0, (double)15.0), Block.m_49796_((double)5.0, (double)10.0, (double)7.0, (double)13.0, (double)13.0, (double)15.0), Shapes.m_83113_((VoxelShape)Block.m_49796_((double)13.0, (double)12.0, (double)6.0, (double)15.0, (double)16.0, (double)14.0), (VoxelShape)Shapes.m_83113_((VoxelShape)Block.m_49796_((double)3.0, (double)12.0, (double)14.0, (double)15.0, (double)16.0, (double)16.0), (VoxelShape)Shapes.m_83113_((VoxelShape)Block.m_49796_((double)3.0, (double)12.0, (double)6.0, (double)5.0, (double)16.0, (double)14.0), (VoxelShape)Block.m_49796_((double)3.0, (double)12.0, (double)4.0, (double)15.0, (double)16.0, (double)6.0), (BooleanOp)BooleanOp.f_82689_), (BooleanOp)BooleanOp.f_82689_), (BooleanOp)BooleanOp.f_82689_)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    private static final EnumMap<Direction, Map.Entry<VoxelShape, VoxelShape>> SHAPE_MAP = new EnumMap(Direction.class);
    public static final DirectionProperty FACING;
    public static final BooleanProperty HOPPER;

    public FluxHammerBlock() {
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)OUTPUT, (Comparable)Direction.NORTH)).m_61124_((Property)HOPPER, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape m_5940_(BlockState blockState, BlockGetter reader, BlockPos pos, CollisionContext context) {
        Boolean hopper = (Boolean)blockState.m_61143_((Property)HOPPER);
        Direction facing = (Direction)blockState.m_61143_((Property)FACING);
        Map.Entry<VoxelShape, VoxelShape> shapes = SHAPE_MAP.get(facing);
        return Boolean.FALSE.equals(hopper) ? shapes.getKey() : shapes.getValue();
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockPos above = context.m_8083_().m_7494_();
        boolean isAir = context.m_43725_().m_8055_(above).m_60795_();
        Direction opposite = context.m_8125_().m_122424_();
        return (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)opposite)).m_61124_((Property)OUTPUT, (Comparable)opposite)).m_61124_((Property)HOPPER, (Comparable)Boolean.valueOf(!isAir));
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{FACING, HOPPER});
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos pos, BlockPos facingPos) {
        if (facing.equals((Object)Direction.UP)) {
            Boolean current = (Boolean)state.m_61143_((Property)HOPPER);
            if (facingState.m_60795_() && Boolean.TRUE.equals(current)) {
                return (BlockState)state.m_61124_((Property)HOPPER, (Comparable)Boolean.valueOf(false));
            }
            if (!facingState.m_60795_() && Boolean.FALSE.equals(current)) {
                return (BlockState)state.m_61124_((Property)HOPPER, (Comparable)Boolean.valueOf(true));
            }
        }
        return state;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new FluxHammerTile(pos, state);
    }

    @Override
    public BlockEntityType<? extends AbstractMachineTile> getTileType() {
        return (BlockEntityType)ModRegistry.FLUX_HAMMER_TILE.get();
    }

    @Override
    public IContainerFactory<AbstractMachineMenu> containerFactory() {
        return FluxHammerMenu::new;
    }

    public void m_5871_(ItemStack stack, @Nullable BlockGetter reader, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_5871_(stack, reader, tooltip, flagIn);
        tooltip.add((Component)TranslationKey.translateTooltip("hammer1"));
    }

    static {
        Direction.Plane.HORIZONTAL.forEach(direction -> {
            VoxelShape left = BlockUtil.rotateShape(Direction.NORTH, direction, SHAPE);
            VoxelShape right = BlockUtil.rotateShape(Direction.NORTH, direction, SHAPE_HOPPER);
            SHAPE_MAP.put((Direction)direction, Map.entry(left, right));
        });
        FACING = BlockStateProperties.f_61374_;
        HOPPER = BooleanProperty.m_61465_((String)"hopper");
    }
}

