/*
 * Decompiled with CFR 0.152.
 */
package net.permutated.exmachinis.machines.buffer;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import net.permutated.exmachinis.ModRegistry;
import net.permutated.exmachinis.items.ComparatorUpgradeItem;
import net.permutated.exmachinis.machines.base.AbstractMachineBlock;
import net.permutated.exmachinis.machines.base.AbstractMachineTile;
import net.permutated.exmachinis.util.WorkStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemBufferTile
extends AbstractMachineTile {
    protected final LazyOptional<IItemHandler> lazyHandler = LazyOptional.of(() -> this.itemStackHandler);
    private boolean inventoryChanged = false;
    private int redstoneLevel = 0;
    private Direction redstoneDirection = null;

    public ItemBufferTile(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModRegistry.ITEM_BUFFER_TILE.get(), pos, state);
        ItemStackHandler itemStackHandler = this.itemStackHandler;
        if (itemStackHandler instanceof AbstractMachineTile.MachineItemStackHandler) {
            AbstractMachineTile.MachineItemStackHandler m = (AbstractMachineTile.MachineItemStackHandler)itemStackHandler;
            m.setListener(this::inventoryChangeListener);
        }
    }

    @Override
    protected boolean isItemValid(ItemStack stack) {
        return true;
    }

    @Override
    protected boolean enableComparatorSlot() {
        return true;
    }

    @Override
    @NotNull
    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            if (side == null) {
                return this.overlay.cast();
            }
            return this.lazyHandler.cast();
        }
        if (cap == ForgeCapabilities.ENERGY) {
            return LazyOptional.empty();
        }
        return super.getCapability(cap, side);
    }

    @Override
    public void tick() {
        if (this.f_58857_ instanceof ServerLevel && this.canTick(this.getUpgradeTickDelay())) {
            Boolean enabled = (Boolean)this.m_58900_().m_61143_((Property)AbstractMachineBlock.ENABLED);
            if (Boolean.FALSE.equals(enabled)) {
                this.workStatus = WorkStatus.REDSTONE_DISABLED;
                return;
            }
            Direction output = (Direction)this.m_58900_().m_61143_((Property)AbstractMachineBlock.OUTPUT);
            BlockPos outPos = this.m_58899_().m_121945_(output);
            BlockEntity target = this.f_58857_.m_7702_(outPos);
            if (target == null) {
                this.workStatus = WorkStatus.MISSING_INVENTORY;
                return;
            }
            IItemHandler itemHandler = target.getCapability(ForgeCapabilities.ITEM_HANDLER, output.m_122424_()).resolve().orElse(null);
            if (itemHandler == null || itemHandler.getSlots() == 0) {
                this.workStatus = WorkStatus.MISSING_INVENTORY;
                return;
            }
            this.workStatus = WorkStatus.WORKING;
            int maxProcessed = this.getUpgradeItemsProcessed();
            for (int i = 0; i < this.itemStackHandler.getSlots() && maxProcessed != 0; ++i) {
                int extractCount;
                ItemStack stack = this.itemStackHandler.getStackInSlot(i);
                if (stack.m_41619_()) continue;
                int count = stack.m_41613_();
                if (count >= maxProcessed) {
                    extractCount = maxProcessed;
                    maxProcessed = 0;
                } else {
                    extractCount = count;
                    maxProcessed -= count;
                }
                ItemStack extractResult = this.itemStackHandler.extractItem(i, extractCount, true);
                ItemStack insertResult = ItemHandlerHelper.insertItemStacked((IItemHandler)itemHandler, (ItemStack)extractResult, (boolean)true);
                if (extractResult.m_41613_() <= insertResult.m_41613_()) continue;
                int inserted = extractResult.m_41613_() - insertResult.m_41613_();
                ItemStack extracted = this.itemStackHandler.extractItem(i, inserted, false);
                ItemHandlerHelper.insertItemStacked((IItemHandler)itemHandler, (ItemStack)extracted, (boolean)false);
            }
            this.sortSlots();
        }
        this.checkForRedstoneSignal();
    }

    private void inventoryChangeListener() {
        this.inventoryChanged = true;
    }

    private void checkForRedstoneSignal() {
        Level level = this.f_58857_;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (!this.inventoryChanged) {
                return;
            }
            this.inventoryChanged = false;
            int calulated = 0;
            ItemStack stack = this.upgradeStackHandler.getStackInSlot(1);
            if (!stack.m_41619_() && stack.m_41720_() instanceof ComparatorUpgradeItem) {
                this.redstoneDirection = ComparatorUpgradeItem.getDirection(stack);
                if (this.redstoneDirection != null) {
                    calulated = ItemHandlerHelper.calcRedstoneFromInventory((IItemHandler)this.itemStackHandler);
                }
            }
            if (this.redstoneLevel != calulated) {
                this.redstoneLevel = calulated;
                serverLevel.m_46672_(this.m_58899_(), this.m_58900_().m_60734_());
            }
        }
    }

    public int getRedstoneLevel() {
        return this.redstoneLevel;
    }

    @Nullable
    public Direction getRedstoneDirection() {
        return this.redstoneDirection;
    }
}

