/*
 * Decompiled with CFR 0.152.
 */
package net.permutated.exmachinis.machines.base;

import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.util.Mth;
import net.minecraft.world.Containers;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.EnergyStorage;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.permutated.exmachinis.ConfigHolder;
import net.permutated.exmachinis.ExMachinis;
import net.permutated.exmachinis.compat.exnihilo.ExNihiloAPI;
import net.permutated.exmachinis.items.ComparatorUpgradeItem;
import net.permutated.exmachinis.items.UpgradeItem;
import net.permutated.exmachinis.util.OverlayItemHandler;
import net.permutated.exmachinis.util.PipeItemHandler;
import net.permutated.exmachinis.util.WorkStatus;

public abstract class AbstractMachineTile
extends BlockEntity {
    protected int version = 1;
    protected WorkStatus workStatus = WorkStatus.NONE;
    protected final MachineEnergyStorage energyStorage = new MachineEnergyStorage(this.getMaxEnergyStorage(), this.getMaxEnergyTransfer());
    protected final ItemStackHandler itemStackHandler = new MachineItemStackHandler(this.enableComparatorSlot() ? 18 : 9){

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return AbstractMachineTile.this.isItemValid(stack);
        }
    };
    protected final ItemStackHandler upgradeStackHandler = new MachineItemStackHandler(this.enableMeshSlot() || this.enableComparatorSlot() ? 2 : 1){

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            if (slot == 0) {
                return stack.m_41720_() instanceof UpgradeItem;
            }
            return AbstractMachineTile.this.enableMeshSlot() && ExNihiloAPI.isMeshItem(stack) || AbstractMachineTile.this.enableComparatorSlot() && stack.m_41720_() instanceof ComparatorUpgradeItem;
        }

        public int getSlotLimit(int slot) {
            return slot == 0 ? 3 : 1;
        }
    };
    protected final LazyOptional<EnergyStorage> energy = LazyOptional.of(() -> this.energyStorage);
    protected final LazyOptional<IItemHandler> handler = LazyOptional.of(() -> new PipeItemHandler(this.itemStackHandler));
    protected final LazyOptional<IItemHandler> overlay = LazyOptional.of(() -> new OverlayItemHandler(this.itemStackHandler, this.upgradeStackHandler));
    int remainder = 0;
    private long lastTicked = 0L;
    int offset = 0;

    protected AbstractMachineTile(BlockEntityType<?> blockEntityType, BlockPos pos, BlockState state) {
        super(blockEntityType, pos, state);
    }

    protected int getMaxEnergyStorage() {
        return (Integer)ConfigHolder.SERVER.energyBufferSize.get();
    }

    protected int getMaxEnergyTransfer() {
        return (Integer)ConfigHolder.SERVER.maxEnergyPerTick.get();
    }

    protected int getUpgradeItemsProcessed() {
        ItemStack upgradeStack = this.upgradeStackHandler.getStackInSlot(0);
        Item item = upgradeStack.m_41720_();
        if (item instanceof UpgradeItem) {
            UpgradeItem upgradeItem = (UpgradeItem)item;
            if (upgradeStack.m_41613_() > 0) {
                int upgradeCount = Mth.m_14045_((int)upgradeStack.m_41613_(), (int)1, (int)3);
                return upgradeItem.getTier().getItemsProcessed(upgradeCount);
            }
        }
        return 1;
    }

    protected int getUpgradeTickDelay() {
        ItemStack upgradeStack = this.upgradeStackHandler.getStackInSlot(0);
        Item item = upgradeStack.m_41720_();
        if (item instanceof UpgradeItem) {
            UpgradeItem upgradeItem = (UpgradeItem)item;
            return switch (upgradeItem.getTier()) {
                default -> throw new IncompatibleClassChangeError();
                case UpgradeItem.Tier.GOLD -> (Integer)ConfigHolder.SERVER.goldTicksPerOperation.get();
                case UpgradeItem.Tier.DIAMOND -> (Integer)ConfigHolder.SERVER.diamondTicksPerOperation.get();
                case UpgradeItem.Tier.NETHERITE -> (Integer)ConfigHolder.SERVER.netheriteTicksPerOperation.get();
            };
        }
        return (Integer)ConfigHolder.SERVER.goldTicksPerOperation.get();
    }

    protected int getUpgradeEnergyCost() {
        ItemStack upgradeStack = this.upgradeStackHandler.getStackInSlot(0);
        Item item = upgradeStack.m_41720_();
        if (item instanceof UpgradeItem) {
            UpgradeItem upgradeItem = (UpgradeItem)item;
            return switch (upgradeItem.getTier()) {
                default -> throw new IncompatibleClassChangeError();
                case UpgradeItem.Tier.GOLD -> (Integer)ConfigHolder.SERVER.goldEnergyPerBlock.get();
                case UpgradeItem.Tier.DIAMOND -> (Integer)ConfigHolder.SERVER.diamondEnergyPerBlock.get();
                case UpgradeItem.Tier.NETHERITE -> (Integer)ConfigHolder.SERVER.netheriteEnergyPerBlock.get();
            };
        }
        return (Integer)ConfigHolder.SERVER.goldEnergyPerBlock.get();
    }

    protected abstract boolean isItemValid(ItemStack var1);

    protected boolean enableMeshSlot() {
        return false;
    }

    protected boolean enableComparatorSlot() {
        return false;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            if (side == null) {
                return this.overlay.cast();
            }
            return this.handler.cast();
        }
        if (cap == ForgeCapabilities.ENERGY) {
            return this.energy.cast();
        }
        return super.getCapability(cap, side);
    }

    public void dropItems() {
        AbstractMachineTile.dropItems(this.f_58857_, this.f_58858_, (IItemHandler)this.itemStackHandler);
        AbstractMachineTile.dropItems(this.f_58857_, this.f_58858_, (IItemHandler)this.upgradeStackHandler);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.energy.invalidate();
        this.handler.invalidate();
        this.overlay.invalidate();
    }

    public boolean canTick(int every) {
        long gameTime;
        long l = gameTime = this.f_58857_ != null ? this.f_58857_.m_46467_() : 0L;
        if (gameTime != this.lastTicked) {
            this.lastTicked = gameTime;
            this.remainder = (int)(this.offset(gameTime) % (long)every);
            return this.remainder == 0;
        }
        return false;
    }

    protected long offset(long gameTime) {
        if (this.offset == 0) {
            this.offset += ThreadLocalRandom.current().nextInt(0, 20);
        }
        return gameTime + (long)this.offset;
    }

    public abstract void tick();

    public static <T extends BlockEntity> void tick(Level level, BlockPos pos, BlockState state, T blockEntity) {
        if (blockEntity instanceof AbstractMachineTile) {
            AbstractMachineTile machineTile = (AbstractMachineTile)blockEntity;
            machineTile.tick();
        }
    }

    public int getMaxWork() {
        return this.getUpgradeTickDelay();
    }

    public int getWork() {
        return this.remainder;
    }

    public WorkStatus getWorkStatus() {
        return this.workStatus;
    }

    protected static void dropItems(@Nullable Level world, BlockPos pos, IItemHandler itemHandler) {
        for (int i = 0; i < itemHandler.getSlots(); ++i) {
            ItemStack itemstack = itemHandler.getStackInSlot(i);
            if (itemstack.m_41613_() <= 0 || world == null) continue;
            Containers.m_18992_((Level)world, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)itemstack);
        }
    }

    public void updateContainer(FriendlyByteBuf packetBuffer) {
        packetBuffer.writeBoolean(this.enableMeshSlot());
        packetBuffer.writeBoolean(this.enableComparatorSlot());
        packetBuffer.m_130064_(this.f_58858_);
    }

    protected void m_183515_(CompoundTag tag) {
        tag.m_128405_("version", this.version);
        tag.m_128365_("energy", this.energyStorage.serializeNBT());
        tag.m_128365_("inventory", (Tag)this.itemStackHandler.serializeNBT());
        tag.m_128365_("upgrades", (Tag)this.upgradeStackHandler.serializeNBT());
    }

    public void m_142466_(CompoundTag tag) {
        this.version = tag.m_128451_("version");
        this.energyStorage.deserializeNBT(tag.m_128423_("energy"));
        this.itemStackHandler.deserializeNBT(tag.m_128469_("inventory"));
        this.upgradeStackHandler.deserializeNBT(tag.m_128469_("upgrades"));
        super.m_142466_(tag);
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195642_((BlockEntity)this, BlockEntity::m_5995_);
    }

    protected void sortSlots() {
        for (int i = 0; i < this.itemStackHandler.getSlots(); ++i) {
            ItemStack stack = this.itemStackHandler.getStackInSlot(i);
            int missing = stack.m_41741_() - stack.m_41613_();
            if (stack.m_41619_() || missing <= 0) continue;
            for (int j = i + 1; j < this.itemStackHandler.getSlots() && missing > 0; ++j) {
                ItemStack simulate;
                ItemStack match = this.itemStackHandler.getStackInSlot(j);
                if (!stack.m_150930_(match.m_41720_()) || (simulate = this.itemStackHandler.extractItem(j, missing, true)).m_41619_() || !this.itemStackHandler.insertItem(i, simulate, true).m_41619_()) continue;
                ItemStack actual = this.itemStackHandler.extractItem(j, simulate.m_41613_(), false);
                ItemStack result = this.itemStackHandler.insertItem(i, actual, false);
                missing -= actual.m_41613_();
                if (result.m_41619_()) continue;
                ExMachinis.LOGGER.error("non-empty itemstack returned from sorting: {}", (Object)result);
            }
        }
    }

    public class MachineEnergyStorage
    extends EnergyStorage {
        public MachineEnergyStorage(int capacity, int maxRecieve) {
            super(capacity, maxRecieve, 0);
        }

        public void onEnergyChanged() {
            AbstractMachineTile.this.m_6596_();
        }

        public int receiveEnergy(int maxReceive, boolean simulate) {
            int rc = super.receiveEnergy(maxReceive, simulate);
            if (rc > 0 && !simulate) {
                this.onEnergyChanged();
            }
            return rc;
        }

        public int extractEnergy(int maxExtract, boolean simulate) {
            int rc = super.extractEnergy(maxExtract, simulate);
            if (rc > 0 && !simulate) {
                this.onEnergyChanged();
            }
            return rc;
        }

        public boolean consumeEnergy(int request, boolean simulate) {
            int consumed = Math.max(0, request);
            if (this.energy > consumed) {
                if (!simulate) {
                    this.energy -= consumed;
                    this.onEnergyChanged();
                }
                return true;
            }
            return false;
        }
    }

    public class MachineItemStackHandler
    extends ItemStackHandler {
        Runnable listener;

        public MachineItemStackHandler(int size) {
            super(size);
            this.listener = null;
        }

        protected void onContentsChanged(int slot) {
            if (this.listener != null) {
                this.listener.run();
            }
            AbstractMachineTile.this.m_6596_();
        }

        public void setListener(Runnable listener) {
            this.listener = listener;
        }
    }
}

