/*
 * Decompiled with CFR 0.152.
 */
package me.codexadrian.tempad.common.items;

import com.teamresourceful.resourcefullib.common.utils.CommonUtils;
import java.util.List;
import java.util.UUID;
import me.codexadrian.tempad.common.data.LocationData;
import me.codexadrian.tempad.common.data.TempadLocationHandler;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LocationCard
extends Item {
    public LocationCard(Item.Properties properties) {
        super(properties);
    }

    public static void setLocation(ItemStack stack, LocationData locationData, String creator) {
        stack.m_41784_().m_128365_("Location", (Tag)locationData.toTag());
        stack.m_41784_().m_128359_("Creator", creator);
    }

    @Nullable
    public static LocationData getLocation(ItemStack stack) {
        if (!stack.m_41782_() || !stack.m_41783_().m_128441_("Location")) {
            return null;
        }
        return LocationData.fromTag(stack.m_41784_().m_128469_("Location"));
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltipComponents, TooltipFlag isAdvanced) {
        super.m_7373_(stack, level, tooltipComponents, isAdvanced);
        LocationData location = LocationCard.getLocation(stack);
        if (location != null) {
            tooltipComponents.add((Component)Component.m_237110_((String)"item.tempad.location_card.shift_toolip", (Object[])new Object[]{Component.m_237113_((String)"SHIFT").m_130940_(Screen.m_96638_() ? ChatFormatting.WHITE : ChatFormatting.GOLD)}).m_130940_(ChatFormatting.GRAY));
            if (Screen.m_96638_()) {
                tooltipComponents.add((Component)Component.m_237113_((String)location.getName()).m_130940_(ChatFormatting.GRAY));
                tooltipComponents.add((Component)Component.m_237110_((String)"gui.tempad.x", (Object[])new Object[]{location.getBlockPos().m_123341_()}).m_130940_(ChatFormatting.GRAY));
                tooltipComponents.add((Component)Component.m_237110_((String)"gui.tempad.y", (Object[])new Object[]{location.getBlockPos().m_123342_()}).m_130940_(ChatFormatting.GRAY));
                tooltipComponents.add((Component)Component.m_237110_((String)"gui.tempad.z", (Object[])new Object[]{location.getBlockPos().m_123343_()}).m_130940_(ChatFormatting.GRAY));
                tooltipComponents.add((Component)Component.m_237110_((String)"gui.tempad.dimension", (Object[])new Object[]{Component.m_237115_((String)location.getLevelKey().m_135782_().m_214296_("dimension"))}).m_130940_(ChatFormatting.GRAY));
                if (stack.m_41782_() && stack.m_41783_().m_128441_("Creator")) {
                    tooltipComponents.add((Component)Component.m_237110_((String)"item.tempad.location_card.creator_toolip", (Object[])new Object[]{Component.m_237115_((String)stack.m_41783_().m_128461_("Creator")).m_130940_(ChatFormatting.AQUA)}).m_130940_(ChatFormatting.GRAY));
                }
            }
        } else {
            tooltipComponents.add((Component)Component.m_237115_((String)"item.tempad.location_card.add_location").m_130940_(ChatFormatting.GRAY));
            tooltipComponents.add((Component)Component.m_237115_((String)"item.tempad.location_card.set_name").m_130940_(ChatFormatting.GRAY));
        }
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand usedHand) {
        if (!level.f_46443_) {
            LocationData location = LocationCard.getLocation(player.m_21120_(usedHand));
            if (location != null) {
                TempadLocationHandler.addLocation(level, player.m_20148_(), location);
                player.m_21120_(usedHand).m_41774_(1);
                player.m_5661_((Component)Component.m_237110_((String)"item.tempad.location_card.added_location", (Object[])new Object[]{Component.m_237113_((String)location.getName()).m_130940_(ChatFormatting.GOLD)}), true);
            } else {
                LocationData newLocation = new LocationData(player.m_21120_(usedHand).m_41786_().getString(), (ResourceKey<Level>)level.m_46472_(), player.m_20183_(), (UUID)CommonUtils.generate(id -> !TempadLocationHandler.containsLocation(level, player.m_20148_(), id), UUID::randomUUID));
                LocationCard.setLocation(player.m_21120_(usedHand), newLocation, player.m_5446_().getString());
                player.m_5661_((Component)Component.m_237110_((String)"item.tempad.location_card.set_location", (Object[])new Object[]{Component.m_237113_((String)newLocation.getName()).m_130940_(ChatFormatting.GOLD)}), true);
            }
            return InteractionResultHolder.m_19090_((Object)player.m_21120_(usedHand));
        }
        return InteractionResultHolder.m_19098_((Object)player.m_21120_(usedHand));
    }
}

