/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.internal.command.client;

import codechicken.lib.internal.ItemFileRenderer;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.commands.CommandRuntimeException;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;

public class RenderItemToFileCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"ccl").then(((LiteralArgumentBuilder)Commands.m_82127_((String)"render_held").then(Commands.m_82129_((String)"resolution", (ArgumentType)IntegerArgumentType.integer((int)16)).then(Commands.m_82129_((String)"name", (ArgumentType)StringArgumentType.greedyString()).executes(e -> RenderItemToFileCommand.renderToFile((CommandContext<CommandSourceStack>)e, RenderItemToFileCommand.getResolution((CommandContext<CommandSourceStack>)e)))))).then(Commands.m_82129_((String)"name", (ArgumentType)StringArgumentType.greedyString()).executes(e -> RenderItemToFileCommand.renderToFile((CommandContext<CommandSourceStack>)e, 512))))).then(Commands.m_82127_((String)"render_held_anim").then(Commands.m_82129_((String)"fps", (ArgumentType)IntegerArgumentType.integer((int)5, (int)75)).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"duration", (ArgumentType)IntegerArgumentType.integer()).then(Commands.m_82129_((String)"resolution", (ArgumentType)IntegerArgumentType.integer((int)16)).then(Commands.m_82129_((String)"name", (ArgumentType)StringArgumentType.greedyString()).executes(e -> RenderItemToFileCommand.renderAnim((CommandContext<CommandSourceStack>)e, RenderItemToFileCommand.getResolution((CommandContext<CommandSourceStack>)e)))))).then(Commands.m_82129_((String)"name", (ArgumentType)StringArgumentType.greedyString()).executes(e -> RenderItemToFileCommand.renderAnim((CommandContext<CommandSourceStack>)e, 512)))))));
    }

    private static int renderToFile(CommandContext<CommandSourceStack> ctx, int resolution) {
        String path = RenderItemToFileCommand.getPath(ctx);
        ItemStack held = RenderItemToFileCommand.getHeldItem();
        ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)("Queued item render to file: " + path)), false);
        ItemFileRenderer.renderStatic(held, path, resolution);
        return 0;
    }

    private static int renderAnim(CommandContext<CommandSourceStack> ctx, int resolution) {
        Object finalPath;
        String ext;
        CommandSourceStack src = (CommandSourceStack)ctx.getSource();
        int fps = IntegerArgumentType.getInteger(ctx, (String)"fps");
        int duration = IntegerArgumentType.getInteger(ctx, (String)"duration");
        String path = RenderItemToFileCommand.getPath(ctx);
        ItemStack held = RenderItemToFileCommand.getHeldItem();
        int lastSlash = path.lastIndexOf(47);
        int lastDot = path.lastIndexOf(46, lastSlash != -1 ? lastSlash : path.length() - 1);
        String string = ext = lastDot != -1 ? path.substring(lastDot + 1) : "";
        if (ext.isEmpty()) {
            ext = "gif";
            finalPath = path + ".gif";
        } else {
            finalPath = path;
        }
        switch (ext) {
            case "gif": {
                ItemFileRenderer.addGifRenderTask(held, (String)finalPath, resolution, fps, duration);
                src.m_288197_(() -> RenderItemToFileCommand.lambda$renderAnim$5((String)finalPath), false);
                break;
            }
            case "webp": {
                if (!ItemFileRenderer.addWebpRenderTask(held, path, resolution, fps, duration)) {
                    src.m_81352_((Component)Component.m_237113_((String)"Failed to queue render for webp, ffmpeg is not accessible. Either make it accessible on PATH, or set the `ccl.ffmpeg` system property."));
                    break;
                }
                src.m_288197_(() -> Component.m_237113_((String)("Queued item render to webp: " + path)), false);
            }
        }
        return 0;
    }

    private static String getPath(CommandContext<CommandSourceStack> ctx) {
        String str = StringArgumentType.getString(ctx, (String)"name");
        if (str.contains("..")) {
            throw new CommandRuntimeException((Component)Component.m_237113_((String)"'..' is not allowed in name."));
        }
        return str;
    }

    public static int getResolution(CommandContext<CommandSourceStack> ctx) {
        int res = IntegerArgumentType.getInteger(ctx, (String)"resolution");
        if ((res & res - 1) != 0) {
            throw new CommandRuntimeException((Component)Component.m_237113_((String)"Resolution must be a power of 2. 16, 32, 64..."));
        }
        return res;
    }

    private static ItemStack getHeldItem() {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        ItemStack held = player.m_21120_(InteractionHand.MAIN_HAND);
        if (held.m_41619_()) {
            held = player.m_21120_(InteractionHand.OFF_HAND);
        }
        if (held.m_41619_()) {
            throw new CommandRuntimeException((Component)Component.m_237113_((String)"You are not holding anything."));
        }
        return held;
    }

    private static /* synthetic */ Component lambda$renderAnim$5(String finalPath) {
        return Component.m_237113_((String)("Queued item render to gif: " + finalPath));
    }
}

