/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.libx.util.data;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.annotation.RegEx;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import org.moddingx.libx.LibX;
import org.moddingx.libx.util.lazy.LazyValue;

public class ResourceList
implements Predicate<ResourceLocation> {
    public static final ResourceList ALLOW_LIST = new ResourceList(true, b -> {});
    public static final ResourceList DENY_LIST = new ResourceList(false, b -> {});
    private static final WildcardString NAMESPACE_MC = new WildcardString(List.of("minecraft"));
    private final boolean allowList;
    private final List<Rule> rules;

    public ResourceList(boolean allowList, Consumer<RuleBuilder> rules) {
        this.allowList = allowList;
        RuleBuilder builder = new RuleBuilder();
        rules.accept(builder);
        this.rules = builder.rulesBuilderList.build();
    }

    public ResourceList(JsonObject json) {
        boolean bl = this.allowList = !json.has("allow_list") || json.get("allow_list").getAsBoolean();
        if (!json.has("elements")) {
            throw new IllegalStateException("Resource list has no member 'elements': " + json);
        }
        if (!json.get("elements").isJsonArray()) {
            throw new IllegalStateException("Resource list has no array member 'elements': " + json.get("elements"));
        }
        JsonArray elements = json.get("elements").getAsJsonArray();
        ImmutableList.Builder rules = ImmutableList.builder();
        for (JsonElement elem : elements) {
            try {
                rules.add((Object)this.parseRule(elem));
            }
            catch (IllegalStateException e) {
                LibX.logger.warn("Skipping invalid rule in resource list: " + e.getMessage());
            }
        }
        this.rules = rules.build();
    }

    public ResourceList(FriendlyByteBuf buffer) {
        this.allowList = buffer.readBoolean();
        int ruleSize = buffer.m_130242_();
        ImmutableList.Builder rules = ImmutableList.builder();
        for (int i = 0; i < ruleSize; ++i) {
            rules.add((Object)this.ruleFromNetwork(buffer));
        }
        this.rules = rules.build();
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        json.addProperty("allow_list", Boolean.valueOf(this.allowList));
        JsonArray array = new JsonArray();
        for (Rule rule : this.rules) {
            array.add(rule.toJson());
        }
        json.add("elements", (JsonElement)array);
        return json;
    }

    public void toNetwork(FriendlyByteBuf buffer) {
        buffer.writeBoolean(this.allowList);
        buffer.m_130130_(this.rules.size());
        this.rules.forEach(rule -> rule.toNetwork(buffer));
    }

    public boolean isAllowList() {
        return this.allowList;
    }

    public List<RuleEntry> getRules() {
        return this.rules.stream().map(Rule::getEntry).toList();
    }

    @Override
    public boolean test(ResourceLocation rl) {
        for (Rule rule : this.rules) {
            Boolean value = rule.test(rl);
            if (value == null) continue;
            return value;
        }
        return !this.allowList;
    }

    private Rule parseRule(JsonElement json) {
        if (json.isJsonPrimitive() && json.getAsJsonPrimitive().isString()) {
            String str = json.getAsJsonPrimitive().getAsString();
            return this.parseSimpleRule(str);
        }
        if (json.isJsonObject()) {
            Boolean allow;
            JsonObject obj = json.getAsJsonObject();
            Boolean bl = allow = obj.has("allow") ? Boolean.valueOf(obj.get("allow").getAsBoolean()) : null;
            if (!obj.has("regex")) {
                throw new IllegalStateException("Failed to build rule for resource list: JSON object has no member 'regex': " + json);
            }
            String regex = obj.get("regex").getAsString();
            return new RegexRule(allow, regex);
        }
        throw new IllegalStateException("Failed to build rule for resource list: JSON is not a string and not an object: " + json);
    }

    private Rule ruleFromNetwork(FriendlyByteBuf buffer) {
        byte id = buffer.readByte();
        if (id == 0) {
            Boolean allow = switch (buffer.readByte()) {
                case 0 -> false;
                case 1 -> true;
                default -> null;
            };
            int namespaceSize = buffer.m_130242_();
            ArrayList<String> namespace = new ArrayList<String>();
            for (int i = 0; i < namespaceSize; ++i) {
                namespace.add(buffer.m_130136_(Short.MAX_VALUE));
            }
            int pathSize = buffer.m_130242_();
            ArrayList<String> path = new ArrayList<String>();
            for (int i = 0; i < pathSize; ++i) {
                path.add(buffer.m_130136_(Short.MAX_VALUE));
            }
            return new SimpleRule(allow, new WildcardString(namespace), new WildcardString(path));
        }
        if (id == 1) {
            Boolean allow = switch (buffer.readByte()) {
                case 0 -> false;
                case 1 -> true;
                default -> null;
            };
            String regex = buffer.m_130136_(Short.MAX_VALUE);
            return new RegexRule(allow, regex);
        }
        throw new IllegalStateException("Invalid packet: Unknown rule id: " + id);
    }

    private Rule parseSimpleRule(String str) {
        WildcardString path;
        WildcardString namespace;
        Boolean allow;
        if (str.startsWith("+")) {
            allow = true;
            str = str.substring(1);
        } else if (str.startsWith("-")) {
            allow = false;
            str = str.substring(1);
        } else {
            allow = null;
        }
        if (str.trim().equals("*")) {
            namespace = new WildcardString(List.of("*"));
            path = new WildcardString(ResourceList.parseString(str.substring(str.indexOf(58) + 1)));
        } else if (str.contains(":")) {
            if (str.indexOf(58) != str.lastIndexOf(58)) {
                throw new IllegalStateException("Failed to build rule for resource list: Invalid resource location: More than one colon." + str);
            }
            namespace = new WildcardString(ResourceList.parseString(str.substring(0, str.indexOf(58))));
            path = new WildcardString(ResourceList.parseString(str.substring(str.indexOf(58) + 1)));
        } else {
            namespace = NAMESPACE_MC;
            path = new WildcardString(ResourceList.parseString(str));
        }
        return new SimpleRule(allow, namespace, path);
    }

    private static List<String> parseString(String str) {
        if (!ResourceLocation.m_135841_((String)str.replace("*", ""))) {
            throw new IllegalStateException("Failed to build rule for resource list: Invalid resource location identifier: " + str);
        }
        ArrayList<String> parts = new ArrayList<String>();
        boolean lastWildcard = false;
        StringTokenizer t = new StringTokenizer(str, "*", true);
        while (t.hasMoreTokens()) {
            String elem = t.nextToken();
            boolean thisWildcard = elem.trim().equals("*");
            if ((elem.isEmpty() || lastWildcard) && thisWildcard) continue;
            if (thisWildcard) {
                parts.add("*");
            } else {
                parts.add(elem);
            }
            lastWildcard = thisWildcard;
        }
        return parts;
    }

    public class RuleBuilder {
        private final ImmutableList.Builder<Rule> rulesBuilderList = ImmutableList.builder();

        private RuleBuilder() {
        }

        public void simple(ResourceLocation rl) {
            this.rulesBuilderList.add((Object)new SimpleRule(null, new WildcardString(List.of(rl.m_135827_())), new WildcardString(List.of(rl.m_135815_()))));
        }

        public void simple(boolean allow, ResourceLocation rl) {
            this.rulesBuilderList.add((Object)new SimpleRule(allow, new WildcardString(List.of(rl.m_135827_())), new WildcardString(List.of(rl.m_135815_()))));
        }

        public void parse(String rule) {
            this.rulesBuilderList.add((Object)ResourceList.this.parseSimpleRule(rule));
        }

        public void regex(@RegEx String regex) {
            this.rulesBuilderList.add((Object)new RegexRule(null, regex));
        }

        public void regex(boolean allow, @RegEx String regex) {
            this.rulesBuilderList.add((Object)new RegexRule(allow, regex));
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    private static interface Rule {
        public Boolean test(ResourceLocation var1);

        public JsonElement toJson();

        public void toNetwork(FriendlyByteBuf var1);

        public RuleEntry getEntry();
    }

    private final class RegexRule
    implements Rule {
        private final Boolean allow;
        private final String regex;
        public final LazyValue<Predicate<String>> matcher;

        public RegexRule(Boolean allow, String regex) {
            this.allow = allow;
            this.regex = regex;
            this.matcher = new LazyValue<Predicate>(() -> Pattern.compile(regex).asMatchPredicate());
        }

        @Override
        public Boolean test(ResourceLocation rl) {
            if (this.matcher.get().test(rl.toString())) {
                return this.allow == null ? ResourceList.this.allowList : this.allow;
            }
            return null;
        }

        @Override
        public JsonElement toJson() {
            JsonObject json = new JsonObject();
            if (this.allow != null) {
                json.addProperty("allow", this.allow);
            }
            json.addProperty("regex", this.regex);
            return json;
        }

        @Override
        public void toNetwork(FriendlyByteBuf buffer) {
            buffer.writeByte(1);
            if (this.allow == null) {
                buffer.writeByte(-1);
            } else {
                buffer.writeByte(this.allow != false ? 1 : 0);
            }
            buffer.m_130072_(this.regex, Short.MAX_VALUE);
        }

        @Override
        public RuleEntry getEntry() {
            return new RuleEntry(this.regex, true, this.allow);
        }
    }

    private final class SimpleRule
    implements Rule {
        @Nullable
        private final Boolean allow;
        private final WildcardString namespace;
        private final WildcardString path;

        public SimpleRule(Boolean allow, WildcardString namespace, WildcardString path) {
            this.allow = allow;
            this.namespace = namespace;
            this.path = path;
        }

        @Override
        @Nullable
        public Boolean test(ResourceLocation rl) {
            if (this.namespace.matcher.get().test(rl.m_135827_()) && this.path.matcher.get().test(rl.m_135815_())) {
                return this.allow == null ? ResourceList.this.allowList : this.allow;
            }
            return null;
        }

        @Override
        public JsonElement toJson() {
            StringBuilder sb = new StringBuilder();
            if (this.allow != null) {
                sb.append(this.allow != false ? "+" : "-");
            }
            if (this.namespace.fullWildcard && this.path.fullWildcard) {
                sb.append("*");
            } else {
                this.namespace.parts.forEach(sb::append);
                sb.append(":");
                this.path.parts.forEach(sb::append);
            }
            return new JsonPrimitive(sb.toString());
        }

        @Override
        public void toNetwork(FriendlyByteBuf buffer) {
            buffer.writeByte(0);
            if (this.allow == null) {
                buffer.writeByte(-1);
            } else {
                buffer.writeByte(this.allow != false ? 1 : 0);
            }
            buffer.m_130130_(this.namespace.parts.size());
            this.namespace.parts.forEach(str -> buffer.m_130072_(str, Short.MAX_VALUE));
            buffer.m_130130_(this.path.parts.size());
            this.path.parts.forEach(str -> buffer.m_130072_(str, Short.MAX_VALUE));
        }

        @Override
        public RuleEntry getEntry() {
            StringBuilder sb = new StringBuilder();
            if (this.namespace.fullWildcard && this.path.fullWildcard) {
                sb.append("*");
            } else {
                this.namespace.parts.forEach(sb::append);
                sb.append(":");
                this.path.parts.forEach(sb::append);
            }
            return new RuleEntry(sb.toString(), false, this.allow);
        }
    }

    private static class WildcardString {
        public final List<String> parts;
        public final LazyValue<Predicate<String>> matcher;
        public final boolean fullWildcard;

        public WildcardString(List<String> parts) {
            ImmutableList partList = (ImmutableList)parts.stream().map(String::trim).filter(str -> !str.isEmpty()).collect(ImmutableList.toImmutableList());
            this.parts = partList.isEmpty() ? List.of("*") : partList;
            this.matcher = new LazyValue<Predicate>(() -> Pattern.compile("^" + this.parts.stream().map(str -> str.equals("*") ? ".*" : Pattern.quote(str)).collect(Collectors.joining()) + "$").asMatchPredicate());
            this.fullWildcard = this.parts.stream().allMatch(str -> str.equals("*"));
        }
    }

    public record RuleEntry(String value, boolean regex, @Nullable Boolean allow) {
    }
}

