/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.libx.menu;

import com.mojang.datafixers.util.Function5;
import io.netty.buffer.Unpooled;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.extensions.IForgeMenuType;
import net.minecraftforge.network.NetworkHooks;
import org.moddingx.libx.fi.Function6;
import org.moddingx.libx.menu.BlockEntityMenu;
import org.moddingx.libx.menu.DefaultMenu;

public abstract class EntityMenu<T extends Entity>
extends DefaultMenu {
    public final T entity;

    public EntityMenu(@Nullable MenuType<?> type, int windowId, Level level, int entityId, Inventory playerContainer, Player player, int firstOutputSlot, int firstInventorySlot) {
        super(type, windowId, level, playerContainer, player, firstOutputSlot, firstInventorySlot);
        this.entity = level.m_6815_(entityId);
    }

    public boolean m_6875_(@Nonnull Player player) {
        return EntityMenu.m_38889_((ContainerLevelAccess)ContainerLevelAccess.m_39289_((Level)this.level, (BlockPos)this.entity.m_20183_()), (Player)this.player, (Block)this.level.m_8055_(this.entity.m_20183_()).m_60734_());
    }

    public T getEntity() {
        return this.entity;
    }

    public static <T extends AbstractContainerMenu> MenuType<T> createMenuType(Function5<Integer, Level, Integer, Inventory, Player, T> constructor) {
        return IForgeMenuType.create((windowId1, inv, data) -> (AbstractContainerMenu)constructor.apply((Object)windowId1, (Object)inv.f_35978_.m_9236_(), (Object)data.readInt(), (Object)inv, (Object)inv.f_35978_));
    }

    public static <T extends AbstractContainerMenu> MenuType<T> createMenuType(Function6<MenuType<T>, Integer, Level, Integer, Inventory, Player, T> constructor) {
        AtomicReference<Object> typeRef = new AtomicReference<Object>(null);
        MenuType type = IForgeMenuType.create((windowId, inv, data) -> (AbstractContainerMenu)constructor.apply((MenuType)typeRef.get(), windowId, inv.f_35978_.m_9236_(), data.readInt(), inv, inv.f_35978_));
        typeRef.set(type);
        return type;
    }

    public static void openMenu(ServerPlayer player, final MenuType<? extends BlockEntityMenu<?>> menu, final Component title, final Entity entity) {
        MenuProvider containerProvider = new MenuProvider(){

            @Nonnull
            public Component m_5446_() {
                return title;
            }

            public AbstractContainerMenu m_7208_(int containerId, @Nonnull Inventory inventory, @Nonnull Player player) {
                FriendlyByteBuf buffer = new FriendlyByteBuf(Unpooled.buffer());
                buffer.writeInt(entity.m_19879_());
                return menu.create(containerId, inventory, buffer);
            }
        };
        NetworkHooks.openScreen((ServerPlayer)player, (MenuProvider)containerProvider, buffer -> buffer.writeInt(entity.m_19879_()));
    }
}

