/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.libx.impl.network;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.registries.ForgeRegistries;
import org.moddingx.libx.network.PacketHandler;
import org.moddingx.libx.network.PacketSerializer;

public record BeUpdateMessage(BlockPos pos, ResourceLocation id, CompoundTag nbt) {

    public static class Handler
    implements PacketHandler<BeUpdateMessage> {
        @Override
        public PacketHandler.Target target() {
            return PacketHandler.Target.MAIN_THREAD;
        }

        @Override
        public boolean handle(BeUpdateMessage msg, Supplier<NetworkEvent.Context> ctx) {
            BlockEntity be;
            ClientLevel level = Minecraft.m_91087_().f_91073_;
            if (level != null && (be = level.m_7702_(msg.pos())) != null && msg.id().equals((Object)ForgeRegistries.BLOCK_ENTITY_TYPES.getKey((Object)be.m_58903_()))) {
                be.handleUpdateTag(msg.nbt());
            }
            return true;
        }
    }

    public static class Serializer
    implements PacketSerializer<BeUpdateMessage> {
        @Override
        public Class<BeUpdateMessage> messageClass() {
            return BeUpdateMessage.class;
        }

        @Override
        public void encode(BeUpdateMessage msg, FriendlyByteBuf buffer) {
            buffer.m_130064_(msg.pos);
            buffer.m_130085_(msg.id);
            buffer.m_130079_(msg.nbt);
        }

        @Override
        public BeUpdateMessage decode(FriendlyByteBuf buffer) {
            BlockPos pos = buffer.m_130135_();
            ResourceLocation id = buffer.m_130281_();
            CompoundTag nbt = buffer.m_130260_();
            return new BeUpdateMessage(pos, id, nbt);
        }
    }
}

