/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.libx.impl.config.mappers;

import com.google.gson.JsonPrimitive;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.function.Function;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.moddingx.libx.config.gui.ConfigEditor;
import org.moddingx.libx.config.gui.InputProperties;
import org.moddingx.libx.config.mapper.ValueMapper;
import org.moddingx.libx.config.validate.DoubleRange;
import org.moddingx.libx.config.validate.FloatRange;
import org.moddingx.libx.config.validate.IntRange;
import org.moddingx.libx.config.validate.LongRange;
import org.moddingx.libx.config.validate.ShortRange;
import org.moddingx.libx.config.validator.ValidatorInfo;
import org.moddingx.libx.impl.config.gui.editor.CheckEditor;

public class SimpleValueMappers {
    public static final ValueMapper<Boolean, JsonPrimitive> BOOLEAN = new ValueMapper<Boolean, JsonPrimitive>(){

        @Override
        public Class<Boolean> type() {
            return Boolean.class;
        }

        @Override
        public Class<JsonPrimitive> element() {
            return JsonPrimitive.class;
        }

        @Override
        public Boolean fromJson(JsonPrimitive json) {
            return json.getAsBoolean();
        }

        @Override
        public JsonPrimitive toJson(Boolean value) {
            return new JsonPrimitive(value);
        }

        @Override
        public Boolean fromNetwork(FriendlyByteBuf buffer) {
            return buffer.readBoolean();
        }

        @Override
        public void toNetwork(Boolean value, FriendlyByteBuf buffer) {
            buffer.writeBoolean(value.booleanValue());
        }

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public ConfigEditor<Boolean> createEditor(ValidatorInfo<?> validator) {
            return CheckEditor.INSTANCE;
        }
    };
    public static final ValueMapper<Byte, JsonPrimitive> BYTE = new ValueMapper<Byte, JsonPrimitive>(){

        @Override
        public Class<Byte> type() {
            return Byte.class;
        }

        @Override
        public Class<JsonPrimitive> element() {
            return JsonPrimitive.class;
        }

        @Override
        public Byte fromJson(JsonPrimitive json) {
            return json.getAsByte();
        }

        @Override
        public JsonPrimitive toJson(Byte value) {
            return new JsonPrimitive((Number)value);
        }

        @Override
        public Byte fromNetwork(FriendlyByteBuf buffer) {
            return buffer.readByte();
        }

        @Override
        public void toNetwork(Byte value, FriendlyByteBuf buffer) {
            buffer.writeByte((int)value.byteValue());
        }

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public ConfigEditor<Byte> createEditor(ValidatorInfo<?> validator) {
            return ConfigEditor.input(SimpleValueMappers.number(false, (byte)0, Byte::parseByte), validator);
        }
    };
    public static final ValueMapper<Short, JsonPrimitive> SHORT = new ValueMapper<Short, JsonPrimitive>(){

        @Override
        public Class<Short> type() {
            return Short.class;
        }

        @Override
        public Class<JsonPrimitive> element() {
            return JsonPrimitive.class;
        }

        @Override
        public Short fromJson(JsonPrimitive json) {
            return json.getAsShort();
        }

        @Override
        public JsonPrimitive toJson(Short value) {
            return new JsonPrimitive((Number)value);
        }

        @Override
        public Short fromNetwork(FriendlyByteBuf buffer) {
            return buffer.readShort();
        }

        @Override
        public void toNetwork(Short value, FriendlyByteBuf buffer) {
            buffer.writeShort((int)value.shortValue());
        }

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public ConfigEditor<Short> createEditor(ValidatorInfo<?> validator) {
            ShortRange range = validator.value(ShortRange.class);
            if (range != null && range.min() != Short.MIN_VALUE && range.max() != Short.MAX_VALUE) {
                return ConfigEditor.slider(value -> (double)(value - range.min()) / (double)(range.max() - range.min()), value -> (short)Math.round(Mth.m_14139_((double)value, (double)range.min(), (double)range.max())));
            }
            return ConfigEditor.input(SimpleValueMappers.number(false, (short)0, Short::parseShort), validator);
        }
    };
    public static final ValueMapper<Integer, JsonPrimitive> INTEGER = new ValueMapper<Integer, JsonPrimitive>(){

        @Override
        public Class<Integer> type() {
            return Integer.class;
        }

        @Override
        public Class<JsonPrimitive> element() {
            return JsonPrimitive.class;
        }

        @Override
        public Integer fromJson(JsonPrimitive json) {
            return json.getAsInt();
        }

        @Override
        public JsonPrimitive toJson(Integer value) {
            return new JsonPrimitive((Number)value);
        }

        @Override
        public Integer fromNetwork(FriendlyByteBuf buffer) {
            return buffer.m_130242_();
        }

        @Override
        public void toNetwork(Integer value, FriendlyByteBuf buffer) {
            buffer.m_130130_(value.intValue());
        }

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public ConfigEditor<Integer> createEditor(ValidatorInfo<?> validator) {
            IntRange range = validator.value(IntRange.class);
            if (range != null && range.min() != Integer.MIN_VALUE && range.max() != Integer.MAX_VALUE) {
                return ConfigEditor.slider(value -> (double)(value - range.min()) / (double)(range.max() - range.min()), value -> (int)Math.round(Mth.m_14139_((double)value, (double)range.min(), (double)range.max())));
            }
            return ConfigEditor.input(SimpleValueMappers.number(false, 0, Integer::parseInt), validator);
        }
    };
    public static final ValueMapper<Long, JsonPrimitive> LONG = new ValueMapper<Long, JsonPrimitive>(){

        @Override
        public Class<Long> type() {
            return Long.class;
        }

        @Override
        public Class<JsonPrimitive> element() {
            return JsonPrimitive.class;
        }

        @Override
        public Long fromJson(JsonPrimitive json) {
            return json.getAsLong();
        }

        @Override
        public JsonPrimitive toJson(Long value) {
            return new JsonPrimitive((Number)value);
        }

        @Override
        public Long fromNetwork(FriendlyByteBuf buffer) {
            return buffer.m_130258_();
        }

        @Override
        public void toNetwork(Long value, FriendlyByteBuf buffer) {
            buffer.m_130103_(value.longValue());
        }

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public ConfigEditor<Long> createEditor(ValidatorInfo<?> validator) {
            LongRange range = validator.value(LongRange.class);
            if (range != null && range.min() != Long.MIN_VALUE && range.max() != Long.MAX_VALUE) {
                return ConfigEditor.slider(value -> (double)(value - range.min()) / (double)(range.max() - range.min()), value -> Math.round(Mth.m_14139_((double)value, (double)range.min(), (double)range.max())));
            }
            return ConfigEditor.input(SimpleValueMappers.number(false, 0L, Long::parseLong), validator);
        }
    };
    public static final ValueMapper<Float, JsonPrimitive> FLOAT = new ValueMapper<Float, JsonPrimitive>(){

        @Override
        public Class<Float> type() {
            return Float.class;
        }

        @Override
        public Class<JsonPrimitive> element() {
            return JsonPrimitive.class;
        }

        @Override
        public Float fromJson(JsonPrimitive json) {
            return Float.valueOf(json.getAsFloat());
        }

        @Override
        public JsonPrimitive toJson(Float value) {
            return new JsonPrimitive((Number)value);
        }

        @Override
        public Float fromNetwork(FriendlyByteBuf buffer) {
            return Float.valueOf(buffer.readFloat());
        }

        @Override
        public void toNetwork(Float value, FriendlyByteBuf buffer) {
            buffer.writeFloat(value.floatValue());
        }

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public ConfigEditor<Float> createEditor(ValidatorInfo<?> validator) {
            FloatRange range = validator.value(FloatRange.class);
            if (range != null && Float.isFinite(range.min()) && Float.isFinite(range.max())) {
                return ConfigEditor.slider(value -> (double)(value.floatValue() - range.min()) / (double)(range.max() - range.min()), value -> Float.valueOf(BigDecimal.valueOf(Mth.m_14139_((double)value, (double)range.min(), (double)range.max())).setScale(3, RoundingMode.HALF_UP).floatValue()));
            }
            return ConfigEditor.input(SimpleValueMappers.number(true, Float.valueOf(0.0f), Float::parseFloat), validator);
        }
    };
    public static final ValueMapper<Double, JsonPrimitive> DOUBLE = new ValueMapper<Double, JsonPrimitive>(){

        @Override
        public Class<Double> type() {
            return Double.class;
        }

        @Override
        public Class<JsonPrimitive> element() {
            return JsonPrimitive.class;
        }

        @Override
        public Double fromJson(JsonPrimitive json) {
            return json.getAsDouble();
        }

        @Override
        public JsonPrimitive toJson(Double value) {
            return new JsonPrimitive((Number)value);
        }

        @Override
        public Double fromNetwork(FriendlyByteBuf buffer) {
            return buffer.readDouble();
        }

        @Override
        public void toNetwork(Double value, FriendlyByteBuf buffer) {
            buffer.writeDouble(value.doubleValue());
        }

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public ConfigEditor<Double> createEditor(ValidatorInfo<?> validator) {
            DoubleRange range = validator.value(DoubleRange.class);
            if (range != null && Double.isFinite(range.min()) && Double.isFinite(range.max())) {
                return ConfigEditor.slider(value -> (value - range.min()) / (range.max() - range.min()), value -> BigDecimal.valueOf(Mth.m_14139_((double)value, (double)range.min(), (double)range.max())).setScale(3, RoundingMode.HALF_UP).doubleValue());
            }
            return ConfigEditor.input(SimpleValueMappers.number(true, 0.0, Double::parseDouble), validator);
        }
    };
    public static final ValueMapper<String, JsonPrimitive> STRING = new ValueMapper<String, JsonPrimitive>(){

        @Override
        public Class<String> type() {
            return String.class;
        }

        @Override
        public Class<JsonPrimitive> element() {
            return JsonPrimitive.class;
        }

        @Override
        public String fromJson(JsonPrimitive json) {
            return json.getAsString();
        }

        @Override
        public JsonPrimitive toJson(String value) {
            return new JsonPrimitive(value);
        }

        @Override
        public String fromNetwork(FriendlyByteBuf buffer) {
            return buffer.m_130277_();
        }

        @Override
        public void toNetwork(String value, FriendlyByteBuf buffer) {
            buffer.m_130070_(value);
        }

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public ConfigEditor<String> createEditor(ValidatorInfo<?> validator) {
            return ConfigEditor.input(validator);
        }
    };

    private static <T> InputProperties<T> number(final boolean floating, final T defaultValue, final Function<String, T> parse) {
        return new InputProperties<T>(){

            @Override
            public T defaultValue() {
                return defaultValue;
            }

            @Override
            public String toString(T t) {
                if (floating) {
                    return t.toString().replace('E', 'e');
                }
                return t.toString();
            }

            @Override
            public T valueOf(String str) {
                return parse.apply(str);
            }

            @Override
            public boolean canInputChar(char chr) {
                if (floating) {
                    return chr >= '0' && chr <= '9' || chr == '-' || chr == 'e' || chr == 'E' || chr == '.';
                }
                return chr >= '0' && chr <= '9' || chr == '-';
            }

            @Override
            public boolean isValid(String str) {
                try {
                    parse.apply(str);
                    return true;
                }
                catch (NumberFormatException e) {
                    return false;
                }
            }
        };
    }
}

