/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.libx.codec;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import net.minecraft.core.HolderLookup;
import net.minecraft.resources.RegistryOps;

public class CodecOps<E> {
    private final Class<E> baseClass;
    private final DynamicOps<E> ops;

    public CodecOps(Class<E> baseClass, DynamicOps<E> ops) {
        this.baseClass = baseClass;
        this.ops = ops;
    }

    public <T> E write(Codec<T> codec, T value) {
        return this.write(codec, value, this.baseClass);
    }

    public <T> E write(Codec<T> codec, T value, HolderLookup.Provider registries) {
        return this.write(codec, value, this.baseClass, registries);
    }

    public <T, R extends E> R write(Codec<T> codec, T value, Class<R> resultType) {
        return CodecOps.encodeWith(codec, value, this.ops, this.baseClass, resultType);
    }

    public <T, R extends E> R write(Codec<T> codec, T value, Class<R> resultType, HolderLookup.Provider registries) {
        return CodecOps.encodeWith(codec, value, RegistryOps.m_255058_(this.ops, (HolderLookup.Provider)registries), this.baseClass, resultType);
    }

    public <T> T read(Codec<T> codec, E value) {
        return CodecOps.decodeWith(codec, value, this.ops);
    }

    public <T> T read(Codec<T> codec, E value, HolderLookup.Provider registries) {
        return CodecOps.decodeWith(codec, value, RegistryOps.m_255058_(this.ops, (HolderLookup.Provider)registries));
    }

    private static <T, E, R extends E> R encodeWith(Codec<T> codec, T value, DynamicOps<E> ops, Class<E> baseClass, Class<R> resultType) {
        return (R)codec.encodeStart(ops, value).flatMap(result -> {
            if (resultType == baseClass || resultType.isAssignableFrom(result.getClass())) {
                return DataResult.success((Object)result);
            }
            return DataResult.error(() -> "Invalid type while encoding with value " + value + " with " + codec + ": Expected " + resultType + ", got " + result.getClass());
        }).getOrThrow(false, msg -> {});
    }

    private static <T, E> T decodeWith(Codec<T> codec, E value, DynamicOps<E> ops) {
        return (T)codec.decode(ops, value).map(Pair::getFirst).getOrThrow(false, msg -> {});
    }
}

