/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.cucumber.item.tool;

import com.blakebr0.cucumber.event.ScytheHarvestCropEvent;
import com.blakebr0.cucumber.helper.CropHelper;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.NetherWartBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.Event;

public class BaseScytheItem
extends SwordItem {
    private final float attackDamage;
    private final float attackSpeed;
    private final int range;

    public BaseScytheItem(Tier tier, int range) {
        this(tier, range, p -> p);
    }

    public BaseScytheItem(Tier tier, int range, Function<Item.Properties, Item.Properties> properties) {
        super(tier, 4, -2.8f, properties.apply(new Item.Properties()));
        this.attackDamage = 4.0f;
        this.attackSpeed = -2.8f;
        this.range = range;
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Player player = context.m_43723_();
        if (player == null) {
            return InteractionResult.FAIL;
        }
        BlockPos pos = context.m_8083_();
        InteractionHand hand = context.m_43724_();
        Direction face = context.m_43719_();
        ItemStack stack = player.m_21120_(hand);
        if (!player.m_36204_(pos.m_121945_(face), face, stack)) {
            return InteractionResult.FAIL;
        }
        Level level = context.m_43725_();
        if (level.m_5776_()) {
            return InteractionResult.SUCCESS;
        }
        AtomicBoolean harvested = new AtomicBoolean();
        BlockPos.m_121940_((BlockPos)pos.m_7918_(-this.range, 0, -this.range), (BlockPos)pos.m_7918_(this.range, 0, this.range)).forEach(aoePos -> {
            if (stack.m_41619_()) {
                return;
            }
            BlockState state = level.m_8055_(aoePos);
            ScytheHarvestCropEvent event = new ScytheHarvestCropEvent((LevelAccessor)level, aoePos.m_7949_(), state, stack, player);
            if (MinecraftForge.EVENT_BUS.post((Event)event)) {
                return;
            }
            Block block = state.m_60734_();
            if (block instanceof CropBlock) {
                CropBlock crop = (CropBlock)block;
                Item seed = CropHelper.getSeedsItem((Block)crop);
                if (crop.m_52307_(state) && seed != null) {
                    BaseScytheItem.harvest(player, level, aoePos.m_7949_(), state, crop.m_52289_(0), seed, stack, harvested);
                }
            }
            if (block instanceof NetherWartBlock && (Integer)state.m_61143_((Property)NetherWartBlock.f_54967_) == 3) {
                BaseScytheItem.harvest(player, level, aoePos.m_7949_(), state, (BlockState)state.m_61124_((Property)NetherWartBlock.f_54967_, (Comparable)Integer.valueOf(0)), Items.f_42588_, stack, harvested);
            }
        });
        if (harvested.get()) {
            level.m_5594_(null, pos, SoundEvents.f_11838_, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
        return InteractionResult.SUCCESS;
    }

    public boolean onLeftClickEntity(ItemStack stack, Player player, Entity entity) {
        if (player.m_36403_(0.5f) >= 0.95f) {
            Level level = player.m_9236_();
            double range = this.range >= 2 ? 1.0 + (double)(this.range - 1) * 0.25 : 1.0;
            List entities = level.m_45976_(LivingEntity.class, entity.m_20191_().m_82377_(range, 0.25, range));
            Optional<Optional> damageType = level.m_9598_().m_254861_(Registries.f_268580_).map(r -> r.m_254902_(DamageTypes.f_268464_));
            for (LivingEntity aoeEntity : entities) {
                float attackDamage;
                DamageSource source;
                boolean success;
                if (aoeEntity == player || aoeEntity == entity || player.m_7307_(entity) || !damageType.isPresent() || !damageType.get().isPresent() || !(success = ForgeHooks.onLivingAttack((LivingEntity)aoeEntity, (DamageSource)(source = new DamageSource((Holder)damageType.get().get(), (Entity)player)), (float)(attackDamage = this.getAttackDamage() * 0.67f)))) continue;
                aoeEntity.m_147240_((double)0.4f, (double)Mth.m_14031_((float)(player.m_146908_() * ((float)Math.PI / 180))), (double)(-Mth.m_14089_((float)(player.m_146908_() * ((float)Math.PI / 180)))));
                aoeEntity.m_6469_(source, attackDamage);
            }
            level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12317_, player.m_5720_(), 1.0f, 1.0f);
            player.m_36346_();
        }
        return super.onLeftClickEntity(stack, player, entity);
    }

    public float getAttackDamage() {
        return this.attackDamage + this.m_43314_().m_6631_();
    }

    public float getAttackSpeed() {
        return this.attackSpeed;
    }

    private static void harvest(Player player, Level level, BlockPos pos, BlockState state, BlockState newState, Item item, ItemStack stack, AtomicBoolean harvested) {
        if (MinecraftForge.EVENT_BUS.post((Event)new BlockEvent.BreakEvent(level, pos, state, player))) {
            return;
        }
        BaseScytheItem.handleDrops(state, level, pos, (ItemLike)item);
        stack.m_41622_(1, (LivingEntity)player, entity -> entity.m_21190_(player.m_7655_()));
        level.m_46597_(pos, newState);
        harvested.set(true);
    }

    private static void handleDrops(BlockState state, Level level, BlockPos pos, ItemLike seed) {
        List drops = Block.m_49869_((BlockState)state, (ServerLevel)((ServerLevel)level), (BlockPos)pos, (BlockEntity)level.m_7702_(pos));
        for (ItemStack drop : drops) {
            Item item = drop.m_41720_();
            if (drop.m_41619_() || item != seed) continue;
            drop.m_41774_(1);
            break;
        }
        for (ItemStack drop : drops) {
            if (drop.m_41619_()) continue;
            Block.m_49840_((Level)level, (BlockPos)pos, (ItemStack)drop);
        }
    }
}

