/*
 * Decompiled with CFR 0.152.
 */
package com.smashingmods.alchemylib.api.blockentity.container;

import com.smashingmods.chemlib.api.Chemical;
import com.smashingmods.chemlib.api.ChemicalItemType;
import com.smashingmods.chemlib.common.items.ChemicalItem;
import com.smashingmods.chemlib.common.items.CompoundItem;
import com.smashingmods.chemlib.common.items.ElementItem;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.LiteralContents;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.StringUtils;

public class RecipeDisplayUtil {
    public static List<Component> getItemTooltipComponent(ItemStack pItemStack, MutableComponent pComponent) {
        ArrayList<Component> components = new ArrayList<Component>();
        String namespace = StringUtils.capitalize((String)Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)pItemStack.m_41720_())).m_135827_());
        components.add((Component)pComponent.m_130944_(new ChatFormatting[]{ChatFormatting.UNDERLINE, ChatFormatting.YELLOW}));
        components.add((Component)MutableComponent.m_237204_((ComponentContents)new LiteralContents(String.format("%dx %s", pItemStack.m_41613_(), pItemStack.m_41720_().m_41466_().getString()))));
        Item item = pItemStack.m_41720_();
        if (item instanceof Chemical) {
            ChemicalItem chemicalItem;
            Chemical chemical = (Chemical)item;
            String abbreviation = chemical.getAbbreviation();
            if (chemical instanceof ElementItem) {
                ElementItem element = (ElementItem)chemical;
                components.add((Component)MutableComponent.m_237204_((ComponentContents)new LiteralContents(String.format("%s (%d)", abbreviation, element.getAtomicNumber()))).m_130940_(ChatFormatting.DARK_AQUA));
                components.add((Component)MutableComponent.m_237204_((ComponentContents)new LiteralContents(element.getGroupName())).m_130940_(ChatFormatting.GRAY));
            } else if (chemical instanceof ChemicalItem && !(chemicalItem = (ChemicalItem)chemical).getItemType().equals((Object)ChemicalItemType.COMPOUND)) {
                ElementItem element = (ElementItem)chemicalItem.getChemical();
                components.add((Component)MutableComponent.m_237204_((ComponentContents)new LiteralContents(String.format("%s (%d)", chemicalItem.getAbbreviation(), element.getAtomicNumber()))).m_130940_(ChatFormatting.DARK_AQUA));
                components.add((Component)MutableComponent.m_237204_((ComponentContents)new LiteralContents(element.getGroupName())).m_130940_(ChatFormatting.GRAY));
            } else if (chemical instanceof CompoundItem) {
                components.add((Component)MutableComponent.m_237204_((ComponentContents)new LiteralContents(abbreviation)).m_130940_(ChatFormatting.DARK_AQUA));
            }
        }
        components.add((Component)MutableComponent.m_237204_((ComponentContents)new LiteralContents(namespace)).m_130940_(ChatFormatting.BLUE));
        return components;
    }
}

