/*
 * Decompiled with CFR 0.152.
 */
package mob_grinding_utils;

import java.awt.Color;
import mob_grinding_utils.ModBlocks;
import mob_grinding_utils.blocks.BlockDelightfulDirt;
import mob_grinding_utils.blocks.BlockDreadfulDirt;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.color.block.BlockColors;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.client.color.item.ItemColors;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class ModColourManager {
    private static final Minecraft MINECRAFT = Minecraft.m_91087_();

    public static void registerColourHandlers() {
        BlockColors blockColors = MINECRAFT.m_91298_();
        ItemColors itemColors = MINECRAFT.getItemColors();
        ModColourManager.registerBlockColourHandlers(blockColors);
        ModColourManager.registerItemColourHandlers(blockColors, itemColors);
    }

    private static void registerBlockColourHandlers(BlockColors blockColors) {
        BlockColor dreadfulDirtColour = (state, blockAccess, pos, tintIndex) -> {
            if (blockAccess != null && pos != null) {
                return new Color(153, 50, 153).getRGB() & 0xFFFFFF;
            }
            return new Color(153, 50, 153).getRGB() & 0xFFFFFF;
        };
        BlockColor delightfulDirtColour = (state, blockAccess, pos, tintIndex) -> {
            if (blockAccess != null && pos != null) {
                return new Color(190, 255, 0).getRGB() & 0xFFFFFF;
            }
            return new Color(190, 255, 0).getRGB() & 0xFFFFFF;
        };
        blockColors.m_92589_(dreadfulDirtColour, new Block[]{ModBlocks.DREADFUL_DIRT.getBlock()});
        blockColors.m_92589_(delightfulDirtColour, new Block[]{ModBlocks.DELIGHTFUL_DIRT.getBlock()});
    }

    private static void registerItemColourHandlers(BlockColors blockColors, ItemColors itemColors) {
        ItemColor itemBlockColourHandler = (stack, tintIndex) -> {
            BlockState state = ((BlockItem)stack.m_41720_()).m_40614_().m_49966_();
            if (state.m_60734_() instanceof BlockDreadfulDirt) {
                return blockColors.m_92577_(state, null, null, tintIndex);
            }
            if (state.m_60734_() instanceof BlockDelightfulDirt) {
                return blockColors.m_92577_(state, null, null, tintIndex);
            }
            return -1;
        };
        itemColors.m_92689_(itemBlockColourHandler, new ItemLike[]{ModBlocks.DREADFUL_DIRT.getItem()});
        itemColors.m_92689_(itemBlockColourHandler, new ItemLike[]{ModBlocks.DELIGHTFUL_DIRT.getItem()});
    }
}

