/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.common.fluid;

import cofh.lib.api.StorageGroup;
import cofh.lib.api.block.entity.ITileCallback;
import cofh.lib.common.fluid.FluidStorageCoFH;
import cofh.lib.common.fluid.SimpleFluidHandler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class SimpleTankInv
extends SimpleFluidHandler {
    protected String tag;
    protected IFluidHandler allHandler;

    public SimpleTankInv(@Nullable ITileCallback tile) {
        this(tile, "TankInv");
    }

    public SimpleTankInv(@Nullable ITileCallback tile, @Nonnull String tag) {
        this(tile, Collections.emptyList(), tag);
    }

    public SimpleTankInv(@Nullable ITileCallback tile, @Nonnull List<FluidStorageCoFH> tanks, @Nonnull String tag) {
        super(tile, tanks);
        this.tag = tag;
    }

    public void addSlot(FluidStorageCoFH tank) {
        if (this.allHandler != null) {
            return;
        }
        this.tanks.add(tank);
    }

    public void clear() {
        for (FluidStorageCoFH tank : this.tanks) {
            tank.setFluidStack(FluidStack.EMPTY);
        }
    }

    public void set(int tank, FluidStack stack) {
        ((FluidStorageCoFH)this.tanks.get(tank)).setFluidStack(stack);
    }

    public FluidStack get(int tank) {
        return ((FluidStorageCoFH)this.tanks.get(tank)).getFluidStack();
    }

    public FluidStorageCoFH getTank(int tank) {
        return (FluidStorageCoFH)this.tanks.get(tank);
    }

    public SimpleTankInv read(CompoundTag nbt) {
        for (FluidStorageCoFH tank : this.tanks) {
            tank.setFluidStack(FluidStack.EMPTY);
        }
        ListTag list = nbt.m_128437_(this.tag, 10);
        for (int i = 0; i < list.size(); ++i) {
            CompoundTag tag = list.m_128728_(i);
            byte tank = tag.m_128445_("Tank");
            if (tank < 0 || tank >= this.tanks.size()) continue;
            ((FluidStorageCoFH)this.tanks.get(tank)).read(tag);
        }
        return this;
    }

    public CompoundTag write(CompoundTag nbt) {
        if (this.tanks.size() <= 0) {
            return nbt;
        }
        ListTag list = new ListTag();
        for (int i = 0; i < this.tanks.size(); ++i) {
            if (((FluidStorageCoFH)this.tanks.get(i)).isEmpty()) continue;
            CompoundTag tag = new CompoundTag();
            tag.m_128344_("Tank", (byte)i);
            ((FluidStorageCoFH)this.tanks.get(i)).write(tag);
            list.add((Object)tag);
        }
        if (!list.isEmpty()) {
            nbt.m_128365_(this.tag, (Tag)list);
        }
        return nbt;
    }

    public IFluidHandler getHandler(StorageGroup group) {
        if (this.allHandler == null) {
            ((ArrayList)this.tanks).trimToSize();
            this.allHandler = new SimpleFluidHandler(this.callback, this.tanks);
        }
        return this.allHandler;
    }
}

