/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.common.block;

import cofh.lib.common.block.CropBlockCoFH;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.StemBlock;
import net.minecraft.world.level.block.StemGrownBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.PlantType;

public class StemBlockCoFH
extends StemBlock {
    protected final PlantType type;
    protected int growLight;
    protected float growMod;
    protected Supplier<Block> cropBlock = () -> Blocks.f_50186_;
    protected Supplier<Item> seed = () -> Items.f_42578_;

    public StemBlockCoFH(BlockBehaviour.Properties builder, Supplier<Item> seed, PlantType type, int growLight, float growMod) {
        super((StemGrownBlock)Blocks.f_50186_, seed, builder);
        this.type = type;
        this.growLight = growLight;
        this.growMod = growMod;
    }

    public StemBlockCoFH(BlockBehaviour.Properties builder, Supplier<Item> seed, int growLight, float growMod) {
        this(builder, seed, PlantType.CROP, growLight, growMod);
    }

    public StemBlockCoFH(BlockBehaviour.Properties builder, Supplier<Item> seed) {
        this(builder, seed, PlantType.CROP, 9, 1.0f);
    }

    public StemBlockCoFH crop(Supplier<Block> crop) {
        this.cropBlock = crop;
        return this;
    }

    public void m_213898_(BlockState state, ServerLevel worldIn, BlockPos pos, RandomSource rand) {
        float growthChance;
        if (!worldIn.isAreaLoaded(pos, 1)) {
            return;
        }
        if (worldIn.m_45524_(pos, 0) >= this.growLight && ForgeHooks.onCropsGrowPre((Level)worldIn, (BlockPos)pos, (BlockState)state, (rand.m_188503_((int)(25.0f / (growthChance = Math.max(CropBlockCoFH.getGrowthChanceProxy((Block)this, (BlockGetter)worldIn, pos) * this.growMod, 0.1f))) + 1) == 0 ? 1 : 0) != 0)) {
            int i = (Integer)state.m_61143_((Property)f_57013_);
            if (i < 7) {
                worldIn.m_7731_(pos, (BlockState)state.m_61124_((Property)f_57013_, (Comparable)Integer.valueOf(i + 1)), 2);
            } else {
                Direction direction = Direction.Plane.HORIZONTAL.m_235690_(rand);
                BlockPos blockpos = pos.m_121945_(direction);
                BlockState soil = worldIn.m_8055_(blockpos.m_7495_());
                Block block = soil.m_60734_();
                if (worldIn.m_46859_(blockpos) && (soil.canSustainPlant((BlockGetter)worldIn, blockpos.m_7495_(), Direction.UP, (IPlantable)this) || block == Blocks.f_50093_ || block == Blocks.f_50493_ || block == Blocks.f_50546_ || block == Blocks.f_50599_ || block == Blocks.f_50440_)) {
                    worldIn.m_46597_(blockpos, this.cropBlock.get().m_49966_());
                    worldIn.m_46597_(pos, (BlockState)((StemGrownBlock)this.cropBlock.get()).m_7810_().m_49966_().m_61124_((Property)HorizontalDirectionalBlock.f_54117_, (Comparable)direction));
                }
            }
            ForgeHooks.onCropsGrowPost((Level)worldIn, (BlockPos)pos, (BlockState)state);
        }
    }
}

