/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.client.model;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.math.Transformation;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockElement;
import net.minecraft.client.renderer.block.model.BlockElementFace;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraftforge.client.model.IModelBuilder;
import net.minecraftforge.client.model.SimpleModelState;
import net.minecraftforge.client.model.geometry.IGeometryBakingContext;
import net.minecraftforge.client.model.geometry.IGeometryLoader;
import net.minecraftforge.client.model.geometry.SimpleUnbakedGeometry;

public class ElementsModelWrapped
extends SimpleUnbakedGeometry<ElementsModelWrapped> {
    private final List<BlockElement> elements;

    private ElementsModelWrapped(List<BlockElement> elements) {
        this.elements = elements;
    }

    public void addQuads(IGeometryBakingContext context, IModelBuilder<?> modelBuilder, ModelBaker bakery, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelState, ResourceLocation modelLocation) {
        Transformation rootTransform = context.getRootTransform();
        if (!rootTransform.isIdentity()) {
            modelState = new SimpleModelState(modelState.m_6189_().m_121096_(rootTransform), modelState.m_7538_());
        }
        for (BlockElement element : this.elements) {
            for (Direction direction : element.f_111310_.keySet()) {
                BlockElementFace face = (BlockElementFace)element.f_111310_.get(direction);
                TextureAtlasSprite sprite = spriteGetter.apply(context.getMaterial(face.f_111356_));
                BakedQuad quad = BlockModel.m_111437_((BlockElement)element, (BlockElementFace)face, (TextureAtlasSprite)sprite, (Direction)direction, (ModelState)modelState, (ResourceLocation)modelLocation);
                if (face.f_111354_ == null) {
                    modelBuilder.addUnculledFace(quad);
                    continue;
                }
                modelBuilder.addCulledFace(modelState.m_6189_().rotateTransform(face.f_111354_), quad);
            }
        }
    }

    public static final class Loader
    implements IGeometryLoader<ElementsModelWrapped> {
        public static final Loader INSTANCE = new Loader();

        private Loader() {
        }

        public ElementsModelWrapped read(JsonObject jsonObject, JsonDeserializationContext deserializationContext) throws JsonParseException {
            if (!jsonObject.has("elements")) {
                throw new JsonParseException("An element model must have an \"elements\" member.");
            }
            ArrayList<BlockElement> elements = new ArrayList<BlockElement>();
            for (JsonElement element : GsonHelper.m_13933_((JsonObject)jsonObject, (String)"elements")) {
                elements.add((BlockElement)deserializationContext.deserialize(element, BlockElement.class));
            }
            return new ElementsModelWrapped(elements);
        }
    }
}

