/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.library.events;

import com.lothrazar.library.FutureLibMod;
import com.lothrazar.library.cap.player.PlayerCapProvider;
import com.lothrazar.library.cap.player.PlayerCapabilityStorage;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class CapabilityEvents {
    public CapabilityEvents() {
        MinecraftForge.EVENT_BUS.addGenericListener(Entity.class, CapabilityEvents::onAttachCapabilitiesPlayer);
    }

    @SubscribeEvent
    public void onPlayerCloned(PlayerEvent.Clone event) {
        if (event.isWasDeath()) {
            event.getOriginal().getCapability(PlayerCapProvider.PLAYERCAP).ifPresent(oldStore -> event.getEntity().getCapability(PlayerCapProvider.PLAYERCAP).ifPresent(newStore -> newStore.copyFrom((PlayerCapabilityStorage)oldStore)));
        }
    }

    @SubscribeEvent
    public void onRegisterCapabilities(RegisterCapabilitiesEvent event) {
        event.register(PlayerCapabilityStorage.class);
        FutureLibMod.LOGGER.info("RegisterCapabilitiesEvent success for ManaManager");
    }

    public static void onAttachCapabilitiesPlayer(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof Player && !((Entity)event.getObject()).getCapability(PlayerCapProvider.PLAYERCAP).isPresent()) {
            event.addCapability(new ResourceLocation("flib", "data"), (ICapabilityProvider)new PlayerCapProvider());
            FutureLibMod.LOGGER.info("CapabilityRegistry success for data");
        }
    }
}

