/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.amendments.common.network;

import net.mehvahdjukaar.amendments.common.block.BoilingWaterCauldronBlock;
import net.mehvahdjukaar.amendments.common.block.ModCauldronBlock;
import net.mehvahdjukaar.amendments.common.tile.LiquidCauldronBlockTile;
import net.mehvahdjukaar.amendments.reg.ModRegistry;
import net.mehvahdjukaar.moonlight.api.platform.network.ChannelHandler;
import net.mehvahdjukaar.moonlight.api.platform.network.Message;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public record ClientBoundPlaySplashParticlesMessage(Vec3 hitPos, double speed, float width) implements Message
{
    public ClientBoundPlaySplashParticlesMessage(FriendlyByteBuf buffer) {
        this(new Vec3(buffer.readDouble(), buffer.readDouble(), buffer.readDouble()), buffer.readDouble(), buffer.readFloat());
    }

    public void writeToBuffer(FriendlyByteBuf friendlyByteBuf) {
        friendlyByteBuf.writeDouble(this.hitPos.f_82479_);
        friendlyByteBuf.writeDouble(this.hitPos.f_82480_);
        friendlyByteBuf.writeDouble(this.hitPos.f_82481_);
        friendlyByteBuf.writeDouble(this.speed);
        friendlyByteBuf.writeFloat(this.width);
    }

    public void handle(ChannelHandler.Context context) {
        this.doOnClient();
    }

    /*
     * Enabled aggressive block sorting
     */
    @OnlyIn(value=Dist.CLIENT)
    public void doOnClient() {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        BlockPos pos = BlockPos.m_274446_((Position)this.hitPos);
        BlockState state = level.m_8055_(pos);
        Block block = state.m_60734_();
        if (block instanceof ModCauldronBlock) {
            ModCauldronBlock mc = (ModCauldronBlock)block;
            block = level.m_7702_(pos);
            if (block instanceof LiquidCauldronBlockTile) {
                LiquidCauldronBlockTile tile = (LiquidCauldronBlockTile)block;
                int color = tile.getSoftFluidTank().getCachedParticleColor((BlockAndTintGetter)level, pos);
                int light = tile.getSoftFluidTank().getFluidValue().getEmissivity();
                this.playSplashAnimation((Level)level, pos, color, light);
                return;
            }
        }
        if (!(state.m_60734_() instanceof BoilingWaterCauldronBlock)) return;
        int color = BoilingWaterCauldronBlock.getWaterColor(state, (BlockAndTintGetter)level, pos, 1);
        this.playSplashAnimation((Level)level, pos, color, 0);
    }

    public void playSplashAnimation(Level level, BlockPos pos, int color, int light) {
        RandomSource rand = level.f_46441_;
        float radius = 1.5f;
        ClientBoundPlaySplashParticlesMessage.spawnSplashParticles(level, this.hitPos, pos, rand, color, light, (ParticleOptions)ModRegistry.BOILING_PARTICLE.get(), radius, this.width);
        ClientBoundPlaySplashParticlesMessage.spawnSplashParticles(level, this.hitPos, pos, rand, color, light, (ParticleOptions)ModRegistry.SPLASH_PARTICLE.get(), radius, this.width);
    }

    public static void spawnSplashParticles(Level level, Vec3 hitPos, BlockPos pos, RandomSource rand, int color, int light, ParticleOptions particleOptions, float radius, float width) {
        float mx = (float)pos.m_123341_() + 0.125f;
        float Mx = (float)(pos.m_123341_() + 1) - 0.125f;
        float mz = (float)pos.m_123343_() + 0.125f;
        float Mz = (float)(pos.m_123343_() + 1) - 0.125f;
        double surface = hitPos.m_7098_();
        int i = 0;
        while ((float)i < 1.0f + width * 20.0f) {
            double x = hitPos.m_7096_() + (rand.m_188500_() - 0.5) * (double)width * (double)radius;
            double z = hitPos.m_7094_() + (rand.m_188500_() - 0.5) * (double)width * (double)radius;
            if (x >= (double)mx && x <= (double)Mx && z >= (double)mz && z <= (double)Mz) {
                level.m_7106_(particleOptions, x, surface, z, (double)color, surface, (double)light);
            }
            ++i;
        }
    }
}

