/*
 * Decompiled with CFR 0.152.
 */
package dev.uncandango.alltheleaks.commands;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.gson.JsonElement;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.datafixers.util.Pair;
import com.sun.management.HotSpotDiagnosticMXBean;
import dev.uncandango.alltheleaks.AllTheLeaks;
import java.lang.management.ManagementFactory;
import java.util.HashSet;
import javax.management.MBeanServer;
import net.minecraft.client.Minecraft;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;

public final class ATLCommands {
    public static void registerCommands(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext context) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"atl").then(Commands.m_82127_((String)"run_full_gc").executes(cmd -> ATLCommands.runGc((CommandSourceStack)cmd.getSource())))).then(Commands.m_82127_((String)"dump_ingredient_duplicates").executes(cmd -> ATLCommands.dumpIngredientDuplicates((CommandSourceStack)cmd.getSource()))));
    }

    public static int runGc(CommandSourceStack source) {
        try {
            MBeanServer server = ManagementFactory.getPlatformMBeanServer();
            HotSpotDiagnosticMXBean hotSpotDiagnosticMXBean = ManagementFactory.newPlatformMXBeanProxy(server, "com.sun.management:type=HotSpotDiagnostic", HotSpotDiagnosticMXBean.class);
            boolean gcDisabled = Boolean.parseBoolean(hotSpotDiagnosticMXBean.getVMOption("DisableExplicitGC").getValue());
            if (gcDisabled) {
                source.m_81352_((Component)Component.m_237113_((String)"Explicit GC is disabled, remove arguments -XX:+DisableExplicitGC"));
                return 0;
            }
        }
        catch (Exception e) {
            AllTheLeaks.LOGGER.error("Error while instancing MXBean: {}", (Object)e.getMessage());
            return 0;
        }
        System.gc();
        return 1;
    }

    public static int dumpIngredientDuplicates(CommandSourceStack source) {
        HashMultimap recipeJsonToIngredientMap = HashMultimap.create();
        Minecraft.m_91087_().f_91073_.m_7465_().m_44051_().forEach(arg_0 -> ATLCommands.lambda$dumpIngredientDuplicates$2((Multimap)recipeJsonToIngredientMap, arg_0));
        recipeJsonToIngredientMap.asMap().forEach((key, value) -> {
            HashSet innerIngredientSet = new HashSet();
            value.forEach(pair -> innerIngredientSet.add((Ingredient)pair.getFirst()));
            if (innerIngredientSet.size() > 1) {
                AllTheLeaks.LOGGER.warn("Ingredients with the same json: {}", key);
                innerIngredientSet.forEach(ingredient -> AllTheLeaks.LOGGER.warn("  - {}", ingredient));
            }
        });
        return 1;
    }

    private static /* synthetic */ void lambda$dumpIngredientDuplicates$2(Multimap recipeJsonToIngredientMap, Recipe recipe) {
        NonNullList ingredients = recipe.m_7527_();
        for (Ingredient ingredient : ingredients) {
            JsonElement jsonElement = ingredient.m_43942_();
            ResourceLocation recipeId = recipe.m_6423_();
            Pair key = Pair.of((Object)ingredient, (Object)recipeId);
            recipeJsonToIngredientMap.put((Object)jsonElement, (Object)key);
        }
    }
}

