/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.structurecompass.network.message;

import com.mrbysco.structurecompass.items.StructureCompassItem;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;

public class SetStructureMessage {
    public InteractionHand hand;
    public ResourceLocation structureLocation;

    public SetStructureMessage(InteractionHand hand, ResourceLocation structureLocation) {
        this.hand = hand;
        this.structureLocation = structureLocation;
    }

    public void encode(FriendlyByteBuf buf) {
        buf.writeInt(this.hand == InteractionHand.MAIN_HAND ? 0 : 1);
        buf.m_130085_(this.structureLocation);
    }

    public static SetStructureMessage decode(FriendlyByteBuf packetBuffer) {
        return new SetStructureMessage(packetBuffer.readInt() == 0 ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND, packetBuffer.m_130281_());
    }

    public void handle(Supplier<NetworkEvent.Context> context) {
        NetworkEvent.Context ctx = context.get();
        ctx.enqueueWork(() -> {
            ItemStack stack;
            if (ctx.getDirection().getReceptionSide().isServer() && ctx.getSender() != null && (stack = ctx.getSender().m_21120_(this.hand)).m_41720_() instanceof StructureCompassItem) {
                CompoundTag tag = stack.m_41784_();
                tag.m_128359_("structurecompass:structureName", this.structureLocation.toString());
                stack.m_41751_(tag);
            }
        });
        ctx.setPacketHandled(true);
    }
}

