/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.structurecompass.datagen;

import com.mrbysco.structurecompass.init.StructureItems;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.tags.ItemTagsProvider;
import net.minecraft.data.tags.TagsProvider;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.common.data.BlockTagsProvider;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class CompassDatagen {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        CompletableFuture lookupProvider = event.getLookupProvider();
        ExistingFileHelper helper = event.getExistingFileHelper();
        if (event.includeServer()) {
            generator.addProvider(event.includeServer(), (DataProvider)new CompassRecipeProvider(packOutput));
            CompassBlockTagProvider blockTags = new CompassBlockTagProvider(packOutput, lookupProvider, helper);
            generator.addProvider(event.includeServer(), (DataProvider)blockTags);
            generator.addProvider(event.includeServer(), (DataProvider)new CompassItemTagProvider(packOutput, lookupProvider, (TagsProvider<Block>)blockTags, helper));
        }
    }

    public static class CompassRecipeProvider
    extends RecipeProvider {
        public CompassRecipeProvider(PackOutput packOutput) {
            super(packOutput);
        }

        protected void m_245200_(Consumer<FinishedRecipe> consumer) {
            ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)((ItemLike)StructureItems.STRUCTURE_COMPASS.get())).m_126130_("WTS").m_126130_("O#D").m_126130_("MCP").m_126127_(Character.valueOf('#'), (ItemLike)Items.f_42522_).m_126127_(Character.valueOf('W'), (ItemLike)Blocks.f_50127_).m_126127_(Character.valueOf('T'), (ItemLike)Blocks.f_50352_).m_126127_(Character.valueOf('S'), (ItemLike)Blocks.f_50062_).m_126127_(Character.valueOf('O'), (ItemLike)Blocks.f_49999_).m_126127_(Character.valueOf('D'), (ItemLike)Blocks.f_50004_).m_126127_(Character.valueOf('M'), (ItemLike)Blocks.f_50079_).m_126127_(Character.valueOf('C'), (ItemLike)Blocks.f_50652_).m_126127_(Character.valueOf('P'), (ItemLike)Blocks.f_50143_).m_126132_("has_compass", (CriterionTriggerInstance)CompassRecipeProvider.m_125977_((ItemLike)Items.f_42522_)).m_176498_(consumer);
        }
    }

    public static class CompassBlockTagProvider
    extends BlockTagsProvider {
        public CompassBlockTagProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> lookupProvider, @Nullable ExistingFileHelper existingFileHelper) {
            super(output, lookupProvider, "structurecompass", existingFileHelper);
        }

        protected void m_6577_(HolderLookup.Provider provider) {
        }
    }

    public static class CompassItemTagProvider
    extends ItemTagsProvider {
        public CompassItemTagProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> lookupProvider, TagsProvider<Block> blockTagProvider, ExistingFileHelper existingFileHelper) {
            super(output, lookupProvider, blockTagProvider.m_274426_(), "structurecompass", existingFileHelper);
        }

        public void m_6577_(HolderLookup.Provider lookupProvider) {
            this.m_206424_(ItemTags.f_215866_).m_255245_((Object)((Item)StructureItems.STRUCTURE_COMPASS.get()));
        }
    }
}

