/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.dynamics.grid;

import cofh.lib.util.Constants;
import cofh.requack.util.SneakyUtils;
import cofh.thermal.dynamics.api.grid.IDuct;
import cofh.thermal.dynamics.api.grid.IGridContainer;
import cofh.thermal.dynamics.api.grid.IGridHostUpdateable;
import cofh.thermal.dynamics.api.grid.IGridType;
import cofh.thermal.dynamics.api.grid.ITickableGridNode;
import cofh.thermal.dynamics.api.helper.GridHelper;
import cofh.thermal.dynamics.grid.GridNode;
import cofh.thermal.dynamics.handler.GridContainer;
import com.google.common.graph.ElementOrder;
import com.google.common.graph.EndpointPair;
import com.google.common.graph.GraphBuilder;
import com.google.common.graph.MutableGraph;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectRBTreeMap;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.objects.Object2ObjectRBTreeMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.function.LongFunction;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public abstract class Grid<G extends Grid<G, N>, N extends GridNode<G>>
implements INBTSerializable<CompoundTag> {
    protected static final Logger LOGGER = LogManager.getLogger();
    protected static final boolean DEBUG = Grid.class.desiredAssertionStatus();
    public final MutableGraph<N> nodeGraph = GraphBuilder.undirected().nodeOrder(ElementOrder.unordered()).build();
    protected final Map<BlockPos, N> nodes = new Object2ObjectRBTreeMap();
    protected final Long2ObjectMap<List<N>> nodesPerChunk = new Long2ObjectRBTreeMap();
    protected final LongSet loadedChunks = new LongOpenHashSet();
    protected final Set<BlockPos> updatableHosts = new HashSet<BlockPos>();
    protected final IGridType<G> gridType;
    protected final UUID id;
    protected final Level world;
    public boolean isLoaded;

    protected Grid(IGridType<G> gridType, UUID id, Level world) {
        this.gridType = gridType;
        this.id = id;
        this.world = world;
    }

    public void tick() {
        LongIterator iterator = this.loadedChunks.iterator();
        while (iterator.hasNext()) {
            long loadedChunk = iterator.nextLong();
            List nodes = (List)this.nodesPerChunk.get(loadedChunk);
            if (nodes == null) continue;
            for (GridNode node : nodes) {
                assert (node.isLoaded());
                if (!(node instanceof ITickableGridNode)) continue;
                ((ITickableGridNode)((Object)node)).distributionTick();
            }
        }
    }

    public void checkInvariant() {
        if (!DEBUG) {
            return;
        }
        GridContainer gridContainer = (GridContainer)IGridContainer.getCapability((LevelAccessor)this.world);
        assert (gridContainer != null);
        for (EndpointPair edge : this.nodeGraph.edges()) {
            GridNode u = (GridNode)edge.nodeU();
            GridNode v = (GridNode)edge.nodeV();
            for (BlockPos pos : GridHelper.positionsBetween(u.getPos(), v.getPos())) {
                this.checkPos(pos, gridContainer);
            }
        }
        for (GridNode node : this.nodeGraph.nodes()) {
            long chunkPos = Grid.asChunkLong(node.getPos());
            this.checkPos(node.getPos(), gridContainer);
            assert (node.grid == this);
            assert (this.nodes.get(node.getPos()) == node);
            assert (this.nodesPerChunk.get(chunkPos) != null);
            assert (((List)this.nodesPerChunk.get(chunkPos)).contains(node));
            assert (node.isLoaded() == this.loadedChunks.contains(chunkPos));
        }
        for (BlockPos pos : this.updatableHosts) {
            if (this.world.m_46749_(pos)) assert (GridHelper.getGridHost((BlockGetter)this.world, pos) instanceof IGridHostUpdateable);
        }
    }

    private void checkPos(BlockPos pos, GridContainer gridContainer) {
        if (!this.world.m_46749_(pos)) {
            return;
        }
        IDuct<?, ?> gridHost = GridHelper.getGridHost((BlockGetter)this.world, pos);
        assert (gridHost != null && gridHost.getGrid() == this);
        assert (!(gridHost instanceof IGridHostUpdateable) || this.updatableHosts.contains(gridHost.getHostPos()));
        assert (gridContainer.getGrid(gridHost.getGridType(), pos) == this);
    }

    public boolean onChunkLoad(ChunkAccess chunk) {
        long pos = chunk.m_7697_().m_45588_();
        List nodes = (List)this.nodesPerChunk.get(pos);
        if (nodes == null || nodes.isEmpty()) {
            return false;
        }
        assert (!this.loadedChunks.contains(pos));
        this.loadedChunks.add(pos);
        for (GridNode node : nodes) {
            node.setLoaded(true);
        }
        boolean wasLoaded = !this.isLoaded;
        this.isLoaded = true;
        return wasLoaded;
    }

    public boolean onChunkUnload(ChunkAccess chunk) {
        long pos = chunk.m_7697_().m_45588_();
        List nodes = (List)this.nodesPerChunk.get(pos);
        if (nodes == null || nodes.isEmpty()) {
            return false;
        }
        assert (this.loadedChunks.contains(pos));
        boolean wasLoaded = this.loadedChunks.size() == 1;
        this.loadedChunks.remove(pos);
        for (GridNode node : nodes) {
            node.setLoaded(false);
        }
        assert (!wasLoaded || this.nodes.values().stream().noneMatch(GridNode::isLoaded));
        this.isLoaded = !wasLoaded;
        return wasLoaded;
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        ListTag nodes = new ListTag();
        for (Object node : this.nodeGraph.nodes()) {
            CompoundTag nodeTag = new CompoundTag();
            nodeTag.m_128365_("pos", (Tag)NbtUtils.m_129224_((BlockPos)((GridNode)node).getPos()));
            nodeTag.m_128391_(((GridNode)node).serializeNBT());
            nodes.add((Object)nodeTag);
        }
        tag.m_128365_("nodes", (Tag)nodes);
        ListTag edges = new ListTag();
        for (EndpointPair edge : this.nodeGraph.edges()) {
            CompoundTag edgeTag = new CompoundTag();
            edgeTag.m_128365_("U", (Tag)NbtUtils.m_129224_((BlockPos)((GridNode)edge.nodeU()).getPos()));
            edgeTag.m_128365_("V", (Tag)NbtUtils.m_129224_((BlockPos)((GridNode)edge.nodeV()).getPos()));
            edges.add((Object)edgeTag);
        }
        tag.m_128365_("edges", (Tag)edges);
        ListTag updateable = new ListTag();
        for (BlockPos pos : this.updatableHosts) {
            CompoundTag updateTag = new CompoundTag();
            updateTag.m_128365_("pos", (Tag)NbtUtils.m_129224_((BlockPos)pos));
            updateable.add((Object)updateTag);
        }
        tag.m_128365_("updateable", (Tag)updateable);
        return tag;
    }

    public void deserializeNBT(CompoundTag nbt) {
        ListTag nodes = nbt.m_128437_("nodes", 10);
        for (int i = 0; i < nodes.size(); ++i) {
            CompoundTag nodeTag = nodes.m_128728_(i);
            BlockPos pos = NbtUtils.m_129239_((CompoundTag)nodeTag.m_128469_("pos"));
            N node = this.newNode(pos, false);
            ((GridNode)node).deserializeNBT(nodeTag);
        }
        ListTag edges = nbt.m_128437_("edges", 10);
        for (int i = 0; i < edges.size(); ++i) {
            CompoundTag edgeTag = edges.m_128728_(i);
            BlockPos uPos = NbtUtils.m_129239_((CompoundTag)edgeTag.m_128469_("U"));
            BlockPos vPos = NbtUtils.m_129239_((CompoundTag)edgeTag.m_128469_("V"));
            this.nodeGraph.putEdge((Object)((GridNode)this.nodes.get(uPos)), (Object)((GridNode)this.nodes.get(vPos)));
        }
        ListTag updateable = nbt.m_128437_("updateable", 10);
        for (int i = 0; i < updateable.size(); ++i) {
            CompoundTag updateTag = updateable.m_128728_(i);
            BlockPos pos = NbtUtils.m_129239_((CompoundTag)updateTag.m_128469_("pos"));
            this.updatableHosts.add(pos);
        }
        assert (!DEBUG || this.nodes.values().stream().noneMatch(e -> e.getPos() == BlockPos.f_121853_));
    }

    public abstract N newNode();

    public final N newNode(BlockPos pos) {
        return this.newNode(pos, true);
    }

    public final N newNode(BlockPos pos, boolean load) {
        assert (!this.nodes.containsKey(pos));
        N node = this.newNode();
        ((GridNode)node).setPos(pos);
        GridNode existing = (GridNode)this.nodes.put(pos, node);
        assert (existing == null);
        this.nodeGraph.addNode(node);
        this.getNodesForChunk(pos).add(node);
        if (load) {
            ((GridNode)node).setLoaded(true);
            this.loadedChunks.add(Grid.asChunkLong(pos));
        }
        return node;
    }

    public final void removeNode(N toRemove) {
        boolean ret = this.nodeGraph.removeNode(toRemove);
        assert (ret);
        ret = this.getNodesForChunk(((GridNode)toRemove).getPos()).remove(toRemove);
        assert (ret);
        ret = this.nodes.remove(((GridNode)toRemove).getPos(), toRemove);
        assert (ret);
    }

    public final void insertExistingNode(N toAdd) {
        GridNode existingNode = (GridNode)this.nodes.get(((GridNode)toAdd).getPos());
        if (existingNode == toAdd) {
            return;
        }
        assert (existingNode == null);
        this.nodeGraph.addNode(toAdd);
        this.getNodesForChunk(((GridNode)toAdd).getPos()).add(toAdd);
        this.nodes.put(((GridNode)toAdd).getPos(), toAdd);
        long chunkPos = Grid.asChunkLong(((GridNode)toAdd).getPos());
        if (this.world.m_46749_(((GridNode)toAdd).getPos()) && !this.loadedChunks.contains(chunkPos)) {
            this.loadedChunks.add(chunkPos);
        }
    }

    public final void mergeFrom(G other) {
        assert (this.gridType == ((Grid)other).gridType);
        if (DEBUG) {
            LOGGER.info("Merging {} nodes from grid {} into {}.", (Object)((Grid)other).nodeGraph.nodes().size(), (Object)((Grid)other).id, (Object)this.id);
        }
        PositionCollector positionCollector = new PositionCollector(this.world);
        for (EndpointPair edge : ((Grid)other).nodeGraph.edges()) {
            GridNode a = (GridNode)edge.nodeU();
            GridNode b = (GridNode)edge.nodeV();
            for (BlockPos pos : BlockPos.m_121940_((BlockPos)a.getPos(), (BlockPos)b.getPos())) {
                positionCollector.collectPosition(pos.m_7949_());
            }
            this.nodeGraph.putEdge((Object)a, (Object)b);
        }
        ((Grid)other).nodeGraph.nodes().forEach(e -> positionCollector.collectPosition(e.getPos()));
        this.updateGridHosts(this.world, positionCollector.getChunkPositions(), (Grid)SneakyUtils.unsafeCast(this));
        for (GridNode node : ((Grid)other).nodeGraph.nodes()) {
            this.insertExistingNode(node);
            this.nodeGraph.addNode((Object)node);
            node.setGrid((Grid)SneakyUtils.unsafeCast(this));
            node.onGridChange((Grid)SneakyUtils.unsafeCast(other));
        }
        this.updatableHosts.addAll(((Grid)other).updatableHosts);
        this.onMerge((Grid)SneakyUtils.unsafeCast(other));
    }

    public final List<G> splitInto(List<Set<N>> splitGraphs) {
        GridContainer gridContainer = (GridContainer)IGridContainer.getCapability((LevelAccessor)this.world);
        assert (gridContainer != null);
        LinkedList<G> newGrids = new LinkedList<G>();
        for (Set<N> splitGraph : splitGraphs) {
            PositionCollector positionCollector = new PositionCollector(this.world);
            G newGrid = gridContainer.createAndAddGrid(gridContainer.nextUUID(), this.gridType, true);
            for (GridNode node : splitGraph) {
                positionCollector.collectPosition(node.getPos());
                ((Grid)newGrid).insertExistingNode((GridNode)node);
                for (GridNode adj : this.nodeGraph.adjacentNodes((Object)node)) {
                    ((Grid)newGrid).insertExistingNode((GridNode)adj);
                    for (BlockPos pos : BlockPos.m_121940_((BlockPos)node.getPos(), (BlockPos)adj.getPos())) {
                        positionCollector.collectPosition(pos.m_7949_());
                    }
                    ((Grid)newGrid).nodeGraph.putEdge((Object)node, (Object)adj);
                }
            }
            this.updateGridHosts(this.world, positionCollector.getChunkPositions(), newGrid);
            for (Set positions : positionCollector.getChunkPositions().values()) {
                for (BlockPos position : positions) {
                    if (!this.updatableHosts.remove(position)) continue;
                    ((Grid)newGrid).updatableHosts.add(position);
                }
            }
            for (GridNode node : splitGraph) {
                node.setGrid((Grid)SneakyUtils.unsafeCast(newGrid));
                node.onGridChange((Grid)SneakyUtils.unsafeCast(this));
            }
            newGrids.add(newGrid);
        }
        this.onSplit((List)SneakyUtils.unsafeCast(newGrids));
        return newGrids;
    }

    public final N getNodeOrSplitEdgeAndInsertNode(BlockPos pos) {
        GridNode existing = (GridNode)this.getNodes().get(pos);
        if (existing != null) {
            return (N)existing;
        }
        EndpointPair<N> foundEdge = this.findEdge(pos);
        assert (foundEdge != null);
        GridNode a = (GridNode)foundEdge.nodeU();
        GridNode b = (GridNode)foundEdge.nodeV();
        assert (this.nodeGraph.hasEdgeConnecting((Object)a, (Object)b));
        N abMiddle = this.newNode(pos);
        this.nodeGraph.putEdge(abMiddle, (Object)a);
        this.nodeGraph.putEdge(abMiddle, (Object)b);
        this.nodeGraph.removeEdge((Object)a, (Object)b);
        if (DEBUG) {
            LOGGER.info("Node insertion. Node A: {}, Node B: {}, AB dist: {}, Middle: {}, NewA dist: {}, NewB dist: {}", (Object)a.getPos(), (Object)b.getPos(), (Object)GridHelper.numBetween(a.getPos(), b.getPos()), (Object)((GridNode)abMiddle).getPos(), (Object)GridHelper.numBetween(pos, a.getPos()), (Object)GridHelper.numBetween(pos, b.getPos()));
        }
        return abMiddle;
    }

    private void updateGridHosts(Level world, Long2ObjectMap<Set<BlockPos>> posMap, G grid) {
        for (Long2ObjectMap.Entry entry : posMap.long2ObjectEntrySet()) {
            long chunkPos = entry.getLongKey();
            LevelChunk chunk = world.m_6325_(ChunkPos.m_45592_((long)chunkPos), ChunkPos.m_45602_((long)chunkPos));
            for (BlockPos pos : (Set)entry.getValue()) {
                IDuct<?, ?> gridHost = GridHelper.getGridHost(chunk.m_7702_(pos));
                if (gridHost == null) {
                    LOGGER.error("Node not connected to grid! Chunk modified externally. {}", (Object)pos);
                    continue;
                }
                gridHost.setGrid((Grid)SneakyUtils.unsafeCast(grid));
            }
        }
    }

    public void onModified() {
        if (DEBUG) {
            this.checkInvariant();
        }
    }

    protected void updateHosts() {
        for (BlockPos pos : this.updatableHosts) {
            BlockEntity blockEntity;
            if (!this.world.m_46749_(pos) || !((blockEntity = this.world.m_7702_(pos)) instanceof IGridHostUpdateable)) continue;
            IGridHostUpdateable host = (IGridHostUpdateable)blockEntity;
            host.update();
        }
    }

    public abstract void onMerge(G var1);

    public abstract void onSplit(List<G> var1);

    public void onGridHostAdded(IDuct<?, ?> host) {
        if (host instanceof IGridHostUpdateable) {
            IGridHostUpdateable uHost = (IGridHostUpdateable)((Object)host);
            this.updatableHosts.add(host.getHostPos());
            uHost.update();
        }
    }

    public void onGridHostRemoved(IDuct<?, ?> host) {
        if (host instanceof IGridHostUpdateable) {
            this.updatableHosts.remove(host.getHostPos());
        }
    }

    @Nullable
    public final EndpointPair<N> findEdge(BlockPos pos) {
        for (EndpointPair edge : this.nodeGraph.edges()) {
            if (!this.isOnEdge(pos, edge)) continue;
            return edge;
        }
        return null;
    }

    public final boolean isConnectedTo(BlockPos a, BlockPos b) {
        GridNode aNode = (GridNode)this.nodes.get(a);
        GridNode bNode = (GridNode)this.nodes.get(b);
        if (aNode != null && bNode != null) {
            return this.nodeGraph.hasEdgeConnecting((Object)aNode, (Object)bNode);
        }
        if (aNode == null && bNode == null) {
            return this.isOnEdge(b, Objects.requireNonNull(this.findEdge(a)));
        }
        GridNode node = aNode != null ? aNode : bNode;
        BlockPos pos = aNode != null ? b : a;
        for (EndpointPair edge : this.nodeGraph.incidentEdges((Object)node)) {
            if (!this.isOnEdge(pos, edge)) continue;
            return true;
        }
        return false;
    }

    public final UUID getId() {
        return this.id;
    }

    public final Level getLevel() {
        return this.world;
    }

    public IGridType<G> getGridType() {
        return this.gridType;
    }

    public final Map<BlockPos, N> getNodes() {
        return this.nodes;
    }

    public boolean canConnectExternally(BlockPos pos) {
        for (Direction dir : Constants.DIRECTIONS) {
            if (!this.canConnectOnSide(pos.m_121945_(dir), dir.m_122424_())) continue;
            return true;
        }
        return false;
    }

    public abstract boolean canConnectOnSide(BlockEntity var1, @javax.annotation.Nullable Direction var2);

    public boolean canConnectOnSide(BlockPos pos, @javax.annotation.Nullable Direction dir) {
        BlockEntity tile = this.getLevel().m_7702_(pos);
        if (tile == null) {
            return false;
        }
        return this.canConnectOnSide(tile, dir);
    }

    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap) {
        return LazyOptional.empty();
    }

    public final void debugWriteToPacket(FriendlyByteBuf buffer) {
        buffer.m_130077_(this.getId());
        buffer.m_130130_(this.nodes.size());
        for (GridNode node : this.nodes.values()) {
            buffer.m_130064_(node.getPos());
            Set edges = this.nodeGraph.adjacentNodes((Object)node);
            buffer.m_130130_(edges.size());
            for (GridNode edge : edges) {
                buffer.m_130064_(edge.getPos());
            }
        }
    }

    public abstract void refreshCapabilities();

    private boolean isOnEdge(BlockPos pos, EndpointPair<N> edge) {
        return GridHelper.isOnEdge(pos, ((GridNode)edge.nodeU()).getPos(), ((GridNode)edge.nodeV()).getPos());
    }

    private List<N> getNodesForChunk(BlockPos pos) {
        return (List)this.nodesPerChunk.computeIfAbsent(Grid.asChunkLong(pos), e -> new LinkedList());
    }

    private static long asChunkLong(BlockPos pos) {
        return ChunkPos.m_45589_((int)(pos.m_123341_() >> 4), (int)(pos.m_123343_() >> 4));
    }

    private static class PositionCollector {
        private static final LongFunction<Set<BlockPos>> FACTORY = e -> new HashSet();
        private final Level world;
        private final Long2ObjectMap<Set<BlockPos>> chunkPositions = new Long2ObjectOpenHashMap();
        private final LongSet loadedChunks = new LongOpenHashSet();
        private final LongSet unloadedChunks = new LongOpenHashSet();

        private PositionCollector(Level world) {
            this.world = world;
        }

        public void collectPosition(BlockPos pos) {
            long chunkLong = Grid.asChunkLong(pos);
            if (this.unloadedChunks.contains(chunkLong)) {
                return;
            }
            if (!this.loadedChunks.contains(chunkLong)) {
                if (!this.world.m_46749_(pos)) {
                    this.unloadedChunks.add(chunkLong);
                    return;
                }
                this.loadedChunks.add(chunkLong);
            }
            ((Set)this.chunkPositions.computeIfAbsent(chunkLong, FACTORY)).add(pos);
        }

        public Long2ObjectMap<Set<BlockPos>> getChunkPositions() {
            return this.chunkPositions;
        }
    }
}

