/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.dynamics;

import cofh.lib.common.network.PacketHandler;
import cofh.lib.util.DeferredRegisterCoFH;
import cofh.thermal.core.ThermalCore;
import cofh.thermal.dynamics.api.grid.IGridContainer;
import cofh.thermal.dynamics.api.grid.IGridType;
import cofh.thermal.dynamics.client.DebugRenderer;
import cofh.thermal.dynamics.client.gui.ItemBufferScreen;
import cofh.thermal.dynamics.client.gui.attachment.EnergyLimiterAttachmentScreen;
import cofh.thermal.dynamics.client.gui.attachment.FluidFilterAttachmentScreen;
import cofh.thermal.dynamics.client.gui.attachment.FluidServoAttachmentScreen;
import cofh.thermal.dynamics.client.gui.attachment.FluidTurboServoAttachmentScreen;
import cofh.thermal.dynamics.common.network.packet.client.AttachmentControlPacket;
import cofh.thermal.dynamics.common.network.packet.client.GridDebugPacket;
import cofh.thermal.dynamics.common.network.packet.server.AttachmentConfigPacket;
import cofh.thermal.dynamics.common.network.packet.server.AttachmentRedstoneControlPacket;
import cofh.thermal.dynamics.handler.GridEvents;
import cofh.thermal.dynamics.init.registries.TDynBlockEntities;
import cofh.thermal.dynamics.init.registries.TDynBlocks;
import cofh.thermal.dynamics.init.registries.TDynContainers;
import cofh.thermal.dynamics.init.registries.TDynGrids;
import cofh.thermal.dynamics.init.registries.TDynItems;
import cofh.thermal.lib.util.ThermalFlags;
import java.util.function.Supplier;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryBuilder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="thermal_dynamics")
public class ThermalDynamics {
    public static final Logger LOG = LogManager.getLogger((String)"thermal_dynamics");
    public static final PacketHandler PACKET_HANDLER = new PacketHandler(new ResourceLocation("thermal_dynamics", "general"), LOG);
    public static final ResourceLocation GRID_REGISTRY_LOC = new ResourceLocation("thermal_dynamics", "grid_type");
    public static final DeferredRegisterCoFH<IGridType<?>> GRIDS = DeferredRegisterCoFH.create((ResourceLocation)GRID_REGISTRY_LOC, (String)"thermal_dynamics");
    public static final Supplier<IForgeRegistry<IGridType<?>>> GRID_TYPE_REGISTRY = GRIDS.makeRegistry(() -> new RegistryBuilder().disableOverrides().disableSaving());

    public ThermalDynamics() {
        this.setFeatureFlags();
        this.registerPackets();
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::commonSetup);
        modEventBus.addListener(this::clientSetup);
        modEventBus.addListener(this::capSetup);
        GRIDS.register(modEventBus);
        TDynBlocks.register();
        TDynItems.register();
        TDynGrids.register();
        TDynContainers.register();
        TDynBlockEntities.register();
        GridEvents.register();
    }

    private void registerPackets() {
        PACKET_HANDLER.registerPacket(1, AttachmentControlPacket::new);
        PACKET_HANDLER.registerPacket(32, AttachmentConfigPacket::new);
        PACKET_HANDLER.registerPacket(34, AttachmentRedstoneControlPacket::new);
        PACKET_HANDLER.registerPacket(100, GridDebugPacket::new);
    }

    private void setFeatureFlags() {
        ThermalFlags.setFlag((String)"device_collector", (boolean)true);
        ThermalFlags.setFlag((String)"device_nullifier", (boolean)true);
        ThermalFlags.setFlag((String)ThermalFlags.FLAG_XP_STORAGE_AUGMENT, (boolean)true);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
    }

    private void clientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(this::registerGuiFactories);
        event.enqueueWork(this::registerRenderLayers);
        DebugRenderer.register();
    }

    private void capSetup(RegisterCapabilitiesEvent event) {
        event.register(IGridContainer.class);
    }

    private void registerGuiFactories() {
        MenuScreens.m_96206_((MenuType)((MenuType)TDynContainers.ITEM_BUFFER_CONTAINER.get()), ItemBufferScreen::new);
        MenuScreens.m_96206_((MenuType)((MenuType)TDynContainers.ENERGY_LIMITER_ATTACHMENT_CONTAINER.get()), EnergyLimiterAttachmentScreen::new);
        MenuScreens.m_96206_((MenuType)((MenuType)TDynContainers.FLUID_FILTER_ATTACHMENT_CONTAINER.get()), FluidFilterAttachmentScreen::new);
        MenuScreens.m_96206_((MenuType)((MenuType)TDynContainers.FLUID_SERVO_ATTACHMENT_CONTAINER.get()), FluidServoAttachmentScreen::new);
        MenuScreens.m_96206_((MenuType)((MenuType)TDynContainers.FLUID_TURBO_SERVO_ATTACHMENT_CONTAINER.get()), FluidTurboServoAttachmentScreen::new);
    }

    private void registerRenderLayers() {
        RenderType cutout = RenderType.m_110463_();
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ThermalCore.BLOCKS.get("energy_duct")), (RenderType)cutout);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ThermalCore.BLOCKS.get("fluid_duct")), (RenderType)cutout);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ThermalCore.BLOCKS.get("fluid_duct_windowed")), (RenderType)cutout);
    }
}

