/*
 * Decompiled with CFR 0.152.
 */
package cofh.requack.gson;

import cofh.requack.annotation.Requires;
import com.google.common.hash.HashCode;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import org.jetbrains.annotations.Nullable;

@Requires.RequiresList(value={@Requires(value="com.google.guava:guava"), @Requires(value="com.google.code.gson:gson")})
public class HashCodeAdapter
extends TypeAdapter<HashCode> {
    public void write(JsonWriter out, @Nullable HashCode value) throws IOException {
        if (value == null) {
            out.nullValue();
            return;
        }
        out.value(value.toString());
    }

    @Nullable
    public HashCode read(JsonReader in) throws IOException {
        if (in.peek() == JsonToken.NULL) {
            in.nextNull();
            return null;
        }
        String s = in.nextString();
        if (s.isEmpty()) {
            return null;
        }
        return HashCode.fromString((String)s);
    }
}

