/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsstorage.modules.scanner.items;

import java.util.Collection;
import java.util.Objects;
import mcjty.lib.varia.BlockPosTools;
import mcjty.lib.varia.ComponentFactory;
import mcjty.lib.varia.ItemStackList;
import mcjty.lib.varia.ItemStackTools;
import mcjty.lib.varia.LevelTools;
import mcjty.lib.varia.TagTools;
import mcjty.rftoolsbase.api.screens.IScreenDataHelper;
import mcjty.rftoolsbase.api.screens.IScreenModule;
import mcjty.rftoolsbase.api.screens.data.IModuleData;
import mcjty.rftoolsbase.api.screens.data.IModuleDataBoolean;
import mcjty.rftoolsbase.api.storage.IStorageScanner;
import mcjty.rftoolsstorage.modules.scanner.StorageScannerConfiguration;
import mcjty.rftoolsstorage.modules.scanner.items.StorageControlScreenModule;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class DumpScreenModule
implements IScreenModule<IModuleData> {
    public static final int COLS = 7;
    public static final int ROWS = 4;
    private final ItemStackList stacks = ItemStackList.create((int)28);
    protected ResourceKey<Level> dim = Level.f_46428_;
    protected BlockPos coordinate = BlockPosTools.INVALID;
    private boolean matchingTag = false;

    public IModuleDataBoolean getData(IScreenDataHelper helper, Level worldObj, long millis) {
        return null;
    }

    public void setupFromNBT(CompoundTag tagCompound, ResourceKey<Level> dim, BlockPos pos) {
        if (tagCompound != null) {
            this.setupCoordinateFromNBT(tagCompound, dim, pos);
            for (int i = 0; i < this.stacks.size(); ++i) {
                if (!tagCompound.m_128441_("stack" + i)) continue;
                this.stacks.set(i, (Object)ItemStack.m_41712_((CompoundTag)tagCompound.m_128469_("stack" + i)));
            }
        }
    }

    protected void setupCoordinateFromNBT(CompoundTag tagCompound, ResourceKey<Level> dim, BlockPos pos) {
        this.coordinate = BlockPosTools.INVALID;
        this.matchingTag = tagCompound.m_128471_("matchingTag");
        if (tagCompound.m_128441_("monitorx")) {
            this.dim = LevelTools.getId((String)tagCompound.m_128461_("monitordim"));
            if (Objects.equals(dim, this.dim)) {
                BlockPos c = new BlockPos(tagCompound.m_128451_("monitorx"), tagCompound.m_128451_("monitory"), tagCompound.m_128451_("monitorz"));
                int dx = Math.abs(c.m_123341_() - pos.m_123341_());
                int dy = Math.abs(c.m_123342_() - pos.m_123342_());
                int dz = Math.abs(c.m_123343_() - pos.m_123343_());
                if (dx <= 64 && dy <= 64 && dz <= 64) {
                    this.coordinate = c;
                }
            }
        }
    }

    private boolean isShown(ItemStack stack) {
        if (stack.m_41619_()) {
            return false;
        }
        for (ItemStack s : this.stacks) {
            if (this.isItemEqual(stack, s)) {
                return true;
            }
            if (!this.matchingTag || !ItemStackTools.hasCommonTag((Collection)TagTools.getTags((Item)s.m_41720_()))) continue;
            return true;
        }
        return false;
    }

    public boolean isItemEqual(ItemStack thisItem, ItemStack other) {
        if (other.m_41619_()) {
            return false;
        }
        return ItemStack.m_41656_((ItemStack)thisItem, (ItemStack)other);
    }

    public void mouseClick(Level world, int x, int y, boolean clicked, Player player) {
        if (!clicked || player == null) {
            return;
        }
        if (BlockPosTools.INVALID.equals((Object)this.coordinate)) {
            player.m_5661_((Component)ComponentFactory.literal((String)(ChatFormatting.RED + "Module is not linked to storage scanner!")), false);
            return;
        }
        IStorageScanner scannerTileEntity = StorageControlScreenModule.getStorageScanner(world, this.dim, this.coordinate);
        if (scannerTileEntity == null) {
            return;
        }
        int xoffset = 5;
        if (x >= xoffset) {
            for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
                if (!this.isShown(player.m_150109_().m_8020_(i))) continue;
                ItemStack stack = scannerTileEntity.injectStackFromScreen(player.m_150109_().m_8020_(i), player);
                player.m_150109_().m_6836_(i, stack);
            }
            player.f_36096_.m_38946_();
        }
    }

    public int getRfPerTick() {
        return (Integer)StorageScannerConfiguration.DUMP_RFPERTICK.get();
    }
}

